/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import net.turtleboi.bytebuddies.screen.custom.slot.BuddySlot;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyMenu
extends AbstractContainerMenu {
    public final ByteBuddyEntity byteBuddy;
    public final Inventory playerInv;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 36;
    private static final int SLOT_SIZE = 18;

    public ByteBuddyMenu(int containerId, Inventory playerInv, ByteBuddyEntity byteBuddy) {
        super((MenuType)ModMenuTypes.BUDDY_MENU.get(), containerId);
        this.playerInv = playerInv;
        this.byteBuddy = byteBuddy;
        if (!playerInv.f_35978_.m_9236_().f_46443_ && this.byteBuddy != null) {
            this.byteBuddy.onMenuOpened(playerInv.f_35978_);
        }
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addBuddyInventory();
        this.addBuddyAugments();
        this.addBuddyUpgrades();
        this.addBuddyClipboard();
    }

    public static ByteBuddyMenu clientFactory(int buddyId, Inventory inventory, FriendlyByteBuf byteBuf) {
        ByteBuddyEntity byteBuddy;
        int entityId = byteBuf.readInt();
        Entity entity = inventory.f_35978_.m_9236_().m_6815_(entityId);
        return new ByteBuddyMenu(buddyId, inventory, entity instanceof ByteBuddyEntity ? (byteBuddy = (ByteBuddyEntity)entity) : null);
    }

    public LivingEntity getByteBuddy() {
        return this.byteBuddy;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_ && this.byteBuddy != null) {
            this.byteBuddy.onMenuClosed(player);
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 72, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 72) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.byteBuddy != null && this.byteBuddy.m_6084_() && (double)player.m_20270_((Entity)this.byteBuddy) < 4.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 21;
        int startY = 145;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 21;
        int startY = 203;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addBuddyInventory() {
        if (this.byteBuddy == null) {
            return;
        }
        int baseX = 75;
        int baseY = 63;
        int slot = 9;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), slot++, baseX + col * 18, baseY + row * 18));
            }
        }
        int add9X = 10000;
        for (int i = 18; i <= 26; ++i) {
            int idx = i - 18;
            int x = add9X + idx % 3 * 18;
            int y = baseY + idx / 3 * 18;
            this.m_38897_((Slot)new BuddySlot((IItemHandler)this.byteBuddy.getMainInv(), i, x, y, () -> this.byteBuddy.getStorageCellsExtraSlots() >= 9));
        }
        int add18X = 10000;
        for (int i = 27; i <= 35; ++i) {
            int idx = i - 27;
            int x = add18X + idx % 3 * 18;
            int y = baseY + idx / 3 * 18;
            this.m_38897_((Slot)new BuddySlot((IItemHandler)this.byteBuddy.getMainInv(), i, x, y, () -> this.byteBuddy.getStorageCellsExtraSlots() == 18));
        }
    }

    private void addBuddyAugments() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 33;
        int startY = 54;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 0, startX, startY){

            public boolean m_5857_(ItemStack itemStack) {
                return ByteBuddyEntity.isAnyTool(itemStack);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_tool"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 1, startX, startY + 18){

            public boolean m_5857_(ItemStack itemStack) {
                ItemStack other;
                if (itemStack.m_41619_()) {
                    return false;
                }
                if (!itemStack.m_204117_(ModTags.Items.AUGMENT)) {
                    return false;
                }
                return !itemStack.m_204117_(ModTags.Items.PLATING) || (other = ByteBuddyMenu.this.byteBuddy.getMainInv().getStackInSlot(2)).m_41619_() || !other.m_204117_(ModTags.Items.PLATING);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_augment"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 2, startX, startY + 36){

            public boolean m_5857_(ItemStack itemStack) {
                ItemStack other;
                if (itemStack.m_41619_()) {
                    return false;
                }
                if (!itemStack.m_204117_(ModTags.Items.AUGMENT)) {
                    return false;
                }
                return !itemStack.m_204117_(ModTags.Items.PLATING) || (other = ByteBuddyMenu.this.byteBuddy.getMainInv().getStackInSlot(1)).m_41619_() || !other.m_204117_(ModTags.Items.PLATING);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_augment"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 3, startX, startY + 54){

            public boolean m_5857_(ItemStack itemStack) {
                return InventoryUtil.isBattery(itemStack);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_battery"));
            }
        });
    }

    private void addBuddyUpgrades() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 153;
        int startY = 54;
        for (int u = 4; u < 8; ++u) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), u, startX, startY + (u - 4) * 18){

                public boolean m_5857_(ItemStack itemStack) {
                    return InventoryUtil.isFloppyDisk(itemStack);
                }

                public int m_6641_() {
                    return 1;
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_floppy_disk"));
                }
            });
        }
    }

    private void addBuddyClipboard() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 136;
        int startY = 17;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 8, startX, startY){

            public boolean m_5857_(ItemStack itemStack) {
                return InventoryUtil.isClipboard(itemStack);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_clipboard"));
            }
        });
    }

    public boolean farmingEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isFarmingEnabled();
    }

    public boolean harvestEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isHarvestEnabled();
    }

    public boolean plantEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isPlantEnabled();
    }

    public boolean tillEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isTillEnabled();
    }

    public int getEnergyStored() {
        if (this.byteBuddy.m_9236_().f_46443_) {
            return this.byteBuddy.getSyncedEnergy();
        }
        return this.byteBuddy.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.byteBuddy != null ? this.byteBuddy.getEnergyStorage().getMaxEnergyStored() : 0;
    }

    public double getHealth() {
        if (this.byteBuddy.m_9236_().f_46443_) {
            return this.byteBuddy.m_21223_();
        }
        return 0.0;
    }

    public double getMaxHealth() {
        return this.byteBuddy != null ? (double)this.byteBuddy.m_21233_() : 0.0;
    }

    public void m_38946_() {
        boolean mismatch;
        super.m_38946_();
        Player player = this.playerInv.f_35978_;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.byteBuddy == null || !this.byteBuddy.m_6084_()) {
            return;
        }
        int extraSlots = this.byteBuddy.getStorageCellsExtraSlots();
        boolean bl = mismatch = extraSlots != 0;
        if (mismatch) {
            serverPlayer.m_6915_();
            ByteBuddyEntity.openStorageMenu(serverPlayer, this.byteBuddy);
        }
    }
}

