/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.SolarPanelMenu;
import org.jetbrains.annotations.NotNull;

public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/solar_panel_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/gui_addons.png");
    private static final int energyX = 80;
    private static final int energyY = 23;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private boolean debugEnergyOverride = false;
    private double debugFillPct = 0.5;

    public SolarPanelScreen(SolarPanelMenu solarPanelMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)solarPanelMenu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 205;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawEnergyBar(guiGraphics, x + 80, y + 23);
        this.drawGenerationBolt(guiGraphics, x + 82, y + 5);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.m_14045_((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.m_14045_((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.f_97735_ + 80;
        int absoluteY = this.f_97736_ + 23;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.m_237113_((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.m_280677_(this.f_96547_, List.of(line1), Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawGenerationBolt(GuiGraphics guiGraphics, int x, int y) {
        if (this.getGenerating()) {
            guiGraphics.m_280163_(GUI_TEXTURE, x, y, 176.0f, 0.0f, 12, 15, 256, 256);
        } else {
            guiGraphics.m_280163_(GUI_TEXTURE, x, y, 188.0f, 0.0f, 12, 15, 256, 256);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((SolarPanelMenu)this.f_97732_).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((SolarPanelMenu)this.f_97732_).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private boolean getGenerating() {
        try {
            return ((SolarPanelMenu)this.f_97732_).getGeneratingBinary();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

