/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.network.ModNetworking;
import net.turtleboi.bytebuddies.network.packets.ReloadBuddyC2SPacket;
import net.turtleboi.bytebuddies.network.packets.SleepDataC2SPacket;
import net.turtleboi.bytebuddies.network.packets.TeleportDataC2SPacket;
import net.turtleboi.bytebuddies.screen.custom.menu.DockingStationMenu;
import net.turtleboi.bytebuddies.screen.custom.widget.TinyIconButton;
import org.jetbrains.annotations.NotNull;

public class DockingStationScreen
extends AbstractContainerScreen<DockingStationMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/docking_station_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/gui_addons.png");
    private static final int energyX = 6;
    private static final int energyY = 53;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private static final int buddyPreviewX = 71;
    private static final int buddyPreviewY = 6;
    private static final int buddyPreviewWidth = 38;
    private static final int buddyPreviewHeight = 38;
    private static final int buddyPreviewU = 71;
    private static final int buddyPreviewV = 6;
    private static final int infoX = 114;
    private static final int infoY = 7;
    private static final int infoW = 54;
    private static final int infoH = 22;
    private boolean debugEnergyOverride = false;
    private double debugFillPct = 0.5;
    private int selected = 0;
    private Button previousButton;
    private Button nextButton;
    private Button sleepButton;
    private Button restartButton;
    private Button teleportButton;

    public DockingStationScreen(DockingStationMenu dockingStationMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)dockingStationMenu, inventory, title);
        this.f_97726_ = 240;
        this.f_97727_ = 227;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int bx = x + 71;
        int by = y + 6;
        this.previousButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.cycleBuddy(-1)).m_252987_(bx - 20, by + 19 - 6, 12, 12).m_253136_());
        this.nextButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.cycleBuddy(1)).m_252987_(bx + 38 + 68, by + 19 - 6, 12, 12).m_253136_());
        this.sleepButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.setSleepStatus(Objects.requireNonNull(((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected)))).m_252987_(bx + 44, by + 26, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Sleep Buddy"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 24, this::isSleepLocked)));
        this.restartButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.reloadBuddy(Objects.requireNonNull(((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected)))).m_252987_(bx + 64, by + 26, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Reset Job"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 72, this::isRestartLocked)));
        this.teleportButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.teleportBuddy(Objects.requireNonNull(((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected)))).m_252987_(bx + 84, by + 26, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Teleport to Dock"))).build(TinyIconButton.buttonFactory(GUI_ADDONS_TEXTURE, 128, 128, 32, 96, this::isTeleportLocked)));
        this.updateNavState();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280163_(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        this.drawBuddyPreview(guiGraphics, x + 71, y + 6, (float)(x + 71) + 19.0f - (float)mouseX, (float)(y + 6) + 19.0f - (float)mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawEnergyBar(guiGraphics, x + 6, y + 53);
        this.drawBuddyInfo(guiGraphics, x + 114, y + 7);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.m_14045_((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.m_14045_((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.f_97735_ + 6;
        int absoluteY = this.f_97736_ + 53;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.m_237113_((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.m_280677_(this.f_96547_, List.of(line1), Optional.empty(), mouseX, mouseY);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((DockingStationMenu)this.f_97732_).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((DockingStationMenu)this.f_97732_).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void drawBuddyPreview(GuiGraphics guiGraphics, int previewX, int previewY, float mouseX, float mouseY) {
        guiGraphics.m_280163_(GUI_TEXTURE, previewX, previewY, 71.0f, 6.0f, 38, 38, 256, 256);
        ByteBuddyEntity entity = ((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected);
        if (entity == null) {
            return;
        }
        float entityHeight = Math.max(0.6f, entity.m_20206_());
        float targetScale = 24.699999f;
        int scale = Math.max(8, Mth.m_14143_((float)(24.699999f / entityHeight)));
        int centerX = previewX + 19;
        int centerY = previewY + 38 - 4;
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)centerX, (int)centerY, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    private void drawBuddyInfo(GuiGraphics guiGraphics, int boxX, int boxY) {
        ByteBuddyEntity entity = ((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected);
        if (entity == null) {
            return;
        }
        String name = entity.m_7755_().getString();
        String role = entity.getBuddyRole().name();
        BlockPos pos = entity.m_20183_();
        String coords = "(" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + ")";
        String[] lines = new String[]{name, "Role: " + role, coords};
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        int rawHeight = lines.length * lineHeight;
        int maxWidth = 0;
        for (String string : lines) {
            maxWidth = Math.max(maxWidth, this.f_96547_.m_92895_(string));
        }
        if (maxWidth == 0 || rawHeight == 0) {
            return;
        }
        float scaleX = 54.0f / (float)maxWidth;
        float scaleY = 22.0f / (float)rawHeight;
        float scale = Math.min(scaleX, scaleY);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)boxX, (float)boxY, 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        int drawAreaWScaled = Mth.m_14143_((float)(54.0f / scale));
        int drawAreaHScaled = Mth.m_14143_((float)(22.0f / scale));
        int y = Math.max(0, (drawAreaHScaled - rawHeight) / 2);
        for (String string : lines) {
            int fontWidth = this.f_96547_.m_92895_(string);
            int x = (drawAreaWScaled - fontWidth) / 2;
            guiGraphics.m_280056_(this.f_96547_, string, x, y, 0xFFFFFF, false);
            y += lineHeight;
        }
        pose.m_85849_();
    }

    private void cycleBuddy(int delta) {
        int count = ((DockingStationMenu)this.f_97732_).getBuddyCount();
        if (count <= 0) {
            return;
        }
        this.selected = (this.selected + delta) % count;
        if (this.selected < 0) {
            this.selected += count;
        }
        this.updateNavState();
    }

    private void setSleepStatus(ByteBuddyEntity byteBuddyEntity) {
        boolean asleep = byteBuddyEntity.m_5803_();
        ModNetworking.sendToServer(new SleepDataC2SPacket(byteBuddyEntity.m_19879_(), !asleep));
    }

    private void reloadBuddy(ByteBuddyEntity byteBuddyEntity) {
        ModNetworking.sendToServer(new ReloadBuddyC2SPacket(byteBuddyEntity.m_19879_()));
    }

    private void teleportBuddy(ByteBuddyEntity byteBuddyEntity) {
        ModNetworking.sendToServer(new TeleportDataC2SPacket(byteBuddyEntity.m_19879_(), (double)((DockingStationMenu)this.f_97732_).dockBlock.m_58899_().m_123341_() + 0.5, ((DockingStationMenu)this.f_97732_).dockBlock.m_58899_().m_123342_() + 1, (double)((DockingStationMenu)this.f_97732_).dockBlock.m_58899_().m_123343_() + 0.5));
    }

    private void updateNavState() {
        boolean enable;
        int count = ((DockingStationMenu)this.f_97732_).getBuddyCount();
        boolean bl = enable = count > 1;
        if (this.previousButton != null) {
            this.previousButton.f_93623_ = enable;
        }
        if (this.nextButton != null) {
            this.nextButton.f_93623_ = enable;
        }
        this.sleepButton.f_93623_ = count > 0;
        this.restartButton.f_93623_ = count > 0;
        boolean bl2 = this.teleportButton.f_93623_ = count > 0;
        if (count == 0) {
            this.selected = 0;
        } else if (this.selected >= count) {
            this.selected = count - 1;
        }
    }

    private boolean isSleepLocked() {
        return ((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected) == null;
    }

    private boolean isRestartLocked() {
        return ((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected) == null;
    }

    private boolean isTeleportLocked() {
        return ((DockingStationMenu)this.f_97732_).getBuddyByIndexClient(this.selected) == null || this.getEnergyStoredSafe() < 50L;
    }
}

