/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.network.ModNetworking;
import net.turtleboi.bytebuddies.network.packets.RoleDataC2SPacket;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyTripleMenu;
import net.turtleboi.bytebuddies.screen.custom.widget.TinyIconButton;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyTripleScreen
extends AbstractContainerScreen<ByteBuddyTripleMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/bytebuddy_triple_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = new ResourceLocation("bytebuddies", "textures/gui/gui_addons.png");
    private static final int energyX = 6;
    private static final int energyY = 64;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private static final int buddyPreviewX = 130;
    private static final int buddyPreviewY = 6;
    private static final int buddyPreviewWidth = 38;
    private static final int buddyPreviewHeight = 38;
    private static final int buddyPreviewU = 130;
    private static final int buddyPreviewV = 6;
    private static final int healthX = 276;
    private static final int healthY = 64;
    private static final int healthWidth = 16;
    private static final int healthHeight = 52;
    private static final int healthEmptyU = 16;
    private static final int healthEmptyV = 52;
    private static final int healthFullU = 0;
    private static final int healthFullV = 52;
    private boolean debugEnergyOverride = false;
    private boolean debugHealthOverride = false;
    private double debugFillPct = 0.5;

    public ByteBuddyTripleScreen(ByteBuddyTripleMenu buddyMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)buddyMenu, inventory, title);
        this.f_97726_ = 298;
        this.f_97727_ = 227;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.setFarmer(((ByteBuddyTripleMenu)this.f_97732_).byteBuddy)).m_252987_(x + 120, y + 124, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Farmer"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 8, 112, 8, 104, 2, 2))));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.setMiner(((ByteBuddyTripleMenu)this.f_97732_).byteBuddy)).m_252987_(x + 135, y + 124, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Miner"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 0, 112, 0, 104, 2, 2))));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.setHauler(((ByteBuddyTripleMenu)this.f_97732_).byteBuddy)).m_252987_(x + 151, y + 124, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Hauler"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 16, 112, 16, 104, 2, 2))));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.setFighter(((ByteBuddyTripleMenu)this.f_97732_).byteBuddy)).m_252987_(x + 166, y + 124, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Fighter"))).build(TinyIconButton.buttonFactoryWithIcon(GUI_ADDONS_TEXTURE, 128, 128, 32, 0, null, new TinyIconButton.MiniIcon(GUI_ADDONS_TEXTURE, 128, 128, 24, 112, 24, 104, 2, 2))));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280163_(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        this.drawBuddyPreview(guiGraphics, x + 130, y + 6, (float)(x + 130) + 19.0f - (float)mouseX, (float)(y + 6) + 19.0f - (float)mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawEnergyBar(guiGraphics, x + 6, y + 64);
        this.drawHealthBar(guiGraphics, x + 276, y + 64);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
        this.drawHealthToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.m_14045_((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.m_14045_((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.f_97735_ + 6;
        int absoluteY = this.f_97736_ + 64;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.m_237113_((String)"Energy: ");
            MutableComponent line2 = Component.m_237113_((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.m_280677_(this.f_96547_, List.of(line1, line2), Optional.empty(), mouseX, mouseY);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((ByteBuddyTripleMenu)this.f_97732_).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((ByteBuddyTripleMenu)this.f_97732_).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private void drawHealthBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, y, 16.0f, 52.0f, 16, 52, 128, 128);
        if (this.debugHealthOverride) {
            filled = Mth.m_14045_((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            double health = this.getHealthSafe();
            double healthMax = Math.max(1.0, this.getMaxHealthSafe());
            filled = Mth.m_14045_((int)((int)Math.round(health * 52.0 / healthMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 52 + dy;
        guiGraphics.m_280163_(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawHealthToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.f_97735_ + 276;
        int absoluteY = this.f_97736_ + 64;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            double health = this.getHealthSafe();
            double healthMax = Math.max(1.0, this.getMaxHealthSafe());
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            MutableComponent line1 = Component.m_237113_((String)"Health: ");
            MutableComponent line2 = Component.m_237113_((String)(decimalFormat.format(health) + " / " + decimalFormat.format(healthMax)));
            guiGraphics.m_280677_(this.f_96547_, List.of(line1, line2), Optional.empty(), mouseX, mouseY);
        }
    }

    private double getHealthSafe() {
        try {
            return Math.max(0.0, ((ByteBuddyTripleMenu)this.f_97732_).getHealth());
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private double getMaxHealthSafe() {
        try {
            return Math.max(1.0, ((ByteBuddyTripleMenu)this.f_97732_).getMaxHealth());
        }
        catch (Throwable t) {
            return 1.0;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void drawBuddyPreview(GuiGraphics guiGraphics, int previewX, int previewY, float mouseX, float mouseY) {
        guiGraphics.m_280163_(GUI_TEXTURE, previewX, previewY, 130.0f, 6.0f, 38, 38, 512, 256);
        LivingEntity entity = this.getPreviewEntity();
        if (entity == null) {
            return;
        }
        float entityHeight = Math.max(0.6f, entity.m_20206_());
        float targetScale = 24.699999f;
        int scale = Math.max(8, Mth.m_14143_((float)(24.699999f / entityHeight)));
        int centerX = previewX + 19;
        int centerY = previewY + 38 - 4;
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)centerX, (int)centerY, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    private LivingEntity getPreviewEntity() {
        try {
            return ((ByteBuddyTripleMenu)this.f_97732_).getByteBuddy();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void setFarmer(ByteBuddyEntity byteBuddy) {
        ModNetworking.sendToServer(new RoleDataC2SPacket(byteBuddy.m_19879_(), 1));
    }

    private void setMiner(ByteBuddyEntity byteBuddy) {
        ModNetworking.sendToServer(new RoleDataC2SPacket(byteBuddy.m_19879_(), 2));
    }

    private void setHauler(ByteBuddyEntity byteBuddy) {
        ModNetworking.sendToServer(new RoleDataC2SPacket(byteBuddy.m_19879_(), 5));
    }

    private void setFighter(ByteBuddyEntity byteBuddy) {
        ModNetworking.sendToServer(new RoleDataC2SPacket(byteBuddy.m_19879_(), 3));
    }
}

