/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class TeleportDataC2SPacket {
    private final int entityId;
    private final double blockX;
    private final double blockY;
    private final double blockZ;

    public TeleportDataC2SPacket(int entityId, double blockX, double blockY, double blockZ) {
        this.entityId = entityId;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
    }

    public TeleportDataC2SPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.blockX = buf.readDouble();
        this.blockY = buf.readDouble();
        this.blockZ = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeDouble(this.blockX);
        buf.writeDouble(this.blockY);
        buf.writeDouble(this.blockZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ByteBuddyEntity byteBuddyEntity;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel serverLevel = player.m_284548_();
            Entity entity = serverLevel.m_6815_(this.entityId);
            if (entity instanceof ByteBuddyEntity && (byteBuddyEntity = (ByteBuddyEntity)entity).isOwnedBy((LivingEntity)player)) {
                byteBuddyEntity.m_21391_((Entity)player, 15.0f, 15.0f);
                entity.m_6021_(this.blockX, this.blockY, this.blockZ);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

