/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class RoleDataC2SPacket {
    private final int entityId;
    private final int roleId;

    public RoleDataC2SPacket(int entityId, int roleId) {
        this.entityId = entityId;
        this.roleId = roleId;
    }

    public RoleDataC2SPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.roleId = buf.m_130242_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130130_(this.roleId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ByteBuddyEntity byteBuddyEntity;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel serverLevel = player.m_284548_();
            Entity entity = serverLevel.m_6815_(this.entityId);
            if (entity instanceof ByteBuddyEntity && (byteBuddyEntity = (ByteBuddyEntity)entity).isOwnedBy((LivingEntity)player)) {
                byteBuddyEntity.setBuddyRoleById(this.roleId);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

