/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import org.jetbrains.annotations.Nullable;

public class WrenchItem
extends Item {
    private static final String dockPos = "DockPos";
    private static final String dockDimension = "DockDim";

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        BlockPos blockPos = useOnContext.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        ByteBuddies.LOGGER.info("[ByteBuddies] Wrench.useOn: side={} pos={} block={}", new Object[]{level.f_46443_ ? "CLIENT" : "SERVER", blockPos, blockState.m_60734_().getClass().getSimpleName()});
        Player player = useOnContext.m_43723_();
        ItemStack wrenchStack = useOnContext.m_43722_();
        if (player != null && player.m_6144_()) {
            WrenchItem.clearDock(wrenchStack);
            if (!level.f_46443_) {
                ByteBuddies.LOGGER.info("[ByteBuddies] wrench: cleared link");
            }
            player.m_5661_((Component)Component.m_237113_((String)"Cleared wrench link"), true);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_ && blockState.m_60734_() instanceof DockingStationBlock) {
            WrenchItem.setDock(wrenchStack, level, blockPos);
            ByteBuddies.LOGGER.info("[ByteBuddies] wrench: stored dock {} in {}", (Object)blockPos, (Object)level.m_46472_().m_135782_());
        }
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)("Stored dock: " + blockPos.m_123344_() + " (" + level.m_46472_().m_135782_() + ")")), true);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack wrenchStack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof ByteBuddyEntity)) {
            return InteractionResult.PASS;
        }
        ByteBuddyEntity byteBuddy = (ByteBuddyEntity)target;
        Level level = player.m_9236_();
        if (player.m_6144_()) {
            Optional<BlockPos> byteBuddyDock = byteBuddy.getDock();
            byteBuddy.clearDock();
            WrenchItem.sendMessage(player, "Bot unbound from dock" + (String)(byteBuddyDock.isPresent() ? " " + byteBuddyDock.get().m_123344_() : ""));
            ByteBuddies.LOGGER.info("[ByteBuddies] wrench: unbound bot id={} from dock={}", (Object)byteBuddy.m_19879_(), (Object)byteBuddyDock.map(Vec3i::m_123344_).orElse("-"));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Optional<GlobalPos> dockBlockPosOpt = WrenchItem.getDock(wrenchStack);
        if (dockBlockPosOpt.isEmpty()) {
            WrenchItem.sendMessage(player, "Wrench is not linked to a dock (right-click a Docking Station first)");
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: no dock stored when attempting to bind");
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        GlobalPos dockBlockPos = dockBlockPosOpt.get();
        if (!dockBlockPos.m_122640_().equals((Object)level.m_46472_())) {
            WrenchItem.sendMessage(player, "Dock is in different dimension: " + dockBlockPos.m_122640_().m_135782_());
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: dim mismatch botDim={} dockDim={}", (Object)level.m_46472_().m_135782_(), (Object)dockBlockPos.m_122640_().m_135782_());
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!(level.m_8055_(dockBlockPos.m_122646_()).m_60734_() instanceof DockingStationBlock)) {
            WrenchItem.sendMessage(player, "Stored dock is missing. Clear the wrench link and re-set it.");
            ByteBuddies.LOGGER.warn("[ByteBuddies] wrench: stored dock not found at {}", (Object)dockBlockPos.m_122646_());
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        byteBuddy.setDock(dockBlockPos.m_122646_());
        BlockEntity blockEntity = level.m_7702_(dockBlockPos.m_122646_());
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlockEntity = (DockingStationBlockEntity)blockEntity;
            dockBlockEntity.addBoundBuddy(byteBuddy);
        }
        WrenchItem.sendMessage(player, "Bot bound to dock " + dockBlockPos.m_122646_().m_123344_());
        ByteBuddies.LOGGER.info("[ByteBuddies] wrench: bound bot id={} to dock {}", (Object)byteBuddy.m_19879_(), (Object)dockBlockPos.m_122646_());
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        CompoundTag nbtData = pStack.m_41783_();
        if (nbtData != null && nbtData.m_128441_(dockPos) && nbtData.m_128441_(dockDimension)) {
            BlockPos blockPos = BlockPos.m_122022_((long)nbtData.m_128454_(dockPos));
            String dimensionString = nbtData.m_128461_(dockDimension);
            pTooltipComponents.add((Component)Component.m_237113_((String)("Linked Dock: " + blockPos.m_123344_() + " (" + dimensionString + ")")));
            return;
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)"Linked Dock: <none>"));
    }

    private static void setDock(ItemStack wrenchStack, Level level, BlockPos blockPos) {
        CompoundTag nbtData = wrenchStack.m_41784_();
        nbtData.m_128356_(dockPos, blockPos.m_121878_());
        nbtData.m_128359_(dockDimension, level.m_46472_().m_135782_().toString());
    }

    private static Optional<GlobalPos> getDock(ItemStack wrenchStack) {
        CompoundTag nbtData = wrenchStack.m_41783_();
        if (nbtData == null) {
            return Optional.empty();
        }
        if (!nbtData.m_128441_(dockPos) || !nbtData.m_128441_(dockDimension)) {
            return Optional.empty();
        }
        BlockPos blockPos = BlockPos.m_122022_((long)nbtData.m_128454_(dockPos));
        ResourceLocation dimensionLocation = ResourceLocation.m_135820_((String)nbtData.m_128461_(dockDimension));
        if (dimensionLocation != null) {
            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionLocation);
            return Optional.of(GlobalPos.m_122643_((ResourceKey)levelKey, (BlockPos)blockPos));
        }
        return Optional.empty();
    }

    private static void clearDock(ItemStack wrenchStack) {
        CompoundTag nbtData = wrenchStack.m_41783_();
        if (nbtData == null) {
            return;
        }
        nbtData.m_128473_(dockPos);
        nbtData.m_128473_(dockDimension);
    }

    private static void sendMessage(Player player, String message) {
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)message), true);
        }
    }
}

