/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.entities.SwordSweepEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerrabladeItem
extends SwordItem {
    private static final String CHARGE_TAG = "Charge";
    private static final String SUPERCHARGED_TAG = "SuperCharged";
    public static final int MAX_CHARGE = 100;

    public TerrabladeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        boolean active = TerrabladeItem.isActive(stack);
        if (active || player.m_21023_((MobEffect)ModEffects.SUPERCHARGED.get())) {
            SwordSweepEntity projectile = new SwordSweepEntity(level);
            projectile.m_5602_((Entity)player);
            projectile.m_6034_(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_());
            Vec3 lookAngle = player.m_20154_();
            float velocity = 1.63f;
            projectile.m_6686_(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, velocity, 0.0f);
            Vec3 vec3 = player.m_20184_();
            projectile.m_20256_(projectile.m_20184_().m_82520_(vec3.f_82479_, player.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
            projectile.setProjectileDamage((float)player.m_21133_(Attributes.f_22281_));
            level.m_7967_((Entity)projectile);
            player.m_36335_().m_41524_((Item)this, 10);
            player.m_21011_(hand, true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charge = TerrabladeItem.getCharge(stack);
        if (!TerrabladeItem.isActive(stack) && charge >= 100) {
            TerrabladeItem.setActive(stack, true);
            int effectDuration = TerrabladeItem.getCharge(stack);
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SUPERCHARGED.get(), effectDuration, 0, false, true, true));
            player.m_21011_(player.m_7655_(), true);
        }
        if (TerrabladeItem.isActive(stack)) {
            int effectDuration;
            if (charge <= 0) {
                TerrabladeItem.setActive(stack, false);
                player.m_21195_((MobEffect)ModEffects.SUPERCHARGED.get());
                return;
            }
            int newCharge = charge - 1;
            TerrabladeItem.setCharge(stack, newCharge);
            MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)ModEffects.SUPERCHARGED.get());
            int n = effectDuration = mobEffectInstance == null ? 0 : mobEffectInstance.m_19557_();
            if (effectDuration != newCharge) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SUPERCHARGED.get(), newCharge, 0, false, true, true));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        int charge = TerrabladeItem.getCharge(pStack);
        pTooltipComponents.add((Component)Component.m_237113_((String)("Charge: " + charge + " / 100")).m_130940_(ChatFormatting.AQUA));
    }

    public static int getCharge(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        int charge = 0;
        if (tag != null && tag.m_128441_(CHARGE_TAG)) {
            charge = tag.m_128451_(CHARGE_TAG);
        }
        return Mth.m_14045_((int)charge, (int)0, (int)100);
    }

    public static void setCharge(ItemStack itemStack, int charge) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_(CHARGE_TAG, Mth.m_14045_((int)charge, (int)0, (int)100));
    }

    public static boolean isActive(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null && tag.m_128471_(SUPERCHARGED_TAG);
    }

    public static void setActive(ItemStack itemStack, boolean active) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_(SUPERCHARGED_TAG, active);
    }
}

