/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.custom.BluestoneOreBlock;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.entity.entities.HologramBuddyEntity;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.turtlecore.init.CoreAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public class FloppyDiskItem
extends Item {
    private final FloppyTier tier;
    private final String colorKey;

    public FloppyDiskItem(Item.Properties properties, String tier, String colorKey) {
        super(properties.m_41497_(FloppyTier.fromName(tier).getRarity()));
        this.tier = FloppyTier.fromName(tier);
        this.colorKey = colorKey;
    }

    public String getTierKey() {
        return this.tier.name().toLowerCase(Locale.ROOT);
    }

    public String colorKey() {
        return this.colorKey;
    }

    public FloppyTier getTier() {
        return this.tier;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TextColor tierColor = TierColors.forTier(this.getTierKey());
        MutableComponent tierName = Component.m_237115_((String)("tooltip.bytebuddies.floppy_tier." + this.getTierKey())).m_130948_(Style.f_131099_.m_131148_(tierColor));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.bytebuddies.floppy.tier_line", (Object[])new Object[]{tierName}).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)("tooltip.bytebuddies.floppy.desc." + this.colorKey)).m_130940_(ChatFormatting.DARK_GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)""));
        FloppyTier tier = FloppyTier.fromName(this.getTierKey());
        FloppyDiskItem.addWhenInstalled(pTooltipComponents, tier, this.colorKey);
    }

    private static void addWhenInstalled(List<Component> tooltip, FloppyTier tier, String colorKey) {
        tooltip.add((Component)Component.m_237113_((String)"When installed:").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        switch (colorKey) {
            case "blue": {
                float multiplier = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 1.2f;
                    case FloppyTier.IRON -> 1.35f;
                    case FloppyTier.GOLD -> 1.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(multiplier) + " task radius"));
                break;
            }
            case "green": {
                float multiplier = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.9f;
                    case FloppyTier.IRON -> 0.8f;
                    case FloppyTier.GOLD -> 0.7f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(1.0f / multiplier) + " efficiency (lower energy cost)"));
                tooltip.add(FloppyDiskItem.malusLine(FloppyDiskItem.percentFromMultiplier(multiplier) + " energy cost"));
                break;
            }
            case "red": {
                float speedMultiplier = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 1.2f;
                    case FloppyTier.IRON -> 1.35f;
                    case FloppyTier.GOLD -> 1.5f;
                };
                float energyMultiplier = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 1.3f;
                    case FloppyTier.IRON -> 1.5f;
                    case FloppyTier.GOLD -> 1.7f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(speedMultiplier) + " action speed"));
                tooltip.add(FloppyDiskItem.malusLine(FloppyDiskItem.percentFromMultiplier(energyMultiplier) + " efficiency (higher energy cost)"));
                break;
            }
            case "black": {
                float wearMultiplier = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.85f;
                    case FloppyTier.IRON -> 0.7f;
                    case FloppyTier.GOLD -> 0.55f;
                };
                float healthPercentage = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 1.0f;
                    case FloppyTier.IRON -> 1.5f;
                    case FloppyTier.GOLD -> 2.0f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(1.0f / wearMultiplier) + " tool longevity (reduced wear)"));
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(healthPercentage) + " Max Health"));
                break;
            }
            case "purple": {
                float add = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.33f;
                    case FloppyTier.IRON -> 0.425f;
                    case FloppyTier.GOLD -> 0.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(add) + " extra primary yield chance"));
                tooltip.add((Component)Component.m_237113_((String)"Can exceed 100% for multiple extra rolls.").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case "yellow": {
                float add = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.5f;
                    case FloppyTier.IRON -> 0.625f;
                    case FloppyTier.GOLD -> 0.85f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(add) + " byproduct roll chance"));
                tooltip.add((Component)Component.m_237113_((String)"Can exceed 100% for multiple byproduct rolls.").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case "pink": {
                float power = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.2f;
                    case FloppyTier.IRON -> 0.35f;
                    case FloppyTier.GOLD -> 0.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", "Aura power " + FloppyDiskItem.percent(power)));
                break;
            }
            case "cyan": {
                float chance = switch (tier) {
                    default -> throw new IncompatibleClassChangeError();
                    case FloppyTier.COPPER -> 0.125f;
                    case FloppyTier.IRON -> 0.175f;
                    case FloppyTier.GOLD -> 0.25f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", "Spawn chance " + FloppyDiskItem.percent(chance) + " on success"));
                break;
            }
            default: {
                tooltip.add((Component)Component.m_237113_((String)"No effects").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    private static Component bonusLine(String sign, String text) {
        return Component.m_237113_((String)(sign + " " + text)).m_130940_(ChatFormatting.BLUE);
    }

    private static Component malusLine(String text) {
        return Component.m_237113_((String)("\u2212 " + text)).m_130940_(ChatFormatting.RED);
    }

    private static String percentFromMultiplier(float multiplier) {
        float percentage = (multiplier - 1.0f) * 100.0f;
        if (percentage < 0.0f) {
            percentage = -percentage;
        }
        return FloppyDiskItem.trimPercent(percentage);
    }

    private static String percent(float value) {
        float percentage = value * 100.0f;
        return FloppyDiskItem.trimPercent(percentage);
    }

    private static String trimPercent(float pct) {
        float abs = Math.abs(pct);
        if (Math.abs(pct - (float)Math.round(pct)) < 0.05f) {
            return Math.round(pct) + "%";
        }
        if (abs < 10.0f) {
            return String.format(Locale.ROOT, "%.2f%%", Float.valueOf(pct));
        }
        return String.format(Locale.ROOT, "%.1f%%", Float.valueOf(pct));
    }

    public static enum FloppyTier {
        COPPER(Rarity.COMMON, 1),
        IRON(Rarity.UNCOMMON, 2),
        GOLD(Rarity.RARE, 3);

        private final Rarity rarity;
        private final int tierIndex;

        private FloppyTier(Rarity rarity, int index) {
            this.rarity = rarity;
            this.tierIndex = index;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public int index() {
            return this.tierIndex;
        }

        public static FloppyTier fromName(String name) {
            return switch (name.toLowerCase(Locale.ROOT)) {
                case "copper" -> COPPER;
                case "iron" -> IRON;
                case "gold" -> GOLD;
                default -> COPPER;
            };
        }
    }

    static final class TierColors {
        TierColors() {
        }

        static TextColor forTier(String tier) {
            return switch (tier) {
                case "copper" -> TextColor.m_131266_((int)12088115);
                case "iron" -> TextColor.m_131266_((int)0xC0C0C0);
                case "gold" -> TextColor.m_131266_((int)16766720);
                default -> TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
            };
        }
    }

    public static final class DiskHooks {
        public static void applyPrimaryYieldBonus(List<ItemStack> drops, Block block, ByteBuddyEntity byteBuddy, float bonusChance) {
            int rolls;
            if (bonusChance > 0.0f && block instanceof CropBlock && (rolls = DiskHooks.totalRollsFromChance(byteBuddy.m_9236_(), bonusChance)) > 0) {
                for (ItemStack itemStack : drops) {
                    if (!DiskHooks.isPrimaryProduce(itemStack)) continue;
                    for (int i = 0; i < rolls; ++i) {
                        if (itemStack.m_41613_() < itemStack.m_41741_()) {
                            itemStack.m_41769_(1);
                            continue;
                        }
                        Containers.m_18992_((Level)byteBuddy.m_9236_(), (double)byteBuddy.m_20185_(), (double)byteBuddy.m_20186_(), (double)byteBuddy.m_20189_(), (ItemStack)new ItemStack((ItemLike)itemStack.m_41720_(), 1));
                    }
                }
            }
        }

        public static void tryGiveByproduct(ByteBuddyEntity byteBuddy, ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
            int rolls;
            float byproductChance = byteBuddy.byproductChance();
            if (byproductChance > 0.0f && (rolls = DiskHooks.totalRollsFromChance(byteBuddy.m_9236_(), byproductChance)) > 0) {
                for (int i = 0; i < rolls; ++i) {
                    ItemStack leftover;
                    ItemStack byProductStack;
                    switch (taskType) {
                        case HARVEST: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42404_, 1);
                            break;
                        }
                        case FORESTRY: {
                            ItemStack itemStack;
                            if (byteBuddy.m_9236_().f_46441_.m_188501_() < 0.3f) {
                                itemStack = new ItemStack((ItemLike)Items.f_42799_);
                                break;
                            }
                            itemStack = new ItemStack((ItemLike)Items.f_42398_);
                            break;
                        }
                        case MINE: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42484_, 1);
                            break;
                        }
                        case SHEAR: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42401_, 1);
                            break;
                        }
                        case MILK: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42454_, 1);
                            break;
                        }
                        case COMBAT: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42500_, 1);
                            break;
                        }
                        default: {
                            ItemStack itemStack = byProductStack = ItemStack.f_41583_;
                        }
                    }
                    if (byProductStack.m_41619_() || (leftover = InventoryUtil.mergeInto(byteBuddy.getMainInv(), byProductStack)).m_41619_()) continue;
                    Containers.m_18992_((Level)byteBuddy.m_9236_(), (double)((double)blockPos.m_123341_() + 0.5), (double)((double)blockPos.m_123342_() + 0.5), (double)((double)blockPos.m_123343_() + 0.5), (ItemStack)leftover);
                }
            }
        }

        private static int totalRollsFromChance(Level level, float chance) {
            int guaranteed = (int)Math.floor(chance);
            float fractional = chance - (float)guaranteed;
            int extra = 0;
            if (fractional > 0.0f && level.f_46441_.m_188501_() < fractional) {
                extra = 1;
            }
            return guaranteed + extra;
        }

        public static void applyDiskHealthBoost(ByteBuddyEntity byteBuddy, float healthBoostPct) {
            AttributeInstance attribute = byteBuddy.m_21051_(Attributes.f_22276_);
            if (attribute != null) {
                double oldMax = attribute.m_22135_();
                CoreAttributeModifiers.removeModifier((LivingEntity)byteBuddy, (Attribute)Attributes.f_22276_, (String)"disk_health");
                if (healthBoostPct > 0.0f) {
                    CoreAttributeModifiers.applyPermanentModifier((LivingEntity)byteBuddy, (Attribute)Attributes.f_22276_, (String)"disk_health", (double)healthBoostPct, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
                }
                float newHealth = DiskHooks.getNewHealth(byteBuddy, attribute, oldMax);
                byteBuddy.m_21153_(newHealth);
            }
        }

        private static float getNewHealth(ByteBuddyEntity byteBuddy, AttributeInstance attribute, double oldMax) {
            float newHealth;
            double newMax = attribute.m_22135_();
            float current = byteBuddy.m_21223_();
            if (oldMax > 0.0) {
                float ratio = current / (float)oldMax;
                newHealth = ratio * (float)newMax;
            } else {
                newHealth = (float)newMax;
            }
            if (newHealth < 1.0f) {
                newHealth = 1.0f;
            }
            if (newHealth > (float)newMax) {
                newHealth = (float)newMax;
            }
            return newHealth;
        }

        public static void trySpawnHologram(ByteBuddyEntity byteBuddy, ByteBuddyEntity.TaskType taskType) {
            Level level;
            boolean hologramEnabled = byteBuddy.hologramEnabled();
            float configuredChance = byteBuddy.hologramChance();
            float finalChance = configuredChance > 0.0f ? configuredChance : 0.25f;
            float percentRolled = byteBuddy.m_9236_().f_46441_.m_188501_();
            BlockPos buddyPos = byteBuddy.m_20097_();
            boolean passed = false;
            if (hologramEnabled && percentRolled < finalChance) {
                passed = true;
            }
            if (passed && (level = byteBuddy.m_9236_()) instanceof ServerLevel) {
                ServerPlayer owner;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos spawnBlockPos = buddyPos;
                boolean validPos = false;
                int maxRadius = 3;
                for (int radius = 1; radius <= maxRadius; ++radius) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        for (int dx = -radius; dx <= radius; ++dx) {
                            BlockPos candidate;
                            boolean standableTerrain;
                            boolean onPerimeter;
                            boolean bl = onPerimeter = Math.abs(dx) == radius || Math.abs(dz) == radius;
                            if (!onPerimeter || !(standableTerrain = ByteBuddyEntity.isStandableTerrain((Level)serverLevel, candidate = buddyPos.m_7918_(dx, 0, dz)))) continue;
                            spawnBlockPos = candidate.m_7949_();
                            validPos = true;
                            dx = radius;
                            dz = radius;
                        }
                    }
                    if (!validPos) continue;
                    radius = maxRadius;
                }
                if (!validPos) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos candidate;
                        boolean standableTerrain;
                        if (dy == 0 || !(standableTerrain = ByteBuddyEntity.isStandableTerrain((Level)serverLevel, candidate = buddyPos.m_6630_(dy)))) continue;
                        spawnBlockPos = candidate.m_7949_();
                        validPos = true;
                    }
                }
                for (int i = 0; i < 12; ++i) {
                    double particleInterval = Math.PI * 2 * (double)i / 12.0;
                    serverLevel.m_8767_((ParticleOptions)BluestoneOreBlock.BLUESTONE, (double)spawnBlockPos.m_123341_() + 0.5 + Math.cos(particleInterval) * 0.5, (double)spawnBlockPos.m_123342_() + 0.1, (double)spawnBlockPos.m_123343_() + 0.5 + Math.sin(particleInterval) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
                serverLevel.m_5594_(null, spawnBlockPos, SoundEvents.f_144243_, SoundSource.PLAYERS, 0.6f, 1.5f);
                EntityType hologramType = (EntityType)ModEntities.HOLOBUDDY.get();
                int lifetimeTicks = 200;
                HologramBuddyEntity hologram = HologramBuddyEntity.spawnFrom(byteBuddy, (EntityType<? extends ByteBuddyEntity>)hologramType, spawnBlockPos, lifetimeTicks);
                if (hologram == null || (owner = byteBuddy.getOwner(serverLevel)) != null) {
                    // empty if block
                }
            }
        }

        private static boolean isPrimaryProduce(ItemStack st) {
            return st.m_150930_(Items.f_42405_) || st.m_150930_(Items.f_42619_) || st.m_150930_(Items.f_42620_) || st.m_150930_(Items.f_42732_);
        }
    }

    public static final class DiskEffects {
        private float radiusMultiplier = 1.0f;
        private float energyMultiplier = 1.0f;
        private float speedMultiplier = 1.0f;
        private float wearMultiplier = 1.0f;
        private float yieldBoostChance = 0.0f;
        private float byprodChance = 0.0f;
        private float healthBoostPct = 0.0f;
        private boolean hologramEnabled = false;
        private float hologramChance = 0.0f;
        private boolean supportAuraEnabled = false;
        private float supportAuraPower = 0.0f;

        public void recomputeFrom(ItemStackHandler upgrades) {
            this.radiusMultiplier = 1.0f;
            this.energyMultiplier = 1.0f;
            this.speedMultiplier = 1.0f;
            this.wearMultiplier = 1.0f;
            this.yieldBoostChance = 0.0f;
            this.byprodChance = 0.0f;
            this.healthBoostPct = 0.0f;
            this.hologramEnabled = false;
            this.hologramChance = 0.0f;
            this.supportAuraEnabled = false;
            this.supportAuraPower = 0.0f;
            block70: for (int i = 0; i < upgrades.getSlots(); ++i) {
                Item item;
                ItemStack inSlot = upgrades.getStackInSlot(i);
                if (inSlot.m_41619_() || !((item = inSlot.m_41720_()) instanceof FloppyDiskItem)) continue;
                FloppyDiskItem disk = (FloppyDiskItem)item;
                FloppyTier tier = disk.getTier();
                switch (disk.colorKey) {
                    case "blue": {
                        this.radiusMultiplier *= (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 1.2f;
                            case FloppyTier.IRON -> 1.35f;
                            case FloppyTier.GOLD -> 1.5f;
                        });
                        continue block70;
                    }
                    case "green": {
                        this.energyMultiplier *= (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.9f;
                            case FloppyTier.IRON -> 0.8f;
                            case FloppyTier.GOLD -> 0.7f;
                        });
                        continue block70;
                    }
                    case "red": {
                        this.speedMultiplier *= (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 1.2f;
                            case FloppyTier.IRON -> 1.35f;
                            case FloppyTier.GOLD -> 1.5f;
                        });
                        this.energyMultiplier *= (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 1.3f;
                            case FloppyTier.IRON -> 1.5f;
                            case FloppyTier.GOLD -> 1.7f;
                        });
                        continue block70;
                    }
                    case "black": {
                        this.wearMultiplier *= (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.85f;
                            case FloppyTier.IRON -> 0.7f;
                            case FloppyTier.GOLD -> 0.55f;
                        });
                        this.healthBoostPct += (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 1.0f;
                            case FloppyTier.IRON -> 1.5f;
                            case FloppyTier.GOLD -> 2.0f;
                        });
                        continue block70;
                    }
                    case "purple": {
                        this.yieldBoostChance += (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.33f;
                            case FloppyTier.IRON -> 0.425f;
                            case FloppyTier.GOLD -> 0.5f;
                        });
                        continue block70;
                    }
                    case "yellow": {
                        this.byprodChance += (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.5f;
                            case FloppyTier.IRON -> 0.625f;
                            case FloppyTier.GOLD -> 0.85f;
                        });
                        continue block70;
                    }
                    case "pink": {
                        this.supportAuraEnabled = true;
                        this.supportAuraPower += (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.2f;
                            case FloppyTier.IRON -> 0.35f;
                            case FloppyTier.GOLD -> 0.5f;
                        });
                        continue block70;
                    }
                    case "cyan": {
                        this.hologramEnabled = true;
                        this.hologramChance += (switch (tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case FloppyTier.COPPER -> 0.125f;
                            case FloppyTier.IRON -> 0.175f;
                            case FloppyTier.GOLD -> 0.25f;
                        });
                    }
                }
            }
            this.energyMultiplier = Mth.m_14036_((float)this.energyMultiplier, (float)0.4f, (float)5.0f);
            this.speedMultiplier = Mth.m_14036_((float)this.speedMultiplier, (float)0.8f, (float)5.0f);
            this.wearMultiplier = Mth.m_14036_((float)this.wearMultiplier, (float)0.25f, (float)1.5f);
            this.yieldBoostChance = Mth.m_14036_((float)this.yieldBoostChance, (float)0.0f, (float)2.0f);
            this.byprodChance = Mth.m_14036_((float)this.byprodChance, (float)0.0f, (float)3.4f);
            this.hologramChance = Mth.m_14036_((float)this.hologramChance, (float)0.0f, (float)1.0f);
            this.supportAuraPower = Mth.m_14036_((float)this.supportAuraPower, (float)0.0f, (float)1.0f);
            this.healthBoostPct = Mth.m_14036_((float)this.healthBoostPct, (float)0.0f, (float)8.0f);
        }

        public float radiusMultiplier() {
            return this.radiusMultiplier;
        }

        public float energyCostMultiplier() {
            return this.energyMultiplier;
        }

        public float actionSpeedMultiplier() {
            return this.speedMultiplier;
        }

        public float toolWearMultiplier() {
            return this.wearMultiplier;
        }

        public float yieldPrimaryChance() {
            return this.yieldBoostChance;
        }

        public float secondaryByproductChance() {
            return this.byprodChance;
        }

        public float healthBoostPercent() {
            return this.healthBoostPct;
        }

        public boolean hologramEnabled() {
            return this.hologramEnabled;
        }

        public float hologramChance() {
            return this.hologramChance;
        }

        public boolean supportAuraEnabled() {
            return this.supportAuraEnabled;
        }

        public float supportAuraPower() {
            return this.supportAuraPower;
        }
    }
}

