/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ClipboardItem
extends Item {
    private static final String firstPos = "FirstPos";
    private static final String secondPos = "SecondPos";
    private static final String xCoord = "X";
    private static final String yCoord = "Y";
    private static final String zCoord = "Z";

    public ClipboardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean isSneaking;
        Level level = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        Player player = context.m_43723_();
        boolean isClient = level.f_46443_;
        boolean bl = isSneaking = player != null && player.m_6144_();
        if (isSneaking) {
            if (!isClient) {
                ClipboardItem.clearPositions(itemStack);
                player.m_5661_((Component)Component.m_237113_((String)"Clipboard cleared").m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.m_19078_((boolean)isClient);
        }
        if (!isClient) {
            boolean hasFirst = ClipboardItem.hasFirstPosition(itemStack);
            boolean hasSecond = ClipboardItem.hasSecondPosition(itemStack);
            if (!hasFirst) {
                ClipboardItem.setFirstPosition(itemStack, clickedPos);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)("Set first position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
                }
            } else if (!hasSecond) {
                ClipboardItem.setSecondPosition(itemStack, clickedPos);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)("Set second position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
                }
            } else {
                ClipboardItem.clearSecondPosition(itemStack);
                ClipboardItem.setFirstPosition(itemStack, clickedPos);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)("Set first position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)isClient);
    }

    public void handleClick(Player player, ItemStack itemStack, BlockPos clickedPos) {
        boolean isSneaking;
        boolean bl = isSneaking = player != null && player.m_6144_();
        if (isSneaking) {
            ClipboardItem.clearPositions(itemStack);
            player.m_5661_((Component)Component.m_237113_((String)"Clipboard cleared").m_130940_(ChatFormatting.YELLOW), true);
            return;
        }
        boolean hasFirst = ClipboardItem.hasFirstPosition(itemStack);
        boolean hasSecond = ClipboardItem.hasSecondPosition(itemStack);
        if (!hasFirst) {
            ClipboardItem.setFirstPosition(itemStack, clickedPos);
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("Set first position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
            }
        } else if (!hasSecond) {
            ClipboardItem.setSecondPosition(itemStack, clickedPos);
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("Set second position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
            }
        } else {
            ClipboardItem.clearSecondPosition(itemStack);
            ClipboardItem.setFirstPosition(itemStack, clickedPos);
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("Set first position: " + ClipboardItem.format(clickedPos))).m_130940_(ChatFormatting.GREEN), true);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            ClipboardItem.clearPositions(itemStack);
            player.m_5661_((Component)Component.m_237113_((String)"Clipboard cleared").m_130940_(ChatFormatting.YELLOW), true);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Optional<BlockPos> firstPos = ClipboardItem.getFirstPosition(pStack);
        Optional<BlockPos> secondPosition = ClipboardItem.getSecondPosition(pStack);
        if (firstPos.isPresent()) {
            pTooltipComponents.add((Component)Component.m_237113_((String)("First Position: " + ClipboardItem.format(firstPos.get()))).m_130940_(ChatFormatting.AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)"First Position: not set").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (secondPosition.isPresent()) {
            pTooltipComponents.add((Component)Component.m_237113_((String)("Second Position: " + ClipboardItem.format(secondPosition.get()))).m_130940_(ChatFormatting.AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)"Second Position: not set").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (firstPos.isPresent() && secondPosition.isPresent()) {
            BlockPos aPos = firstPos.get();
            BlockPos bPos = secondPosition.get();
            int width = Math.abs(aPos.m_123341_() - bPos.m_123341_()) + 1;
            int height = Math.abs(aPos.m_123342_() - bPos.m_123342_()) + 1;
            int depth = Math.abs(aPos.m_123343_() - bPos.m_123343_()) + 1;
            pTooltipComponents.add((Component)Component.m_237113_((String)("Box: " + width + "\u00d7" + height + "\u00d7" + depth)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static Optional<BlockPos> getFirstPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        if (root == null || !root.m_128441_(firstPos)) {
            return Optional.empty();
        }
        CompoundTag pos = root.m_128469_(firstPos);
        return Optional.of(new BlockPos(pos.m_128451_(xCoord), pos.m_128451_(yCoord), pos.m_128451_(zCoord)));
    }

    public static Optional<BlockPos> getSecondPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        if (root == null || !root.m_128441_(secondPos)) {
            return Optional.empty();
        }
        CompoundTag pos = root.m_128469_(secondPos);
        return Optional.of(new BlockPos(pos.m_128451_(xCoord), pos.m_128451_(yCoord), pos.m_128451_(zCoord)));
    }

    public static boolean hasFirstPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        return root != null && root.m_128441_(firstPos);
    }

    public static boolean hasSecondPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        return root != null && root.m_128441_(secondPos);
    }

    public static void setFirstPosition(ItemStack clipboardStack, BlockPos blockPos) {
        CompoundTag root = ClipboardItem.getOrCreateRoot(clipboardStack);
        CompoundTag dataPos = new CompoundTag();
        dataPos.m_128405_(xCoord, blockPos.m_123341_());
        dataPos.m_128405_(yCoord, blockPos.m_123342_());
        dataPos.m_128405_(zCoord, blockPos.m_123343_());
        root.m_128365_(firstPos, (Tag)dataPos);
    }

    public static void setSecondPosition(ItemStack itemStack, BlockPos blockPos) {
        CompoundTag root = ClipboardItem.getOrCreateRoot(itemStack);
        CompoundTag dataPos = new CompoundTag();
        dataPos.m_128405_(xCoord, blockPos.m_123341_());
        dataPos.m_128405_(yCoord, blockPos.m_123342_());
        dataPos.m_128405_(zCoord, blockPos.m_123343_());
        root.m_128365_(secondPos, (Tag)dataPos);
    }

    public static void clearPositions(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        if (root == null) {
            return;
        }
        root.m_128473_(firstPos);
        root.m_128473_(secondPos);
    }

    private static void clearFirstPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        if (root == null) {
            return;
        }
        root.m_128473_(firstPos);
    }

    private static void clearSecondPosition(ItemStack itemStack) {
        CompoundTag root = itemStack.m_41783_();
        if (root == null) {
            return;
        }
        root.m_128473_(secondPos);
    }

    private static CompoundTag getOrCreateRoot(ItemStack itemStack) {
        return itemStack.m_41784_();
    }

    public static Optional<Region> getRegion(ItemStack itemStack) {
        Optional<BlockPos> first = ClipboardItem.getFirstPosition(itemStack);
        Optional<BlockPos> second = ClipboardItem.getSecondPosition(itemStack);
        if (first.isEmpty() || second.isEmpty()) {
            return Optional.empty();
        }
        BlockPos a = first.get();
        BlockPos b = second.get();
        int xMin = Math.min(a.m_123341_(), b.m_123341_());
        int xMax = Math.max(a.m_123341_(), b.m_123341_());
        int yMin = Math.min(a.m_123342_(), b.m_123342_());
        int yMax = Math.max(a.m_123342_(), b.m_123342_());
        int zMin = Math.min(a.m_123343_(), b.m_123343_());
        int zMax = Math.max(a.m_123343_(), b.m_123343_());
        return Optional.of(new Region(new BlockPos(xMin, yMin, zMin), new BlockPos(xMax, yMax, zMax)));
    }

    private static String format(BlockPos pos) {
        return pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_();
    }

    public record Region(BlockPos min, BlockPos max) {
    }
}

