/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends Item {
    private static final String KEY_ENERGY = "bytebuddies:energy";
    private final int capacity;
    private final int ioRate;
    private final String tierName;

    public BatteryItem(Item.Properties properties, String tierName, int capacity, int ioRate) {
        super(properties.m_41487_(1));
        this.tierName = tierName;
        this.capacity = capacity;
        this.ioRate = ioRate;
    }

    public int getEnergy(ItemStack stack) {
        CompoundTag nbtData = stack.m_41783_();
        if (nbtData == null) {
            return 0;
        }
        return nbtData.m_128441_(KEY_ENERGY) ? Math.max(0, nbtData.m_128451_(KEY_ENERGY)) : 0;
    }

    public void setEnergy(ItemStack batteryStack, int energyValue) {
        energyValue = Math.max(0, Math.min(this.capacity, energyValue));
        CompoundTag nbtData = batteryStack.m_41784_();
        nbtData.m_128405_(KEY_ENERGY, energyValue);
    }

    public int extract(ItemStack batteryStack, int energyValue, boolean transferable) {
        int batteryEnergy = this.getEnergy(batteryStack);
        int extractableEnergy = Math.min(this.ioRate, Math.min(energyValue, batteryEnergy));
        if (!transferable && extractableEnergy > 0) {
            this.setEnergy(batteryStack, batteryEnergy - extractableEnergy);
        }
        return extractableEnergy;
    }

    public int receive(ItemStack batteryStack, int energyValue, boolean transferable) {
        int batteryEnergy = this.getEnergy(batteryStack);
        int receivableEnergy = Math.min(this.ioRate, Math.min(energyValue, this.capacity - batteryEnergy));
        if (!transferable && receivableEnergy > 0) {
            this.setEnergy(batteryStack, batteryEnergy + receivableEnergy);
        }
        return receivableEnergy;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getIoRate() {
        return this.ioRate;
    }

    public InteractionResult m_6880_(ItemStack batteryStack, Player player, LivingEntity target, InteractionHand interactionHand) {
        if (target instanceof ByteBuddyEntity) {
            ByteBuddyEntity bot = (ByteBuddyEntity)target;
            if (player.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int batteryEnergy = this.getEnergy(batteryStack);
            if (batteryEnergy <= 0) {
                player.m_5661_((Component)Component.m_237113_((String)"Battery is empty").m_130940_(ChatFormatting.RED), true);
                ByteBuddies.LOGGER.info("[ByteBuddies] battery: empty (tier={})", (Object)this.tierName);
                return InteractionResult.CONSUME;
            }
            int missingEnergy = bot.getEnergyStorage().getMaxEnergyStored() - bot.getEnergyStorage().getEnergyStored();
            if (missingEnergy <= 0) {
                player.m_5661_((Component)Component.m_237113_((String)"Bot is already full").m_130940_(ChatFormatting.YELLOW), true);
                return InteractionResult.CONSUME;
            }
            int transferableEnergy = Math.min(this.ioRate, Math.min(batteryEnergy, missingEnergy));
            int extractableEnergy = this.extract(batteryStack, transferableEnergy, false);
            int receivableEnergy = bot.getEnergyStorage().receiveEnergy(extractableEnergy, false);
            if (receivableEnergy < extractableEnergy) {
                this.setEnergy(batteryStack, this.getEnergy(batteryStack) + (extractableEnergy - receivableEnergy));
            }
            player.m_5661_((Component)Component.m_237113_((String)("Transferred " + receivableEnergy + " FE to bot")), true);
            ByteBuddies.LOGGER.info("[ByteBuddies] battery\u2192bot: tier={} gave={}FE remain={}FE bot={}/{}", new Object[]{this.tierName, receivableEnergy, this.getEnergy(batteryStack), bot.getEnergyStorage().getEnergyStored(), bot.getEnergyStorage().getMaxEnergyStored()});
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!level.f_46443_) {
            player.m_5661_((Component)Component.m_237113_((String)(this.batteryTier() + " " + this.getEnergy(itemInHand) + " / " + this.capacity + " FE")), true);
        }
        return InteractionResultHolder.m_19090_((Object)itemInHand);
    }

    public static void buddyDrainBatteries(ByteBuddyEntity byteBuddy) {
        int receivedEnergy;
        int neededEnergy;
        BatteryItem batteryItem;
        int pulledEnergy;
        Item item;
        ItemStack batteryInSlot;
        int missingEnergy = byteBuddy.getEnergyStorage().getMaxEnergyStored() - byteBuddy.getEnergyStorage().getEnergyStored();
        if (missingEnergy >= 0 && !(batteryInSlot = byteBuddy.getMainInv().getStackInSlot(byteBuddy.getBatterySlot())).m_41619_() && (item = batteryInSlot.m_41720_()) instanceof BatteryItem && (pulledEnergy = (batteryItem = (BatteryItem)item).extract(batteryInSlot, neededEnergy = Math.min(missingEnergy, batteryItem.getIoRate()), false)) > 0 && (receivedEnergy = byteBuddy.getEnergyStorage().receiveEnergy(pulledEnergy, false)) < pulledEnergy) {
            batteryItem.setEnergy(batteryInSlot, batteryItem.getEnergy(batteryInSlot) + (pulledEnergy - receivedEnergy));
        }
    }

    public static void dockBlockDrainBatteries(BlockEntity blockEntity) {
        int receivedEnergy;
        int neededEnergy;
        BatteryItem batteryItem;
        int pulledEnergy;
        Item item;
        ItemStack stackInSlot;
        DockingStationBlockEntity dockBlock;
        int missingEnergy;
        if (blockEntity instanceof DockingStationBlockEntity && (missingEnergy = (dockBlock = (DockingStationBlockEntity)blockEntity).getEnergyStorage().getMaxEnergyStored() - dockBlock.getEnergyStorage().getEnergyStored()) >= 0 && !(stackInSlot = dockBlock.getBatteryStack()).m_41619_() && (item = stackInSlot.m_41720_()) instanceof BatteryItem && (pulledEnergy = (batteryItem = (BatteryItem)item).extract(stackInSlot, neededEnergy = Math.min(missingEnergy, batteryItem.getIoRate()), false)) > 0 && (receivedEnergy = dockBlock.getEnergyStorage().receiveEnergy(pulledEnergy, false)) < pulledEnergy) {
            batteryItem.setEnergy(stackInSlot, batteryItem.getEnergy(stackInSlot) + (pulledEnergy - receivedEnergy));
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237113_((String)(this.batteryTier() + " Capacity: " + this.capacity + " FE")).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)("Charge: " + this.getEnergy(pStack) + " FE")).m_130940_(ChatFormatting.DARK_AQUA));
        pTooltipComponents.add((Component)Component.m_237113_((String)("I/O per use: " + this.ioRate + " FE")).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        float fullEnergyBar = (float)this.getEnergy(stack) / (float)this.capacity;
        return Math.round(13.0f * fullEnergyBar);
    }

    public int m_142159_(ItemStack batteryStack) {
        return 3073744;
    }

    private String batteryTier() {
        return switch (this.tierName) {
            case "simple" -> "Simple Battery";
            case "advanced" -> "Advanced Battery";
            case "biocell" -> "Biocell Battery";
            case "reinforced" -> "Reinforced Battery";
            case "supercharged" -> "Super-Charged Battery";
            default -> "Battery";
        };
    }
}

