/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.events;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.bytebuddies.block.ModBlocks;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.item.custom.TerrabladeItem;
import net.turtleboi.turtlecore.effect.CoreEffects;

@Mod.EventBusSubscriber(modid="bytebuddies")
public class ModEvents {
    private static final int chargeRadius = 3;

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof ByteBuddyEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        DamageSource source;
        Entity entity;
        ByteBuddyEntity byteBuddyEntity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ByteBuddyEntity) {
            byteBuddyEntity = (ByteBuddyEntity)livingEntity;
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof ByteBuddyEntity) {
            byteBuddyEntity = (ByteBuddyEntity)livingEntity;
        }
        if ((entity = (source = event.getSource()).m_7639_()) instanceof LivingEntity) {
            ByteBuddyEntity byteBuddy;
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack weapon = attacker.m_21205_();
            if (weapon.m_41720_() instanceof TerrabladeItem) {
                float damageDealt = event.getAmount();
                int charge = TerrabladeItem.getCharge(weapon);
                int newCharge = Math.min(charge + Math.round(damageDealt), 100);
                TerrabladeItem.setCharge(weapon, newCharge);
            }
            LivingEntity victim = event.getEntity();
            Level level = victim.m_9236_();
            if (victim.m_21023_((MobEffect)ModEffects.SUPERCHARGED.get())) {
                if (victim instanceof Player) {
                    Player player = (Player)victim;
                    attacker.m_6469_(level.m_269111_().m_269075_(player), 6.0f);
                } else {
                    attacker.m_6469_(level.m_269111_().m_269333_(victim), 6.0f);
                }
                MobEffectInstance stun = new MobEffectInstance((MobEffect)CoreEffects.STUNNED.get(), 100);
                attacker.m_147207_(stun, (Entity)victim);
            }
            if (victim instanceof ByteBuddyEntity && (byteBuddy = (ByteBuddyEntity)victim).getAugmentEffects().shockOnHit()) {
                byteBuddy.onMeleeHit(attacker);
                MobEffectInstance stun = new MobEffectInstance((MobEffect)CoreEffects.STUNNED.get(), 100);
                attacker.m_147207_(stun, (Entity)victim);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LightningBolt)) {
            return;
        }
        LightningBolt lightning = (LightningBolt)entity;
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos center = lightning.m_20183_();
        ModEvents.chargeNearbyBlocks(level, center, 3);
        ModEvents.chargeNearbyItemEntities(level, center, 3);
    }

    private static void chargeNearbyBlocks(ServerLevel level, BlockPos center, int radius) {
        BlockPos min = center.m_7918_(-radius, -1, -radius);
        BlockPos max = center.m_7918_(radius, 1, radius);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)ModBlocks.STEEL_BLOCK.get())) continue;
            level.m_46597_(pos, ((Block)ModBlocks.CHARGED_STEEL_BLOCK.get()).m_49966_());
        }
    }

    private static void chargeNearbyItemEntities(ServerLevel level, BlockPos center, int radius) {
        AABB boundingBox = new AABB(center).m_82400_((double)radius);
        for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, boundingBox)) {
            Item chargedItem;
            ItemStack itemStack = itemEntity.m_32055_();
            if (itemStack.m_41619_() || (chargedItem = ModEvents.mapSteelToCharged(itemStack.m_41720_())) == null) continue;
            ItemStack chargedOutput = new ItemStack((ItemLike)chargedItem, itemStack.m_41613_());
            if (itemStack.m_41782_()) {
                chargedOutput.m_41751_(itemStack.m_41783_().m_6426_());
            }
            itemEntity.m_32045_(chargedOutput);
        }
    }

    private static Item mapSteelToCharged(Item item) {
        if (item == ModItems.STEEL_INGOT.get()) {
            return (Item)ModItems.CHARGED_STEEL_INGOT.get();
        }
        if (item == ModItems.STEEL_NUGGET.get()) {
            return (Item)ModItems.CHARGED_STEEL_NUGGET.get();
        }
        if (item == ((Block)ModBlocks.STEEL_BLOCK.get()).m_5456_()) {
            return ((Block)ModBlocks.CHARGED_STEEL_BLOCK.get()).m_5456_();
        }
        return null;
    }
}

