/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.turtleboi.bytebuddies.entity.entities.SwordSweepEntity;
import net.turtleboi.turtlecore.client.util.VertexBuilder;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SwordSweepRenderer
extends EntityRenderer<SwordSweepEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/terrablade_sweep.png");

    public SwordSweepRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SwordSweepEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float fadeMultiplier;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)TEXTURE));
        int baseAlpha = 196;
        float lifespanPercent = ((float)entity.f_19797_ + partialTicks) / (float)entity.getLifespan();
        if (lifespanPercent <= 0.9f) {
            fadeMultiplier = 1.0f;
        } else {
            float fade = (lifespanPercent - 0.9f) / 0.1f;
            fadeMultiplier = 1.0f - Mth.m_14036_((float)fade, (float)0.0f, (float)1.0f);
        }
        int vertexAlpha = Mth.m_14045_((int)Math.round((float)baseAlpha * fadeMultiplier), (int)0, (int)255);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) - 180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        this.createBladeSweep(entity, poseStack, vertexConsumer, 0.03125f * entity.m_20206_(), vertexAlpha);
        poseStack.m_85849_();
    }

    private void createBladeSweep(SwordSweepEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, float scale, int vertexAlpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        float xTilt = Mth.m_216283_((RandomSource)RandomSource.m_216335_((long)entity.m_20148_().getLeastSignificantBits()), (float)-30.0f, (float)30.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xTilt));
        this.drawQuad(poseStack, vertexConsumer, vertexAlpha);
        poseStack.m_85849_();
    }

    private void drawQuad(PoseStack poseStack, VertexConsumer vertexConsumer, int vertexAlpha) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        int width = 10;
        int height = 32;
        float halfWidth = (float)width / 2.0f;
        float halfHeight = (float)height / 2.0f;
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)(-halfWidth), (float)(-halfHeight), (float)0.0f, (float)0.0f, (float)0.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)halfWidth, (float)(-halfHeight), (float)0.0f, (float)1.0f, (float)0.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)halfWidth, (float)halfHeight, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)(-halfWidth), (float)halfHeight, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)(-halfWidth), (float)halfHeight, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)halfWidth, (float)halfHeight, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)halfWidth, (float)(-halfHeight), (float)0.0f, (float)1.0f, (float)0.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
        VertexBuilder.vertex((VertexConsumer)vertexConsumer, (Matrix4f)matrix, (Matrix3f)normalMatrix, (float)(-halfWidth), (float)(-halfHeight), (float)0.0f, (float)0.0f, (float)0.0f, (int)255, (int)255, (int)255, (int)vertexAlpha);
    }

    public ResourceLocation getTextureLocation(SwordSweepEntity entity) {
        return TEXTURE;
    }
}

