/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.turtleboi.bytebuddies.client.HueShiftTextureCache;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.entity.entities.HologramBuddyEntity;
import net.turtleboi.bytebuddies.entity.models.ByteBuddyModel;
import net.turtleboi.turtlecore.client.util.TintingBuffer;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ByteBuddyRenderer
extends MobRenderer<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddy.png");
    private static final ResourceLocation IRON_TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddy_iron.png");
    private static final ResourceLocation STEEL_TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddy_steel.png");
    private static final ResourceLocation NETHERITE_TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddy_netherite.png");
    private static final ResourceLocation CHARGED_STEEL_TEXTURE = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddy_charged_steel.png");
    private static final ResourceLocation DISPLAY = new ResourceLocation("bytebuddies", "textures/entity/bytebuddy/bytebuddycore.png");
    static List<HueShiftTextureCache.Rect> DISPLAY_BG_UVS = List.of(new HueShiftTextureCache.Rect(8, 8, 8, 8), new HueShiftTextureCache.Rect(24, 8, 8, 8), new HueShiftTextureCache.Rect(0, 8, 8, 8), new HueShiftTextureCache.Rect(16, 8, 8, 8), new HueShiftTextureCache.Rect(16, 0, 8, 8), new HueShiftTextureCache.Rect(16, 0, 8, 8));
    private static final HueShiftTextureCache BG_CACHE = new HueShiftTextureCache(DISPLAY, "display_bg_", DISPLAY_BG_UVS);

    public ByteBuddyRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new ByteBuddyModel(pContext.m_174023_(ByteBuddyModel.BYTEBUDDY_LAYER)), 0.5f);
        this.m_115326_(new DisplayLayer((RenderLayerParent<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>>)this));
        this.m_115326_(new BuddyItemInHandLayer((RenderLayerParent<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>>)this, pContext.m_234598_()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ByteBuddyEntity byteBuddy) {
        ByteBuddyEntity.ChassisMaterial chassisMaterial = byteBuddy.getChassisMaterial();
        return switch (chassisMaterial) {
            case ByteBuddyEntity.ChassisMaterial.CHARGED_STEEL -> CHARGED_STEEL_TEXTURE;
            case ByteBuddyEntity.ChassisMaterial.NETHERITE -> NETHERITE_TEXTURE;
            case ByteBuddyEntity.ChassisMaterial.STEEL -> STEEL_TEXTURE;
            case ByteBuddyEntity.ChassisMaterial.IRON -> IRON_TEXTURE;
            default -> DEFAULT_TEXTURE;
        };
    }

    public void render(ByteBuddyEntity entity, float yaw, float partialTicks, PoseStack pose, MultiBufferSource buffers, int packedLight) {
        ((ByteBuddyModel)this.f_115290_).setDisplayVisibility(false, false);
        super.m_7392_((Mob)entity, yaw, partialTicks, pose, buffers, packedLight);
        ((ByteBuddyModel)this.f_115290_).setDisplayVisibility(true, true);
    }

    private static class DisplayLayer
    extends RenderLayer<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>> {
        DisplayLayer(RenderLayerParent<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>> parent) {
            super(parent);
        }

        public void render(@NotNull PoseStack pose, MultiBufferSource buffers, int packedLight, ByteBuddyEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ByteBuddyModel model = (ByteBuddyModel)this.m_117386_();
            model.setDisplayVisibility(true, true);
            pose.m_85836_();
            model.translateToDisplay(pose);
            int targetRGB = entity.getDisplayColorRGB();
            ResourceLocation tintedSheet = BG_CACHE.getOrCreate(targetRGB);
            if (entity instanceof HologramBuddyEntity) {
                VertexConsumer holoBuf = buffers.m_6299_(RenderType.m_110470_((ResourceLocation)DISPLAY));
                model.renderDisplayBg(pose, holoBuf, packedLight, OverlayTexture.f_118083_, 0x73FFFFFF);
            } else {
                VertexConsumer baseBuf = buffers.m_6299_(RenderType.m_110458_((ResourceLocation)tintedSheet));
                model.renderDisplayBg(pose, baseBuf, packedLight, OverlayTexture.f_118083_, -1);
            }
            ResourceLocation faceTex = entity.getMoodTexture();
            VertexConsumer faceBuf = buffers.m_6299_(RenderType.m_110470_((ResourceLocation)faceTex));
            PoseStack.Pose cur = pose.m_85850_();
            Matrix4f mat = cur.m_252922_();
            Matrix3f normalMat = cur.m_252943_();
            float scaling = 0.0625f;
            float x1 = -0.25f;
            float y1 = -0.25f;
            float x2 = 0.25f;
            float y2 = 0.25f;
            float z = -0.1281875f;
            float u1 = 0.0f;
            float v1 = 0.0f;
            float u2 = 1.0f;
            float v2 = 1.0f;
            int r = 255;
            int g = 255;
            int b = 255;
            int a = 255;
            faceBuf.m_252986_(mat, x1, y1, z).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMat, 0.0f, 0.0f, -1.0f).m_5752_();
            faceBuf.m_252986_(mat, x1, y2, z).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMat, 0.0f, 0.0f, -1.0f).m_5752_();
            faceBuf.m_252986_(mat, x2, y2, z).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMat, 0.0f, 0.0f, -1.0f).m_5752_();
            faceBuf.m_252986_(mat, x2, y1, z).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMat, 0.0f, 0.0f, -1.0f).m_5752_();
            pose.m_85849_();
            model.setDisplayVisibility(false, false);
        }
    }

    private static final class BuddyItemInHandLayer
    extends RenderLayer<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>> {
        private final ItemInHandRenderer itemInHandRenderer;

        BuddyItemInHandLayer(RenderLayerParent<ByteBuddyEntity, ByteBuddyModel<ByteBuddyEntity>> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, ByteBuddyEntity byteBuddy, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack rightStack;
            boolean rightHanded = byteBuddy.m_5737_() == HumanoidArm.RIGHT;
            ItemStack leftStack = rightHanded ? byteBuddy.m_21206_() : byteBuddy.m_21205_();
            ItemStack itemStack = rightStack = rightHanded ? byteBuddy.m_21205_() : byteBuddy.m_21206_();
            if (!leftStack.m_41619_() || !rightStack.m_41619_()) {
                poseStack.m_85836_();
                if (((ByteBuddyModel)this.m_117386_()).f_102610_) {
                    poseStack.m_252880_(0.0f, 0.75f, 0.0f);
                    poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                }
                this.renderArmWithItem(byteBuddy, rightStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, multiBufferSource, packedLight);
                this.renderArmWithItem(byteBuddy, leftStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, multiBufferSource, packedLight);
                poseStack.m_85849_();
            }
        }

        private void renderArmWithItem(ByteBuddyEntity byteBuddy, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
            if (!itemStack.m_41619_()) {
                poseStack.m_85836_();
                ((ByteBuddyModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean isLeft = humanoidArm == HumanoidArm.LEFT;
                poseStack.m_252880_((float)(isLeft ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                boolean hologram = byteBuddy instanceof HologramBuddyEntity;
                MultiBufferSource actualBuffer = multiBufferSource;
                if (hologram) {
                    float red = 0.31764707f;
                    float green = 0.9411765f;
                    float blue = 1.0f;
                    float alpha = 0.45f;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    actualBuffer = new TintingBuffer(multiBufferSource, red, green, blue, alpha);
                }
                this.itemInHandRenderer.m_269530_((LivingEntity)byteBuddy, itemStack, displayContext, isLeft, poseStack, actualBuffer, packedLight);
                if (hologram) {
                    RenderSystem.disableBlend();
                }
                poseStack.m_85849_();
            }
        }
    }
}

