/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.turtleboi.bytebuddies.entity.animations.ByteBuddyAnimations;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    public static final ModelLayerLocation BYTEBUDDY_LAYER = new ModelLayerLocation(new ResourceLocation("bytebuddies", "bytebuddy"), "main");
    private final ModelPart bytebuddy;
    private final ModelPart head;
    private final ModelPart display;
    private final ModelPart displayBg;
    private final ModelPart displayFace;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ByteBuddyModel(ModelPart root) {
        this.bytebuddy = root.m_171324_("bytebuddy");
        this.head = this.bytebuddy.m_171324_("head");
        this.display = this.head.m_171324_("display");
        this.displayBg = this.display.m_171324_("displayBg");
        this.displayFace = this.display.m_171324_("displayFace");
        this.rightArm = this.bytebuddy.m_171324_("rightArm");
        this.leftArm = this.bytebuddy.m_171324_("leftArm");
        this.rightLeg = this.bytebuddy.m_171324_("rightLeg");
        this.leftLeg = this.bytebuddy.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bytebuddy = partdefinition.m_171599_("bytebuddy", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = bytebuddy.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition display = head.m_171599_("display", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.05f));
        display.m_171599_("displayBg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -1.95f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        display.m_171599_("displayFace", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -2.05f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        PartDefinition rightArm = bytebuddy.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-4.5f, (float)0.0f));
        PartDefinition leftArm = bytebuddy.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171480_().m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-4.5f, (float)0.0f));
        PartDefinition rightLeg = bytebuddy.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.25f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-1.75f, (float)0.0f));
        PartDefinition leftLeg = bytebuddy.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -1.25f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-1.75f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_6973_(@NotNull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ByteBuddyEntity byteBuddy = (ByteBuddyEntity)entity;
        if (!byteBuddy.m_5803_()) {
            if (byteBuddy.isWaking()) {
                this.m_233385_(byteBuddy.wakeUpState, ByteBuddyAnimations.WAKE_UP_ANIMATION, ageInTicks, 1.0f);
            }
            if (!byteBuddy.isWaking()) {
                this.applyHeadRotation(netHeadYaw, headPitch);
                this.m_267799_(ByteBuddyAnimations.WALKING_ANIMATION, limbSwing, limbSwingAmount, 2.0f, 2.4f);
                this.m_233385_(byteBuddy.idleAnimationState, ByteBuddyAnimations.IDLE_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isWaving()) {
                this.m_233385_(byteBuddy.waveState, ByteBuddyAnimations.WAVING_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isWorking()) {
                this.m_233385_(byteBuddy.workingState, ByteBuddyAnimations.WORK_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isSlamming()) {
                this.m_233385_(byteBuddy.slamState, ByteBuddyAnimations.SLAM_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isSlicing()) {
                this.m_233385_(byteBuddy.sliceState, ByteBuddyAnimations.SLICE_ANIMATION, ageInTicks, 1.0f);
            }
        } else {
            this.m_233385_(byteBuddy.sleepPoseState, ByteBuddyAnimations.INACTIVE_ANIMATION, ageInTicks, 1.0f);
        }
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.bytebuddy.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    public ModelPart m_142109_() {
        return this.bytebuddy;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.bytebuddy.m_104299_(poseStack);
        float scale = 0.63f;
        ModelPart armPart = arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
        armPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -5.0f * scale * 0.0625f, scale * 0.0625f);
        poseStack.m_85841_(scale, scale, scale);
    }

    public void setDisplayVisibility(boolean bgVisible, boolean faceVisible) {
        this.displayBg.f_104207_ = bgVisible;
        this.displayFace.f_104207_ = faceVisible;
    }

    public void translateToDisplay(PoseStack pose) {
        this.bytebuddy.m_104299_(pose);
        this.head.m_104299_(pose);
        this.display.m_104299_(pose);
    }

    public void renderDisplayBg(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        if ((color >> 24 & 0xFF) == 0) {
            a = 1.0f;
        }
        this.displayBg.m_104306_(poseStack, vertexConsumer, light, overlay, r, g, b, a);
    }
}

