/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.particle.ModParticles;
import org.jetbrains.annotations.NotNull;

public class SwordSweepEntity
extends Projectile {
    int lifespan = 40;
    private float projectileDamage = 0.0f;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private static final float originalWidth = 0.625f;
    private static final float originalHeight = 2.0f;
    private float entityWidth = 0.625f;
    private float entityHeight = 2.0f;
    private boolean traveling = false;
    private double travelDistance = 1.0;
    private double traveledDistance = 0.0;
    private int lastSize = -1;
    private static final EntityDataAccessor<Float> DATA_WIDTH = SynchedEntityData.m_135353_(SwordSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HEIGHT = SynchedEntityData.m_135353_(SwordSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public SwordSweepEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public SwordSweepEntity(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.SWORD_SWEEP.get()), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_WIDTH, (Object)Float.valueOf(0.625f));
        this.f_19804_.m_135372_(DATA_HEIGHT, (Object)Float.valueOf(2.0f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataValues) {
        super.m_7350_(dataValues);
        if (dataValues == DATA_WIDTH || dataValues == DATA_HEIGHT) {
            this.entityWidth = ((Float)this.f_19804_.m_135370_(DATA_WIDTH)).floatValue();
            this.entityHeight = ((Float)this.f_19804_.m_135370_(DATA_HEIGHT)).floatValue();
            this.m_146867_();
            this.m_6210_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 1; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.SUPERCHARGED_PARTICLE.get(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.3))) {
            if (entity == this.m_19749_() || !(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (this.hitEntities.contains(entity.m_20148_())) continue;
            target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getProjectileDamage());
            this.hitEntities.add(entity.m_20148_());
        }
        Vec3 deltaMovement = this.m_20184_();
        double nextX = this.m_20185_() + deltaMovement.f_82479_;
        double nextY = this.m_20186_() + deltaMovement.f_82480_;
        double nextZ = this.m_20189_() + deltaMovement.f_82481_;
        double decelRate = -0.125;
        double minSpeed = 0.125;
        Vec3 adjustedDelta = deltaMovement.m_82490_(1.0 + decelRate);
        double speed = adjustedDelta.m_82553_();
        if (speed < minSpeed) {
            if (speed > 1.0E-9) {
                adjustedDelta = adjustedDelta.m_82490_(minSpeed / speed);
            } else {
                Vec3 fallback = deltaMovement.m_82556_() > 1.0E-12 ? deltaMovement : this.m_20154_();
                adjustedDelta = fallback.m_82541_().m_82490_(minSpeed);
            }
        }
        if (!this.traveling) {
            int tickToStop;
            double initialSpeed = this.m_20184_().m_82553_();
            double decelFactorPerTick = 1.0 + decelRate;
            if (initialSpeed > minSpeed) {
                tickToStop = (int)Math.ceil(Math.log(minSpeed / initialSpeed) / Math.log(decelFactorPerTick));
                tickToStop = Math.max(0, Math.min(tickToStop, this.getLifespan()));
            } else {
                tickToStop = 0;
            }
            double distanceBeforeStop = 0.0;
            if (tickToStop > 0) {
                distanceBeforeStop = initialSpeed * (1.0 - Math.pow(decelFactorPerTick, tickToStop)) / (1.0 - decelFactorPerTick);
            }
            int remainingTicks = Math.max(0, this.getLifespan() - tickToStop);
            double distanceAfterStop = (double)remainingTicks * minSpeed;
            this.travelDistance = Math.max(1.0E-6, distanceBeforeStop + distanceAfterStop);
            this.traveledDistance = 0.0;
            this.traveling = true;
        }
        this.traveledDistance += adjustedDelta.m_82553_();
        this.m_20256_(adjustedDelta);
        this.f_19812_ = true;
        this.m_6034_(nextX, nextY, nextZ);
        this.updateSizeFromScale();
        if (this.f_19797_ > this.lifespan) {
            this.m_146870_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.entityWidth, (float)this.entityHeight);
    }

    private void updateSizeFromScale() {
        float scaleMultiplier = this.getScaleMultiplier();
        float targetWidth = 0.625f * scaleMultiplier;
        float targetHeight = 2.0f * scaleMultiplier;
        int scale = Mth.m_14143_((float)(scaleMultiplier * 32.0f));
        if (!this.m_9236_().f_46443_ && scale != this.lastSize) {
            this.lastSize = scale;
            this.f_19804_.m_135381_(DATA_WIDTH, (Object)Float.valueOf(targetWidth));
            this.f_19804_.m_135381_(DATA_HEIGHT, (Object)Float.valueOf(targetHeight));
            this.entityWidth = targetWidth;
            this.entityHeight = targetHeight;
            this.m_6210_();
        }
    }

    private float getScaleMultiplier() {
        double distanceProgress = this.travelDistance <= 0.0 ? 1.0 : Mth.m_14008_((double)(this.traveledDistance / this.travelDistance), (double)0.0, (double)1.0);
        float progress = (float)distanceProgress;
        return progress * 2.0f + 0.25f;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setProjectileDamage(float projectileDamage) {
        this.projectileDamage = projectileDamage;
    }

    public float getProjectileDamage() {
        return this.projectileDamage;
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
        }
    }

    protected void m_5790_(EntityHitResult result) {
    }

    protected void m_8060_(BlockHitResult result) {
    }
}

