/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.FloppyDiskItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;

public class HologramBuddyEntity
extends ByteBuddyEntity {
    @Nullable
    private UUID parentBuddyUUID = null;
    private int lifetimeTicks = 200;

    public HologramBuddyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.m_20331_(true);
    }

    @Nullable
    public static HologramBuddyEntity spawnFrom(ByteBuddyEntity sourceBuddy, EntityType<? extends ByteBuddyEntity> hologramType, BlockPos spawnAt, int lifetimeTicks) {
        ServerLevel serverLevel;
        HologramBuddyEntity candidate;
        HologramBuddyEntity created = null;
        Level level = sourceBuddy.m_9236_();
        if (level instanceof ServerLevel && (candidate = (HologramBuddyEntity)hologramType.m_20615_((Level)(serverLevel = (ServerLevel)level))) != null) {
            candidate.copyLightweightStateFrom(sourceBuddy);
            candidate.setLifetimeTicks(lifetimeTicks);
            candidate.m_6034_((double)spawnAt.m_123341_() + 0.5, spawnAt.m_123342_(), (double)spawnAt.m_123343_() + 0.5);
            sourceBuddy.getOwnerUUID().ifPresent(candidate::setOwnerUUID);
            candidate.setSleeping(false);
            serverLevel.m_7967_((Entity)candidate);
            created = candidate;
        }
        return created;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifetimeTicks > 0) {
            --this.lifetimeTicks;
        }
        if (this.lifetimeTicks <= 0) {
            this.transferInvOnExpire();
            this.m_146870_();
        }
    }

    private void copyLightweightStateFrom(ByteBuddyEntity source) {
        this.setBuddyRole(source.getBuddyRole());
        this.setParentBuddyUUID(source.m_20148_());
        if (source.getDock().isPresent()) {
            this.setDock(source.getDock().get());
        }
        this.setDisplayColorRGB(source.getDisplayColorRGB());
        this.setChassisMaterial(source.getChassisMaterial());
        this.setStorageCellsTier(source.getStorageCellsTier());
        this.setMood(source.getMood());
        this.setAttackMode(source.getAttackMode());
        this.copyInventory(source);
        this.receiveEnergy(16000, false);
        this.refreshEffects();
    }

    public void setLifetimeTicks(int ticks) {
        this.lifetimeTicks = Math.max(ticks, 1);
    }

    private void copyInventory(ByteBuddyEntity source) {
        int[] slotsToCopy;
        ItemStackHandler sourceHandler = source.getMainInv();
        ItemStackHandler targetHandler = this.getMainInv();
        for (int slotIndex : slotsToCopy = new int[]{0, 1, 2, 3, 8}) {
            ItemStack sourceStack = sourceHandler.getStackInSlot(slotIndex);
            if (!sourceStack.m_41619_()) {
                ItemStack copied = sourceStack.m_41777_();
                int targetLimit = targetHandler.getSlotLimit(slotIndex);
                if (copied.m_41613_() > targetLimit) {
                    copied.m_41764_(targetLimit);
                }
                targetHandler.setStackInSlot(slotIndex, copied);
                continue;
            }
            targetHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
        }
    }

    public void setParentBuddyUUID(@Nullable UUID uuid) {
        this.parentBuddyUUID = uuid;
    }

    @Nullable
    private ByteBuddyEntity resolveParentBuddy(ServerLevel serverLevel) {
        Entity entity;
        ByteBuddyEntity parent = null;
        if (this.parentBuddyUUID != null && (entity = serverLevel.m_8791_(this.parentBuddyUUID)) instanceof ByteBuddyEntity) {
            ByteBuddyEntity byteBuddy;
            parent = byteBuddy = (ByteBuddyEntity)entity;
        }
        return parent;
    }

    private void transferInvOnExpire() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            double dropZ;
            double dropY;
            double dropX;
            ItemStackHandler targetHandler;
            ServerLevel serverLevel = (ServerLevel)level;
            ByteBuddyEntity parent = this.resolveParentBuddy(serverLevel);
            ItemStackHandler sourceHandler = this.getMainInv();
            ItemStackHandler itemStackHandler = targetHandler = parent != null ? parent.getMainInv() : null;
            if (parent != null) {
                dropX = parent.m_20185_() + 0.5;
                dropY = parent.m_20186_() + 0.75;
                dropZ = parent.m_20189_() + 0.5;
            } else {
                dropX = this.m_20185_() + 0.5;
                dropY = this.m_20186_() + 0.75;
                dropZ = this.m_20189_() + 0.5;
            }
            for (int slotIndex = 9; slotIndex <= 35; ++slotIndex) {
                ItemStack toInsert;
                ItemStack stackInSlot = sourceHandler.getStackInSlot(slotIndex);
                if (stackInSlot.m_41619_()) continue;
                ItemStack leftover = toInsert = stackInSlot.m_41777_();
                if (targetHandler != null) {
                    leftover = InventoryUtil.mergeInto(targetHandler, toInsert);
                }
                if (leftover.m_41619_()) {
                    sourceHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
                    continue;
                }
                sourceHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
                Containers.m_18992_((Level)serverLevel, (double)dropX, (double)dropY, (double)dropZ, (ItemStack)leftover);
            }
        }
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return InteractionResult.CONSUME;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_5829_() {
        return false;
    }

    protected void m_6138_() {
    }

    @Override
    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(0.25);
    }

    @Override
    public void onTaskSuccess(ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
        FloppyDiskItem.DiskHooks.tryGiveByproduct(this, taskType, blockPos);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("HoloLife", this.lifetimeTicks);
        if (this.parentBuddyUUID != null) {
            tag.m_128362_("HoloParent", this.parentBuddyUUID);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.lifetimeTicks = Math.max(1, tag.m_128451_("HoloLife"));
        if (tag.m_128403_("HoloParent")) {
            this.parentBuddyUUID = tag.m_128342_("HoloParent");
        }
    }
}

