/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.ai.AccessInventoryGoal;
import net.turtleboi.bytebuddies.entity.ai.BuddyFollowOwnerGoal;
import net.turtleboi.bytebuddies.entity.ai.BuddyPickUpItemGoal;
import net.turtleboi.bytebuddies.entity.ai.DepositToDockGoal;
import net.turtleboi.bytebuddies.entity.ai.RandomWaveAtFriendGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyHurtByTargetGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyMeleeAttackGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyOwnerHurtByTargetGoal;
import net.turtleboi.bytebuddies.entity.ai.combat.BuddyOwnerHurtTargetGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.HarvestGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.PlantGoal;
import net.turtleboi.bytebuddies.entity.ai.farmer.TillGoal;
import net.turtleboi.bytebuddies.entity.ai.miner.QuarryGoal;
import net.turtleboi.bytebuddies.entity.ai.storage.HaulerGoal;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.item.custom.AugmentItem;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.item.custom.FloppyDiskItem;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyDoubleMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.ByteBuddyTripleMenu;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;
import net.turtleboi.turtlecore.init.CoreAttributeModifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteBuddyEntity
extends PathfinderMob
implements IEnergyStorage {
    private final ItemStackHandler mainInv = new ItemStackHandler(36){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            return switch (slot) {
                case 0 -> ByteBuddyEntity.isAnyTool(itemStack);
                case 1, 2 -> {
                    int otherAugmentSlot;
                    ItemStack otherStack;
                    int otherAugmentSlot;
                    ItemStack otherStack;
                    if (!itemStack.m_204117_(ModTags.Items.AUGMENT)) {
                        yield false;
                    }
                    boolean isPlating = itemStack.m_204117_(ModTags.Items.PLATING);
                    if (isPlating && !(otherStack = this.getStackInSlot(otherAugmentSlot = slot == 1 ? 2 : 1)).m_41619_() && otherStack.m_204117_(ModTags.Items.PLATING)) {
                        yield false;
                    }
                    boolean isStorageCell = itemStack.m_204117_(ModTags.Items.STORAGE_CELL);
                    if (isStorageCell && !(otherStack = this.getStackInSlot(otherAugmentSlot = slot == 1 ? 2 : 1)).m_41619_() && otherStack.m_204117_(ModTags.Items.STORAGE_CELL)) {
                        yield false;
                    }
                    yield true;
                }
                case 3 -> InventoryUtil.isBattery(itemStack);
                case 4, 5, 6, 7 -> InventoryUtil.isFloppyDisk(itemStack);
                case 8 -> InventoryUtil.isClipboard(itemStack);
                case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> true;
                case 18, 19, 20, 21, 22, 23, 24, 25, 26 -> {
                    if (ByteBuddyEntity.this.getStorageCellsExtraSlots() >= 9) {
                        yield true;
                    }
                    yield false;
                }
                case 27, 28, 29, 30, 31, 32, 33, 34, 35 -> {
                    if (ByteBuddyEntity.this.getStorageCellsExtraSlots() >= 18) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        protected int getStackLimit(int slot, ItemStack itemStack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> 1;
                default -> 64;
            };
        }

        protected void onContentsChanged(int slot) {
            if (!ByteBuddyEntity.this.m_9236_().f_46443_) {
                ByteBuddyEntity.this.refreshEffects();
                ByteBuddyEntity.this.computeChassis();
            }
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(16000, 256, 256);
    private BuddyRole buddyRole = BuddyRole.NONE;
    private final Set<Goal> roleGoals = new HashSet<Goal>();
    @Nullable
    private BlockPos dockPos;
    private final FloppyDiskItem.DiskEffects diskEffects = new FloppyDiskItem.DiskEffects();
    private final AugmentItem.AugmentEffects augmentEffects = new AugmentItem.AugmentEffects();
    private static final ChassisMaterial defaultChassis = ChassisMaterial.ALUMINUM;
    private double augmentPrevX;
    private double augmentPrevY;
    private double augmentPrevZ;
    private double augmentMoveAccumMeters;
    private static final String momentumUntil = "dynamo_momentum_until";
    private boolean farmingEnabled = false;
    private boolean harvestEnabled = false;
    private boolean plantEnabled = false;
    private boolean tillEnabled = false;
    private boolean miningEnabled = false;
    private boolean quarryEnabled = false;
    private boolean haulingEnabled = false;
    private static final int baseCooldown = 20;
    private long cooldownUntil = 0L;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_WAKING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_WAVING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_WORKING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLAMMING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLICING = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_ROLE = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ENERGY = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHASSIS_MATERIAL = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STORAGE_CELLS_TIER = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DISPLAY_RGB = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOOD_ID = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_MODE = SynchedEntityData.m_135353_(ByteBuddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState sleepPoseState = new AnimationState();
    public final AnimationState wakeUpState = new AnimationState();
    private int wakingAnimationTimeout = 0;
    public final AnimationState workingState = new AnimationState();
    public final AnimationState slamState = new AnimationState();
    public final AnimationState sliceState = new AnimationState();
    public final AnimationState waveState = new AnimationState();
    private static final int FIRST_CARGO_SLOT = 9;
    private int openGuiCount = 0;
    @Nullable
    private UUID currentViewerId = null;
    @Nullable
    private PlantRequest pendingPlantRequest;
    private long replantHoldUntil = 0L;
    private Goal followOwnerGoal;
    private Goal ownerHurtBY;
    private Goal ownerHurt;
    private Goal hurtAnythingHostile;
    private Goal meleeAttackGoal;
    private Goal hurtByTargetGoal;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::getMainInv);

    public ByteBuddyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)true);
        this.f_19804_.m_135372_(DATA_WAKING, (Object)false);
        this.f_19804_.m_135372_(DATA_WAVING, (Object)false);
        this.f_19804_.m_135372_(DATA_WORKING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLAMMING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLICING, (Object)false);
        this.f_19804_.m_135372_(DATA_ROLE, (Object)BuddyRole.NONE.ordinal());
        this.f_19804_.m_135372_(CHASSIS_MATERIAL, (Object)defaultChassis.ordinal());
        this.f_19804_.m_135372_(STORAGE_CELLS_TIER, (Object)StorageCellsTier.NONE.ordinal());
        this.f_19804_.m_135372_(DATA_ENERGY, (Object)0);
        this.f_19804_.m_135372_(DISPLAY_RGB, (Object)DyeColor.CYAN.m_41070_());
        this.f_19804_.m_135372_(MOOD_ID, (Object)Mood.NEUTRAL.ordinal());
        this.f_19804_.m_135372_(ATTACK_MODE, (Object)AttackMode.PASSIVE.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 1.6).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22278_, 0.05);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.augmentPrevX = this.m_20185_();
            this.augmentPrevY = this.m_20186_();
            this.augmentPrevZ = this.m_20189_();
            this.refreshEffects();
            this.refreshCombatGoals();
        }
    }

    protected void m_20101_() {
    }

    public void reloadBuddy() {
        this.disableTasks();
        this.rebuildGoalsForRole();
        this.refreshEffects();
    }

    @NotNull
    public ItemStack m_21205_() {
        return this.mainInv.getStackInSlot(0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AccessInventoryGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new GatedGoal(this, () -> this.canAct() && this.canSwim(), (Goal)new FloatGoal((Mob)this), 0));
        this.f_21345_.m_25352_(1, (Goal)new GatedGoal(this, () -> this.canAct() && this.canPanic(), (Goal)new PanicGoal((PathfinderMob)this, 2.0), 0));
        this.f_21345_.m_25352_(2, (Goal)new GatedGoal(this, () -> this.canAct() && this.getDock().isEmpty(), new BuddyFollowOwnerGoal(this, 1.05, 4.0f, 16.0f, true), 0));
        this.f_21345_.m_25352_(5, (Goal)new GatedGoal(this, this::canAct, new BuddyPickUpItemGoal(this, 1.2, 6.0, 0.9, 10), 8));
        this.f_21345_.m_25352_(6, (Goal)new GatedGoal(this, () -> this.canAct() && this.isInventoryFull(), new DepositToDockGoal(this), 0));
        this.f_21345_.m_25352_(7, (Goal)new GatedGoal(this, this::canAct, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75), 0));
        this.f_21345_.m_25352_(8, (Goal)new GatedGoal(this, this::canAct, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f), 0));
        this.f_21345_.m_25352_(9, (Goal)new GatedGoal(this, this::canAct, (Goal)new RandomLookAroundGoal((Mob)this), 0));
        this.f_21345_.m_25352_(10, (Goal)new GatedGoal(this, this::canAct, new RandomWaveAtFriendGoal(this, 6.0, 120, 40), 0));
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void clearOwner() {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
    }

    public boolean hasOwner() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent();
    }

    public boolean isOwnedBy(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        return this.getOwnerUUID().map(entity.m_20148_()::equals).orElse(false);
    }

    public ServerPlayer getOwner(ServerLevel serverLevel) {
        Optional<UUID> id = this.getOwnerUUID();
        return id.map(buddyId -> serverLevel.m_7654_().m_6846_().m_11259_(buddyId)).orElse(null);
    }

    public void setOwner(@Nullable Player player) {
        this.setOwnerUUID(player == null ? null : player.m_20148_());
    }

    public boolean m_21515_() {
        return super.m_21515_() && this.canAct();
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)sleeping);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (sleeping) {
                this.armCooldown(serverLevel, Integer.MAX_VALUE);
                this.setMood(Mood.SLEEP);
                this.m_21573_().m_26573_();
                this.m_20334_(0.0, this.m_20184_().f_82480_ * 0.0, 0.0);
                this.m_21561_(false);
                this.setWorking(false);
                this.setSlamming(false);
                this.setMood(Mood.SLEEP);
            } else {
                this.armCooldown(serverLevel, 8);
                this.setMood(Mood.NEUTRAL);
            }
        }
    }

    public boolean isWaking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WAKING);
    }

    private void setWaking(boolean wakening) {
        this.f_19804_.m_135381_(DATA_WAKING, (Object)wakening);
    }

    public boolean isWaving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WAVING);
    }

    public void setWaving(boolean waving) {
        this.f_19804_.m_135381_(DATA_WAVING, (Object)waving);
    }

    public boolean isWorking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WORKING);
    }

    public void setWorking(boolean working) {
        this.f_19804_.m_135381_(DATA_WORKING, (Object)working);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLAMMING);
    }

    public void setSlamming(boolean slamming) {
        this.f_19804_.m_135381_(DATA_SLAMMING, (Object)slamming);
    }

    public boolean isSlicing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLICING);
    }

    public void setSlicing(boolean slicing) {
        this.f_19804_.m_135381_(DATA_SLICING, (Object)slicing);
    }

    public void setFarmingEnabled(boolean farmingEnabled) {
        this.farmingEnabled = farmingEnabled;
    }

    public void setHarvestEnabled(boolean harvestEnabled) {
        this.harvestEnabled = harvestEnabled;
    }

    public void setPlantEnabled(boolean plantingEnabled) {
        this.plantEnabled = plantingEnabled;
    }

    public void setTillEnabled(boolean tillingEnabled) {
        this.tillEnabled = tillingEnabled;
    }

    public boolean isFarmingEnabled() {
        return this.farmingEnabled;
    }

    public boolean isHarvestEnabled() {
        return this.farmingEnabled && this.harvestEnabled;
    }

    public boolean isPlantEnabled() {
        return this.farmingEnabled && this.plantEnabled;
    }

    public boolean isTillEnabled() {
        return this.farmingEnabled && this.tillEnabled;
    }

    public void setMiningEnabled(boolean miningEnabled) {
        this.miningEnabled = miningEnabled;
    }

    private boolean isMiningEnabled() {
        return this.miningEnabled;
    }

    public void setHaulingEnabled(boolean haulingEnabled) {
        this.haulingEnabled = haulingEnabled;
    }

    public boolean isHaulingEnabled() {
        return this.haulingEnabled;
    }

    public boolean cooldownActive(ServerLevel serverLevel) {
        return serverLevel.m_46467_() < this.cooldownUntil;
    }

    public void armCooldown(ServerLevel serverLevel, int ticks) {
        this.cooldownUntil = serverLevel.m_46467_() + (long)ticks;
    }

    public void setQuarryEnabled(boolean quarryEnabled) {
        this.quarryEnabled = quarryEnabled;
    }

    private boolean isQuarryEnabled() {
        return this.miningEnabled & this.quarryEnabled;
    }

    public boolean canAct() {
        return !this.m_5803_();
    }

    public boolean canPanic() {
        return this.getBuddyRole() != BuddyRole.COMBAT;
    }

    public AttackMode getAttackMode() {
        int i = (Integer)this.f_19804_.m_135370_(ATTACK_MODE);
        return AttackMode.values()[Mth.m_14045_((int)i, (int)0, (int)(AttackMode.values().length - 1))];
    }

    public void setAttackMode(AttackMode mode) {
        this.f_19804_.m_135381_(ATTACK_MODE, (Object)mode.ordinal());
        if (!this.m_9236_().f_46443_) {
            this.refreshCombatGoals();
        }
    }

    private static AttackMode cycleAttackMode(AttackMode attackMode, boolean backwards) {
        AttackMode[] attackValues = AttackMode.values();
        int attackModes = attackValues.length;
        int i = attackMode.ordinal();
        int next = backwards ? (i - 1 + attackModes) % attackModes : (i + 1) % attackModes;
        return attackValues[next];
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setSleeping(true);
        this.m_21557_(true);
        this.m_21530_();
        return spawnData;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.mainInv.getStackInSlot(0);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.armorItems.get(slot.m_20749_());
    }

    public void m_8061_(EquipmentSlot slot, ItemStack itemStack) {
        if (slot == EquipmentSlot.MAINHAND) {
            if (ByteBuddyEntity.isAnyTool(itemStack)) {
                ItemStack originalItemStack = this.mainInv.getStackInSlot(0);
                ItemStack newItemStack = itemStack.m_41777_();
                newItemStack.m_41764_(1);
                this.mainInv.setStackInSlot(0, newItemStack);
                this.m_238392_(slot, originalItemStack, newItemStack);
                return;
            }
            return;
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return;
        }
        this.m_181122_(itemStack);
        this.m_238392_(slot, (ItemStack)this.armorItems.set(slot.m_20749_(), (Object)itemStack), itemStack);
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public int getHeldToolSlot() {
        return 0;
    }

    public ItemStack getHeldTool() {
        return this.mainInv.getStackInSlot(0);
    }

    public int getBatterySlot() {
        return 3;
    }

    public ItemStack getBattery() {
        return this.mainInv.getStackInSlot(3);
    }

    public boolean isInventoryFull() {
        ItemStackHandler mainInventory = this.getMainInv();
        for (int slot = 9; slot <= this.lastCargoSlot(); ++slot) {
            ItemStack itemStack = mainInventory.getStackInSlot(slot);
            if (!itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean canFitInInventory(ItemStack incomingStack) {
        if (incomingStack == null || incomingStack.m_41619_()) {
            return false;
        }
        ItemStackHandler mainInventory = this.getMainInv();
        ItemStack toInsert = incomingStack.m_41777_();
        for (int slot = 9; slot <= this.lastCargoSlot(); ++slot) {
            if (!mainInventory.isItemValid(slot, toInsert) || !(toInsert = mainInventory.insertItem(slot, toInsert, true)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private int lastCargoSlot() {
        int extraSlots = this.getStorageCellsExtraSlots();
        if (extraSlots >= 18) {
            return 35;
        }
        if (extraSlots >= 9) {
            return 26;
        }
        return 17;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.dropAllFromHandler((IItemHandler)this.getMainInv());
    }

    private void dropAllFromHandler(IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            ItemStack itemStack = itemHandler.getStackInSlot(slotIndex);
            if (itemStack.m_41619_()) continue;
            this.m_19983_(itemStack.m_41777_());
            if (itemHandler instanceof ItemStackHandler) {
                ItemStackHandler mutableHandler = (ItemStackHandler)itemHandler;
                mutableHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
                continue;
            }
            itemHandler.extractItem(slotIndex, itemStack.m_41613_(), false);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            int currentEnergy;
            if (this.isWaking() && this.wakingAnimationTimeout++ >= 56) {
                this.wakingAnimationTimeout = 0;
                this.setWaking(false);
            }
            if (this.f_19797_ % 10 == 0) {
                this.consumeEnergy(5);
            }
            if (this.f_19797_ % 20 == 0) {
                BatteryItem.buddyDrainBatteries(this);
                this.tickAugmentRuntime();
                if (this.supportAuraEnabled()) {
                    SupportAuras.tickSupportLattice(this);
                }
            }
            if ((currentEnergy = this.energyStorage.getEnergyStored()) != this.getSyncedEnergy()) {
                this.setSyncedEnergy(currentEnergy);
            }
            this.tickPropellerPhysics();
            this.tickDynamoMovement();
            this.tickMomentumExpiry();
            this.tickMagnet();
        } else {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.m_5803_()) {
            if (!this.sleepPoseState.m_216984_()) {
                this.sleepPoseState.m_216977_(this.f_19797_);
            }
        } else {
            this.sleepPoseState.m_216973_();
        }
        if (!this.m_5803_()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 40;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
        }
        if (this.isWaking()) {
            if (!this.wakeUpState.m_216984_()) {
                this.wakeUpState.m_216977_(this.f_19797_);
                this.wakingAnimationTimeout = 56;
            } else if (this.wakingAnimationTimeout-- <= 0) {
                this.wakeUpState.m_216973_();
            }
        } else {
            this.wakeUpState.m_216973_();
        }
        if (this.isWaving()) {
            if (!this.waveState.m_216984_()) {
                this.waveState.m_216977_(this.f_19797_);
            }
        } else if (this.waveState.m_216984_()) {
            this.waveState.m_216973_();
        }
        if (this.isWorking()) {
            if (!this.workingState.m_216984_()) {
                this.workingState.m_216977_(this.f_19797_);
            }
        } else if (this.workingState.m_216984_()) {
            this.workingState.m_216973_();
        }
        if (this.isSlamming()) {
            if (!this.slamState.m_216984_()) {
                this.slamState.m_216977_(this.f_19797_);
            }
        } else if (this.slamState.m_216984_()) {
            this.slamState.m_216973_();
        }
        if (this.isSlicing()) {
            if (!this.sliceState.m_216984_()) {
                this.sliceState.m_216977_(this.f_19797_);
            }
        } else if (this.sliceState.m_216984_()) {
            this.sliceState.m_216973_();
        }
    }

    public void m_6135_() {
        super.m_6135_();
        if (this.canFly()) {
            Vec3 currentDelta = this.m_20184_();
            double boostedY = currentDelta.f_82480_ + 0.25;
            if (boostedY > 0.7) {
                boostedY = 0.7;
            }
            this.m_20334_(currentDelta.f_82479_, boostedY, currentDelta.f_82481_);
            this.f_19812_ = true;
        }
    }

    public void onTaskSuccess(TaskType taskType, BlockPos blockPos) {
        FloppyDiskItem.DiskHooks.tryGiveByproduct(this, taskType, blockPos);
        FloppyDiskItem.DiskHooks.trySpawnHologram(this, taskType);
        this.addDynamoEffect();
    }

    public ChassisMaterial getChassisMaterial() {
        int ordinal = (Integer)this.f_19804_.m_135370_(CHASSIS_MATERIAL);
        int max = ChassisMaterial.values().length - 1;
        int clamped = Mth.m_14045_((int)ordinal, (int)0, (int)max);
        return ChassisMaterial.values()[clamped];
    }

    public void setChassisMaterial(ChassisMaterial material) {
        this.f_19804_.m_135381_(CHASSIS_MATERIAL, (Object)material.ordinal());
    }

    private void computeChassis() {
        ChassisMaterial current;
        if (this.m_9236_().f_46443_) {
            return;
        }
        ChassisMaterial computed = this.computeChassisTier();
        if (computed != (current = this.getChassisMaterial())) {
            this.setChassisMaterial(computed);
        }
    }

    private ChassisMaterial computeChassisTier() {
        ChassisMaterial chassisMaterial = ChassisMaterial.ALUMINUM;
        for (int i = 1; i < 3; ++i) {
            ItemStack stack = this.mainInv.getStackInSlot(i);
            if (stack.m_150930_((Item)ModItems.REINFORCED_CHARGED_STEEL_PLATING.get())) {
                chassisMaterial = ChassisMaterial.CHARGED_STEEL;
                continue;
            }
            if (stack.m_150930_((Item)ModItems.REINFORCED_NETHERITE_PLATING.get())) {
                if (chassisMaterial.ordinal() >= ChassisMaterial.NETHERITE.ordinal()) continue;
                chassisMaterial = ChassisMaterial.NETHERITE;
                continue;
            }
            if (stack.m_150930_((Item)ModItems.REINFORCED_STEEL_PLATING.get())) {
                if (chassisMaterial.ordinal() >= ChassisMaterial.STEEL.ordinal()) continue;
                chassisMaterial = ChassisMaterial.STEEL;
                continue;
            }
            if (!stack.m_150930_((Item)ModItems.REINFORCED_IRON_PLATING.get()) || chassisMaterial.ordinal() >= ChassisMaterial.IRON.ordinal()) continue;
            chassisMaterial = ChassisMaterial.IRON;
        }
        return chassisMaterial;
    }

    public StorageCellsTier getStorageCellsTier() {
        int ordinal = (Integer)this.f_19804_.m_135370_(STORAGE_CELLS_TIER);
        return StorageCellsTier.values()[Mth.m_14045_((int)ordinal, (int)0, (int)(StorageCellsTier.values().length - 1))];
    }

    public void setStorageCellsTier(StorageCellsTier tier) {
        this.f_19804_.m_135381_(STORAGE_CELLS_TIER, (Object)tier.ordinal());
    }

    public int getStorageCellsExtraSlots() {
        return switch (this.getStorageCellsTier()) {
            case StorageCellsTier.BASIC -> 9;
            case StorageCellsTier.ADVANCED, StorageCellsTier.ENDER_LINK -> 18;
            default -> 0;
        };
    }

    private StorageCellsTier computeStorageCellsTierFromMainInv() {
        StorageCellsTier best = StorageCellsTier.NONE;
        for (int slot = 1; slot <= 2; ++slot) {
            ItemStack storageCellInSlot = this.mainInv.getStackInSlot(slot);
            if (storageCellInSlot.m_41619_()) continue;
            if (storageCellInSlot.m_150930_((Item)ModItems.ENDERLINK_STORAGE_CELL.get())) {
                best = StorageCellsTier.ENDER_LINK;
                continue;
            }
            if (storageCellInSlot.m_150930_((Item)ModItems.ADVANCED_STORAGE_CELL.get())) {
                if (best.ordinal() >= StorageCellsTier.ADVANCED.ordinal()) continue;
                best = StorageCellsTier.ADVANCED;
                continue;
            }
            if (!storageCellInSlot.m_150930_((Item)ModItems.BASIC_STORAGE_CELL.get()) || best.ordinal() >= StorageCellsTier.BASIC.ordinal()) continue;
            best = StorageCellsTier.BASIC;
        }
        return best;
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (CHASSIS_MATERIAL.equals(dataAccessor)) {
            // empty if block
        }
    }

    public int getDisplayColorRGB() {
        return (Integer)this.f_19804_.m_135370_(DISPLAY_RGB);
    }

    public void setDisplayColorRGB(int rgb) {
        this.f_19804_.m_135381_(DISPLAY_RGB, (Object)(rgb & 0xFFFFFF));
    }

    public Mood getMood() {
        int id = (Integer)this.f_19804_.m_135370_(MOOD_ID);
        Mood[] values = Mood.values();
        return values[Math.max(0, Math.min(id, values.length - 1))];
    }

    public void setMood(Mood mood) {
        this.f_19804_.m_135381_(MOOD_ID, (Object)mood.ordinal());
    }

    private void cycleMood(boolean backwards) {
        Mood[] values = Mood.values();
        int n = values.length;
        int idx = this.getMood().ordinal();
        int next = (idx + (backwards ? -1 : 1) + n) % n;
        this.setMood(values[next]);
    }

    public ResourceLocation getMoodTexture() {
        return switch (this.getMood()) {
            case Mood.HAPPY -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/happy.png");
            case Mood.ANNOYED -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/annoyed.png");
            case Mood.SLEEP -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/sleep.png");
            case Mood.CONFUSED -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/confused.png");
            case Mood.CRYING -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/crying.png");
            case Mood.EVIL -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/evil.png");
            case Mood.PLEASED -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/pleased.png");
            case Mood.SAD -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/sad.png");
            case Mood.SURPRISED -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/surprised.png");
            default -> ByteBuddyEntity.resourceLocation("textures/entity/bytebuddy/faces/neutral.png");
        };
    }

    private static ResourceLocation resourceLocation(String path) {
        return new ResourceLocation("bytebuddies", path);
    }

    public void m_7380_(CompoundTag nbtData) {
        super.m_7380_(nbtData);
        this.getOwnerUUID().ifPresent(uuid -> nbtData.m_128362_("Owner", uuid));
        nbtData.m_128405_("role", this.buddyRole.ordinal());
        if (this.dockPos != null) {
            nbtData.m_128365_("dockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.dockPos));
        }
        nbtData.m_128379_("Sleeping", this.m_5803_());
        nbtData.m_128379_("FarmingEnabled", this.farmingEnabled);
        nbtData.m_128379_("HarvestEnabled", this.harvestEnabled);
        nbtData.m_128379_("PlantEnabled", this.plantEnabled);
        nbtData.m_128379_("TillEnabled", this.tillEnabled);
        nbtData.m_128379_("MiningEnabled", this.miningEnabled);
        nbtData.m_128379_("QuarryEnabled", this.quarryEnabled);
        nbtData.m_128379_("HaulingEnabled", this.haulingEnabled);
        nbtData.m_128365_("MainInv", (Tag)this.mainInv.serializeNBT());
        nbtData.m_128405_("Energy", this.energyStorage.getEnergyStored());
        nbtData.m_128405_("ChassisMaterial", ((Integer)this.f_19804_.m_135370_(CHASSIS_MATERIAL)).intValue());
        nbtData.m_128405_("StorageTier", ((Integer)this.f_19804_.m_135370_(STORAGE_CELLS_TIER)).intValue());
        nbtData.m_128405_("AttackMode", ((Integer)this.f_19804_.m_135370_(ATTACK_MODE)).intValue());
        nbtData.m_128405_("DisplayRGB", ((Integer)this.f_19804_.m_135370_(DISPLAY_RGB)).intValue());
        int moodIdx = Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(MOOD_ID)), (int)0, (int)(Mood.values().length - 1));
        nbtData.m_128359_("Mood", Mood.values()[moodIdx].name());
    }

    public void m_7378_(@NotNull CompoundTag nbtData) {
        int ordinal;
        super.m_7378_(nbtData);
        if (nbtData.m_128403_("Owner")) {
            this.setOwnerUUID(nbtData.m_128342_("Owner"));
        } else {
            this.clearOwner();
        }
        boolean sleeping = nbtData.m_128471_("Sleeping");
        this.setSleeping(sleeping);
        this.m_21557_(sleeping);
        int roleOrdinal = Mth.m_14045_((int)nbtData.m_128451_("role"), (int)0, (int)(BuddyRole.values().length - 1));
        this.buddyRole = BuddyRole.values()[roleOrdinal];
        this.f_19804_.m_135381_(DATA_ROLE, (Object)roleOrdinal);
        this.dockPos = nbtData.m_128441_("dockPos") ? NbtUtils.m_129239_((CompoundTag)nbtData.m_128469_("dockPos")) : null;
        if (nbtData.m_128441_("FarmingEnabled")) {
            this.farmingEnabled = nbtData.m_128471_("FarmingEnabled");
        }
        if (nbtData.m_128441_("HarvestEnabled")) {
            this.harvestEnabled = nbtData.m_128471_("HarvestEnabled");
        }
        if (nbtData.m_128441_("PlantEnabled")) {
            this.plantEnabled = nbtData.m_128471_("PlantEnabled");
        }
        if (nbtData.m_128441_("TillEnabled")) {
            this.tillEnabled = nbtData.m_128471_("TillEnabled");
        }
        if (nbtData.m_128441_("MiningEnabled")) {
            this.miningEnabled = nbtData.m_128471_("MiningEnabled");
        }
        if (nbtData.m_128441_("QuarryEnabled")) {
            this.quarryEnabled = nbtData.m_128471_("QuarryEnabled");
        }
        if (nbtData.m_128441_("HaulingEnabled")) {
            this.haulingEnabled = nbtData.m_128471_("HaulingEnabled");
        }
        if (nbtData.m_128441_("MainInv")) {
            this.mainInv.deserializeNBT(nbtData.m_128469_("MainInv"));
        }
        if (nbtData.m_128441_("Energy")) {
            this.setEnergyUnsafe(nbtData.m_128451_("Energy"));
            this.setSyncedEnergy(this.energyStorage.getEnergyStored());
        }
        if (nbtData.m_128441_("ChassisMaterial")) {
            ordinal = Mth.m_14045_((int)nbtData.m_128451_("ChassisMaterial"), (int)0, (int)(ChassisMaterial.values().length - 1));
            this.f_19804_.m_135381_(CHASSIS_MATERIAL, (Object)ordinal);
        } else {
            this.f_19804_.m_135381_(CHASSIS_MATERIAL, (Object)defaultChassis.ordinal());
        }
        if (nbtData.m_128441_("StorageTier")) {
            ordinal = Mth.m_14045_((int)nbtData.m_128451_("StorageTier"), (int)0, (int)(StorageCellsTier.values().length - 1));
            this.f_19804_.m_135381_(STORAGE_CELLS_TIER, (Object)ordinal);
        } else {
            this.f_19804_.m_135381_(STORAGE_CELLS_TIER, (Object)StorageCellsTier.NONE.ordinal());
        }
        if (nbtData.m_128441_("AttackMode")) {
            ordinal = Mth.m_14045_((int)nbtData.m_128451_("AttackMode"), (int)0, (int)(AttackMode.values().length - 1));
            this.f_19804_.m_135381_(ATTACK_MODE, (Object)ordinal);
        }
        if (nbtData.m_128441_("DisplayRGB")) {
            this.f_19804_.m_135381_(DISPLAY_RGB, (Object)nbtData.m_128451_("DisplayRGB"));
        }
        int moodOrdinal = 0;
        if (nbtData.m_128441_("Mood")) {
            try {
                moodOrdinal = Mood.valueOf(nbtData.m_128461_("Mood")).ordinal();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (nbtData.m_128441_("MoodId")) {
            moodOrdinal = nbtData.m_128451_("MoodId");
        }
        this.f_19804_.m_135381_(MOOD_ID, (Object)Mth.m_14045_((int)moodOrdinal, (int)0, (int)(Mood.values().length - 1)));
        if (!this.m_9236_().f_46443_) {
            this.rebuildGoalsForRole();
            this.refreshEffects();
            this.refreshCombatGoals();
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (!this.m_9236_().f_46443_) {
            if (this.m_5803_() && !this.hasOwner()) {
                this.setOwner(player);
                player.m_5661_((Component)Component.m_237113_((String)("Buddy bound to " + player.m_7755_().getString())), true);
                this.awaken();
                return InteractionResult.CONSUME;
            }
            ItemStack inHand = player.m_21120_(interactionHand);
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            if (inHand.m_150930_(Items.f_42405_)) {
                this.setBuddyRole(BuddyRole.FARMER);
                inHand.m_41774_(1);
                this.setFarmingEnabled(true);
                this.setHarvestEnabled(true);
                this.setPlantEnabled(true);
                this.setTillEnabled(true);
                player.m_5661_((Component)Component.m_237113_((String)("Set bot role to " + this.buddyRole)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (inHand.m_150930_(Items.f_42594_)) {
                this.setBuddyRole(BuddyRole.MINER);
                inHand.m_41774_(1);
                this.setMiningEnabled(true);
                this.setQuarryEnabled(true);
                player.m_5661_((Component)Component.m_237113_((String)("Set bot role to " + this.buddyRole)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (inHand.m_150930_(Items.f_42009_)) {
                this.setBuddyRole(BuddyRole.STORAGE);
                inHand.m_41774_(1);
                this.setHaulingEnabled(true);
                player.m_5661_((Component)Component.m_237113_((String)("Set bot role to " + this.buddyRole)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (inHand.m_150930_(Items.f_42740_)) {
                this.setBuddyRole(BuddyRole.COMBAT);
                inHand.m_41774_(1);
                this.setHaulingEnabled(true);
                player.m_5661_((Component)Component.m_237113_((String)("Set bot role to " + this.buddyRole)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            Item item = inHand.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                DyeColor dye = dyeItem.m_41089_();
                int rgb = dye.m_41070_();
                this.setDisplayColorRGB(rgb);
                if (!player.m_150110_().f_35937_) {
                    inHand.m_41774_(1);
                }
                player.m_5661_((Component)Component.m_237113_((String)("Buddy color set to: " + dye.m_41065_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (inHand.m_150930_(Items.f_42398_)) {
                if (!this.m_9236_().f_46443_) {
                    boolean backwards = player.m_6144_();
                    this.cycleMood(backwards);
                    player.m_5661_((Component)Component.m_237113_((String)("Face: " + this.getMood().name())), true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (inHand.m_41720_() instanceof SwordItem) {
                if (!this.m_9236_().f_46443_) {
                    boolean backwards = player.m_6144_();
                    AttackMode next = ByteBuddyEntity.cycleAttackMode(this.getAttackMode(), backwards);
                    this.setAttackMode(next);
                    player.m_5661_((Component)Component.m_237113_((String)("Mode: " + next.name())), true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_5803_() && !this.isWaking() && mainHand.m_41619_() && offHand.m_41619_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ByteBuddyEntity.openStorageMenu(serverPlayer, this);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    public static void openStorageMenu(ServerPlayer serverPlayer, ByteBuddyEntity byteBuddy) {
        byteBuddy.refreshEffects();
        SimpleMenuProvider provider = new SimpleMenuProvider((containerId, inventory, player) -> {
            int slots = byteBuddy.getStorageCellsExtraSlots();
            if (slots == 18) {
                return new ByteBuddyTripleMenu(containerId, inventory, byteBuddy);
            }
            if (slots == 9) {
                return new ByteBuddyDoubleMenu(containerId, inventory, byteBuddy);
            }
            return new ByteBuddyMenu(containerId, inventory, byteBuddy);
        }, (Component)Component.m_237113_((String)"ByteBuddy"));
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buf -> buf.writeInt(byteBuddy.m_19879_()));
    }

    public void onMenuOpened(Player player) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        ++this.openGuiCount;
        this.currentViewerId = player.m_20148_();
    }

    public void onMenuClosed(Player player) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        this.openGuiCount = Math.max(0, this.openGuiCount - 1);
        if (this.openGuiCount == 0) {
            this.currentViewerId = null;
        }
    }

    public boolean isInteracting() {
        return this.openGuiCount > 0;
    }

    @Nullable
    public Player getCurrentViewer() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.currentViewerId == null) {
            return null;
        }
        return serverLevel.m_46003_(this.currentViewerId);
    }

    public void awaken() {
        if (!this.m_9236_().f_46443_ && this.m_5803_()) {
            this.setSleeping(false);
            this.m_21557_(false);
            this.setWaking(true);
        }
    }

    public ItemStackHandler getMainInv() {
        return this.mainInv;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.m_14045_((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBuddyRole(BuddyRole newRole) {
        if (newRole == null) {
            return;
        }
        this.buddyRole = newRole;
        this.f_19804_.m_135381_(DATA_ROLE, (Object)newRole.getId());
        this.reloadBuddy();
    }

    public BuddyRole getBuddyRole() {
        return BuddyRole.byId((Integer)this.f_19804_.m_135370_(DATA_ROLE));
    }

    public void setBuddyRoleById(int id) {
        this.setBuddyRole(BuddyRole.byId(id));
    }

    public Optional<BlockPos> getDock() {
        return Optional.ofNullable(this.dockPos);
    }

    public void setDock(BlockPos blockPos) {
        this.dockPos = blockPos.m_7949_();
        if (!this.m_9236_().f_46443_) {
            BotDebug.log(this, "[ByteBuddies] bot id=" + this.m_19879_() + "dock set to " + blockPos);
        }
    }

    public void clearDock() {
        this.dockPos = null;
    }

    public void refreshEffects() {
        this.diskEffects.recomputeFrom(this.mainInv);
        FloppyDiskItem.DiskHooks.applyDiskHealthBoost(this, this.diskEffects.healthBoostPercent());
        this.augmentEffects.recomputeFrom(this.mainInv, this);
        StorageCellsTier tierBefore = this.getStorageCellsTier();
        StorageCellsTier tierAfter = this.computeStorageCellsTierFromMainInv();
        if (!this.m_9236_().f_46443_ && tierBefore != tierAfter) {
            this.setStorageCellsTier(tierAfter);
            this.enforceStorageCapacity();
        }
    }

    private void enforceStorageCapacity() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ItemStack leftover;
            ItemStack stackInSlot;
            int slot;
            ServerLevel serverLevel = (ServerLevel)level;
            int extraSlots = this.getStorageCellsExtraSlots();
            int coreStart = 9;
            int coreEnd = 17;
            int firstUpgradeStart = 18;
            int firstUpgradeEnd = 26;
            int secondUpgradeStart = 27;
            int secondUpgradeEnd = 35;
            RangeItemHandler coreDestination = new RangeItemHandler(this.mainInv, 9, 17);
            RangeItemHandler firstUpgradeDestination = extraSlots >= 9 ? new RangeItemHandler(this.mainInv, 18, 26) : null;
            RangeItemHandler secondUpgradeDestination = extraSlots >= 18 ? new RangeItemHandler(this.mainInv, 27, 35) : null;
            Function<ItemStack, ItemStack> tryInsert = itemStack -> {
                if (itemStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                ItemStack leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)coreDestination, (ItemStack)itemStack, (boolean)false);
                if (leftoverItems.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (firstUpgradeDestination != null && (leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)firstUpgradeDestination, (ItemStack)leftoverItems, (boolean)false)).m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (secondUpgradeDestination != null) {
                    leftoverItems = ItemHandlerHelper.insertItemStacked((IItemHandler)secondUpgradeDestination, (ItemStack)leftoverItems, (boolean)false);
                }
                return leftoverItems;
            };
            if (extraSlots < 18) {
                for (slot = 27; slot <= 35; ++slot) {
                    stackInSlot = this.mainInv.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    this.mainInv.setStackInSlot(slot, ItemStack.f_41583_);
                    leftover = tryInsert.apply(stackInSlot.m_41777_());
                    if (leftover.m_41619_()) continue;
                    Containers.m_18992_((Level)serverLevel, (double)(this.m_20185_() + 0.5), (double)(this.m_20186_() + 0.75), (double)(this.m_20189_() + 0.5), (ItemStack)leftover);
                }
            }
            if (extraSlots < 9) {
                for (slot = 18; slot <= 26; ++slot) {
                    stackInSlot = this.mainInv.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    this.mainInv.setStackInSlot(slot, ItemStack.f_41583_);
                    leftover = tryInsert.apply(stackInSlot.m_41777_());
                    if (leftover.m_41619_()) continue;
                    Containers.m_18992_((Level)serverLevel, (double)(this.m_20185_() + 0.5), (double)(this.m_20186_() + 0.75), (double)(this.m_20189_() + 0.5), (ItemStack)leftover);
                }
            }
        }
    }

    public boolean m_5825_() {
        return this.augmentEffects.fireResistant();
    }

    public ItemStack getClipboardStack() {
        return this.mainInv.getStackInSlot(8);
    }

    @Nullable
    public BlockPos getFirstPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getFirstPosition(clipboard).orElse(null);
    }

    @Nullable
    public BlockPos getSecondPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getSecondPosition(clipboard).orElse(null);
    }

    public int effectiveRadius() {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return 0;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.m_9236_().m_7702_(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            return (int)Math.ceil((float)dockBlock.dockBaseRadius * this.diskEffects.radiusMultiplier());
        }
        return 0;
    }

    public float actionSpeedMultiplier() {
        return this.diskEffects.actionSpeedMultiplier();
    }

    public float energyCostMultiplier() {
        return this.diskEffects.energyCostMultiplier();
    }

    public float toolWearMultiplier() {
        return this.diskEffects.toolWearMultiplier();
    }

    public float yieldBonusChance() {
        return this.diskEffects.yieldPrimaryChance();
    }

    public float byproductChance() {
        return this.diskEffects.secondaryByproductChance();
    }

    public boolean supportAuraEnabled() {
        return this.diskEffects.supportAuraEnabled();
    }

    public boolean hologramEnabled() {
        return this.diskEffects.hologramEnabled();
    }

    public float hologramChance() {
        return this.diskEffects.hologramChance();
    }

    public boolean consumeEnergy(int energyCost) {
        int adjustedEnergyCost = Math.max(1, Math.round((float)energyCost * this.energyCostMultiplier()));
        if (this.energyStorage.getEnergyStored() >= adjustedEnergyCost) {
            this.energyStorage.extractEnergy(adjustedEnergyCost, false);
            return true;
        }
        return false;
    }

    private void rebuildGoalsForRole() {
        for (Goal goals : this.roleGoals) {
            this.f_21345_.m_25363_(goals);
        }
        this.roleGoals.clear();
        switch (this.getBuddyRole()) {
            case FARMER: {
                this.enableFarming();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isPlantEnabled(), new PlantGoal(this), this.scaledCooldownTicks()));
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isHarvestEnabled(), new HarvestGoal(this), this.scaledCooldownTicks()));
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isTillEnabled(), new TillGoal(this), this.scaledCooldownTicks()));
                break;
            }
            case MINER: {
                this.enableMining();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isQuarryEnabled(), new QuarryGoal(this), this.scaledCooldownTicks()));
                break;
            }
            case COMBAT: {
                break;
            }
            case POTION: {
                break;
            }
            case STORAGE: {
                this.enabledStorage();
                this.roleGoals.add(new GatedGoal(this, () -> this.canAct() && this.isHaulingEnabled(), new HaulerGoal(this), this.scaledCooldownTicks()));
                break;
            }
        }
        int priority = 2;
        for (Goal goals : this.roleGoals) {
            this.f_21345_.m_25352_(priority++, goals);
        }
    }

    private void disableTasks() {
        this.setFarmingEnabled(false);
        this.setHarvestEnabled(false);
        this.setPlantEnabled(false);
        this.setTillEnabled(false);
        this.setMiningEnabled(false);
        this.setQuarryEnabled(false);
        this.setHaulingEnabled(false);
    }

    private void enableFarming() {
        this.setFarmingEnabled(true);
        this.setHarvestEnabled(true);
        this.setPlantEnabled(true);
        this.setTillEnabled(true);
    }

    private void enableMining() {
        this.setMiningEnabled(true);
        this.setQuarryEnabled(true);
    }

    private void enabledStorage() {
        this.setHaulingEnabled(true);
    }

    public void requestImmediatePlant(BlockPos pos, BlockState state, Item seed) {
        this.pendingPlantRequest = new PlantRequest(pos, state, seed);
    }

    @Nullable
    public PlantRequest pollPlantRequest() {
        PlantRequest plantRequest = this.pendingPlantRequest;
        this.pendingPlantRequest = null;
        return plantRequest;
    }

    public void holdHarvestForReplant(ServerLevel serverLevel, int ticks) {
        this.replantHoldUntil = serverLevel.m_46467_() + (long)Math.max(1, ticks);
    }

    public boolean harvestOnHold(ServerLevel serverLevel) {
        return serverLevel.m_46467_() < this.replantHoldUntil;
    }

    private static List<BlockPos> pathBlockPositions(Path path, int from, int to) {
        int start = Math.max(0, from);
        int end = Math.min(path.m_77398_(), to);
        ArrayList<BlockPos> out = new ArrayList<BlockPos>(Math.max(0, end - start));
        for (int i = start; i < end; ++i) {
            out.add(path.m_77396_(i));
        }
        return out;
    }

    private static List<BlockPos> pathAhead(Path path, int lookAhead) {
        int start = Math.min(path.m_77399_(), path.m_77398_());
        int end = Math.min(start + Math.max(0, lookAhead), path.m_77398_());
        return ByteBuddyEntity.pathBlockPositions(path, start, end);
    }

    public static void reservePathAhead(ByteBuddyEntity byteBuddy, ServerLevel serverLevel, Path path, int lookAhead) {
        Optional<BlockPos> dockOpt = byteBuddy.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = serverLevel.m_7702_(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (BlockPos node : ByteBuddyEntity.pathAhead(path, lookAhead)) {
                dockBlock.tryClaim(serverLevel, TaskType.MOVE, node, byteBuddy.m_20148_(), 20);
            }
        }
    }

    public void renewPathAhead(ServerLevel serverLevel, Path path, int lookAhead) {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.m_9236_().m_7702_(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (BlockPos node : ByteBuddyEntity.pathAhead(path, lookAhead)) {
                dockBlock.renewClaim(serverLevel, TaskType.MOVE, node, this.m_20148_(), 20);
            }
        }
    }

    public void releasePath(Path path) {
        Optional<BlockPos> dockOpt = this.getDock();
        if (dockOpt.isEmpty()) {
            return;
        }
        BlockPos dockPos = dockOpt.get();
        BlockEntity blockEntity = this.m_9236_().m_7702_(dockPos);
        if (blockEntity instanceof DockingStationBlockEntity) {
            DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
            for (int i = 0; i < path.m_77398_(); ++i) {
                dockBlock.releaseClaim(TaskType.MOVE, path.m_77396_(i), this.m_20148_());
            }
        }
    }

    public static boolean isStandableTerrain(Level level, BlockPos blockPos) {
        if (!level.m_46749_(blockPos)) {
            return false;
        }
        BlockState below = level.m_8055_(blockPos.m_7495_());
        boolean solidFloor = !below.m_60812_((BlockGetter)level, blockPos.m_7495_()).m_83281_();
        BlockState feet = level.m_8055_(blockPos);
        boolean feetFree = feet.m_60812_((BlockGetter)level, blockPos).m_83281_();
        BlockState head = level.m_8055_(blockPos.m_7494_());
        boolean headFree = head.m_60812_((BlockGetter)level, blockPos.m_7494_()).m_83281_();
        boolean noLiquid = level.m_6425_(blockPos).m_76178_() && level.m_6425_(blockPos.m_7494_()).m_76178_();
        return solidFloor && feetFree && headFree && noLiquid;
    }

    public static boolean isStandableForMove(ByteBuddyEntity byteBuddy, Level level, BlockPos blockPos) {
        if (!ByteBuddyEntity.isStandableTerrain(level, blockPos)) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos dockPos = byteBuddy.getDock().orElse(null);
        if (dockPos == null) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(dockPos);
        if (!(blockEntity instanceof DockingStationBlockEntity)) {
            return true;
        }
        DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
        boolean reserved = dockBlock.isReserved(serverLevel, TaskType.MOVE, blockPos);
        if (!reserved) {
            return true;
        }
        return dockBlock.isReservedBy(serverLevel, TaskType.MOVE, blockPos, byteBuddy.m_20148_());
    }

    public static boolean isAnyTool(ItemStack stack) {
        for (ToolUtil.ToolType toolType : ToolUtil.ToolType.values()) {
            if (toolType == ToolUtil.ToolType.EMPTY_HAND || !ToolUtil.matchesToolType(stack, toolType)) continue;
            return true;
        }
        return false;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public void setSyncedEnergy(int value) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_ENERGY, (Object)Math.max(0, value));
        }
    }

    public int getSyncedEnergy() {
        return (Integer)this.f_19804_.m_135370_(DATA_ENERGY);
    }

    private void onEnergyChanged() {
        if (!this.m_9236_().f_46443_) {
            this.setSyncedEnergy(this.energyStorage.getEnergyStored());
        }
    }

    private void tickAugmentRuntime() {
        if (this.augmentEffects.solarEnabled() && this.m_9236_().m_46461_() && this.m_9236_().m_45527_(this.m_20183_())) {
            this.getEnergyStorage().receiveEnergy((int)Math.round(this.augmentEffects.solarChargePerSecond()), false);
        }
        if (this.augmentEffects.geothermalEnabled() && this.isNearHeatSource()) {
            this.getEnergyStorage().receiveEnergy((int)Math.round(this.augmentEffects.geothermalChargePerSecond()), false);
        }
        if (this.augmentEffects.arcWelderEnabled() && this.m_21223_() < this.m_21233_() && this.getEnergyStorage().extractEnergy(5, true) > 0) {
            this.getEnergyStorage().extractEnergy(5, false);
            this.m_5634_((float)this.augmentEffects.selfRepairPerSecond());
        }
    }

    private void tickPropellerPhysics() {
        if (this.canFly()) {
            boolean isOnGround = this.m_20096_();
            boolean isInWater = this.m_20069_();
            boolean isInLava = this.m_20077_();
            if (!(isOnGround || isInWater || isInLava)) {
                Vec3 currentDelta = this.m_20184_();
                if (currentDelta.f_82480_ < 0.0) {
                    double newY = currentDelta.f_82480_ * 0.6;
                    if (newY < -0.12) {
                        newY = -0.12;
                    }
                    double newX = currentDelta.f_82479_ * 0.98;
                    double newZ = currentDelta.f_82481_ * 0.98;
                    this.m_20334_(newX, newY, newZ);
                    this.f_19812_ = true;
                }
            }
        }
    }

    private boolean isNearHeatSource() {
        BlockPos origin = this.m_20183_();
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos blockPos = origin.m_7918_(dx, dy, dz);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_60713_(Blocks.f_49991_) || blockState.m_60713_(Blocks.f_152477_) || blockState.m_60713_(Blocks.f_50450_)) {
                        return true;
                    }
                    if (blockState.m_60734_() instanceof AbstractFurnaceBlock && ((Boolean)blockState.m_61143_((Property)AbstractFurnaceBlock.f_48684_)).booleanValue()) {
                        return true;
                    }
                    if (!(blockState.m_60734_() instanceof CampfireBlock) || !((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void tickDynamoMovement() {
        if (!this.augmentEffects.dynamoEnabled()) {
            return;
        }
        double dx = this.m_20185_() - this.augmentPrevX;
        double dy = this.m_20186_() - this.augmentPrevY;
        double dz = this.m_20189_() - this.augmentPrevZ;
        this.augmentPrevX = this.m_20185_();
        this.augmentPrevY = this.m_20186_();
        this.augmentPrevZ = this.m_20189_();
        double moved = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.augmentMoveAccumMeters += moved;
        if (this.augmentMoveAccumMeters >= 1.0) {
            int meters = (int)Math.floor(this.augmentMoveAccumMeters);
            this.augmentMoveAccumMeters -= (double)meters;
            int charge = (int)Math.round(this.augmentEffects.dynamoChargePerMeter() * (double)meters);
            if (charge > 0) {
                this.getEnergyStorage().receiveEnergy(charge, false);
            }
        }
    }

    public void addDynamoEffect() {
        if (this.augmentEffects.dynamoEnabled()) {
            this.addMomentum(this.augmentEffects.momentumTicks(), this.augmentEffects.momentumSpeedMultiplier());
        }
    }

    private void addMomentum(int ticks, double speedMultiplier) {
        if (ticks <= 0) {
            return;
        }
        if (Math.abs(speedMultiplier - 1.0) <= 1.0E-4) {
            return;
        }
        CoreAttributeModifiers.applyTransientModifier((LivingEntity)this, (Attribute)Attributes.f_22279_, (String)"dynamo_momentum", (double)(speedMultiplier - 1.0), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.getPersistentData().m_128405_(momentumUntil, this.f_19797_ + ticks);
    }

    private void tickMomentumExpiry() {
        int until = this.getPersistentData().m_128451_(momentumUntil);
        if (until > 0 && this.f_19797_ >= until) {
            CoreAttributeModifiers.removeModifier((LivingEntity)this, (Attribute)Attributes.f_22279_, (String)"dynamo_momentum");
            this.getPersistentData().m_128473_(momentumUntil);
        }
    }

    private void tickMagnet() {
        if (!this.augmentEffects.magnetEnabled()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        double radius = this.augmentEffects.magnetRadiusBlocks();
        if (radius <= 0.0) {
            return;
        }
        AABB boundingBox = new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius);
        List items = this.m_9236_().m_45976_(ItemEntity.class, boundingBox);
        for (ItemEntity item : items) {
            Vec3 toBuddy;
            double distance;
            if (!item.m_6084_() || (distance = (toBuddy = new Vec3(this.m_20185_() - item.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f) - item.m_20186_(), this.m_20189_() - item.m_20189_())).m_82553_()) < 0.01) continue;
            if (distance <= 0.9) {
                this.pickupItem(item);
            }
            double pullFactor = Mth.m_14008_((double)((radius - distance) / radius), (double)0.08, (double)0.9);
            double accel = 0.1 * pullFactor;
            Vec3 push = toBuddy.m_82541_().m_82490_(accel);
            Vec3 newVelocity = item.m_20184_().m_82549_(push);
            double maxSpeed = 0.35;
            double lenSq = newVelocity.m_82556_();
            if (lenSq > maxSpeed * maxSpeed) {
                newVelocity = newVelocity.m_82541_().m_82490_(maxSpeed);
            }
            item.m_20256_(newVelocity);
            item.f_19812_ = true;
        }
    }

    private void pickupItem(ItemEntity itemEntity) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = itemEntity.m_32055_();
        int before = stack.m_41613_();
        ItemStack leftover = InventoryUtil.mergeInto(this.getMainInv(), stack);
        int taken = before - leftover.m_41613_();
        if (taken <= 0) {
            return;
        }
        serverLevel.m_7726_().m_8394_((Entity)this, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.m_19879_(), this.m_19879_(), taken));
        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.4f);
        if (leftover.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(leftover);
        }
    }

    public void onMeleeHit(LivingEntity victim) {
        if (this.augmentEffects.shockOnHit()) {
            victim.m_6469_(this.m_269291_().m_269264_(), 2.0f);
            victim.m_147240_(0.4, this.m_20185_() - victim.m_20185_(), this.m_20189_() - victim.m_20189_());
        }
    }

    public float rangedInaccuracyMultiplier() {
        if (this.augmentEffects.gyroEnabled()) {
            return 0.8f;
        }
        return 1.0f;
    }

    public boolean canFly() {
        return this.augmentEffects.propellerEnabled();
    }

    public boolean canSwim() {
        return this.augmentEffects.aquaEnabled();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean augmentEnderLinkEnabled() {
        return this.augmentEffects.enderLinkEnabled();
    }

    public AugmentItem.AugmentEffects getAugmentEffects() {
        return this.augmentEffects;
    }

    public int scaledCooldownTicks() {
        float speedMultiplier = Math.max(0.25f, this.actionSpeedMultiplier());
        return Math.max(4, Math.round(20.0f / speedMultiplier));
    }

    public void refreshCombatGoals() {
        if (this.followOwnerGoal != null) {
            this.f_21345_.m_25363_(this.followOwnerGoal);
        }
        if (this.ownerHurtBY != null) {
            this.f_21346_.m_25363_(this.ownerHurtBY);
        }
        if (this.ownerHurt != null) {
            this.f_21346_.m_25363_(this.ownerHurt);
        }
        if (this.hurtAnythingHostile != null) {
            this.f_21346_.m_25363_(this.hurtAnythingHostile);
        }
        if (this.meleeAttackGoal != null) {
            this.f_21345_.m_25363_(this.meleeAttackGoal);
        }
        if (this.hurtByTargetGoal != null) {
            this.f_21346_.m_25363_(this.hurtByTargetGoal);
        }
        boolean ableToFight = this.getBuddyRole() == BuddyRole.COMBAT;
        boolean hasOwner = this.getOwnerUUID().isPresent();
        boolean hasDock = this.getDock().isPresent();
        if (!ableToFight || !hasOwner || hasDock) {
            return;
        }
        this.followOwnerGoal = new BuddyFollowOwnerGoal(this, 1.05, 4.0f, 16.0f, true);
        this.f_21345_.m_25352_(4, this.followOwnerGoal);
        this.meleeAttackGoal = new BuddyMeleeAttackGoal(this, 1.2, 2.0, true);
        this.f_21345_.m_25352_(3, this.meleeAttackGoal);
        this.hurtByTargetGoal = new BuddyHurtByTargetGoal(this);
        this.f_21346_.m_25352_(0, this.hurtByTargetGoal);
        switch (this.getAttackMode()) {
            case PASSIVE: {
                break;
            }
            case ASSIST: {
                this.ownerHurtBY = new BuddyOwnerHurtByTargetGoal(this);
                this.ownerHurt = new BuddyOwnerHurtTargetGoal(this);
                this.f_21346_.m_25352_(1, this.ownerHurtBY);
                this.f_21346_.m_25352_(2, this.ownerHurt);
                break;
            }
            case AGGRESSIVE: {
                this.hurtAnythingHostile = new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, false, this::isValidAggressiveTarget);
                this.f_21346_.m_25352_(1, this.hurtAnythingHostile);
            }
        }
    }

    private boolean isValidAggressiveTarget(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.getOwnerUUID().map(player.m_20148_()::equals).orElse(false).booleanValue()) {
                return false;
            }
            return !player.m_7500_() && !player.m_5833_();
        }
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public static enum BuddyRole {
        NONE(0),
        FARMER(1),
        MINER(2),
        COMBAT(3),
        POTION(4),
        STORAGE(5),
        ANIMAL(6);

        private final int id;
        private static final IntFunction<BuddyRole> BY_ID;

        private BuddyRole(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static BuddyRole byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.m_262839_(BuddyRole::getId, (Object[])BuddyRole.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static enum ChassisMaterial {
        ALUMINUM,
        IRON,
        STEEL,
        NETHERITE,
        CHARGED_STEEL;

    }

    public static enum StorageCellsTier {
        NONE,
        BASIC,
        ADVANCED,
        ENDER_LINK;

    }

    public static enum Mood {
        NEUTRAL,
        HAPPY,
        ANNOYED,
        SLEEP,
        CONFUSED,
        CRYING,
        EVIL,
        PLEASED,
        SAD,
        SURPRISED;

    }

    public static enum AttackMode {
        PASSIVE,
        ASSIST,
        AGGRESSIVE;

    }

    private static final class GatedGoal
    extends Goal {
        private final ByteBuddyEntity byteBuddy;
        private final BooleanSupplier requirement;
        private final Goal lockedGoal;
        private final int cooldownTicks;

        GatedGoal(ByteBuddyEntity byteBuddy, BooleanSupplier requirement, Goal lockedGoal, int cooldownTicks) {
            this.byteBuddy = byteBuddy;
            this.requirement = requirement;
            this.lockedGoal = lockedGoal;
            this.cooldownTicks = cooldownTicks;
            this.m_7021_(lockedGoal.m_7684_());
        }

        public boolean m_8036_() {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct()) {
                    return false;
                }
                if (!this.requirement.getAsBoolean()) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.m_19879_() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": requirement = false");
                    return false;
                }
                if (this.byteBuddy.cooldownActive(serverLevel)) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.m_19879_() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": cooldown active");
                    return false;
                }
                boolean canUse = this.lockedGoal.m_8036_();
                if (!canUse) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.m_19879_() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": inner canUse = false");
                }
                return canUse;
            }
            return false;
        }

        public boolean m_8045_() {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct()) {
                    return false;
                }
                if (!this.requirement.getAsBoolean()) {
                    return false;
                }
                if (this.byteBuddy.cooldownActive(serverLevel)) {
                    return false;
                }
                boolean continueToUse = this.lockedGoal.m_8045_();
                if (!continueToUse) {
                    BotDebug.log(this.byteBuddy, "[ByteBuddy: " + this.byteBuddy.m_19879_() + "] GatedGoal " + this.lockedGoal.getClass().getSimpleName() + ": canContinueToUse = false");
                }
                return continueToUse;
            }
            return false;
        }

        public void m_8056_() {
            this.lockedGoal.m_8056_();
        }

        public void m_8037_() {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.byteBuddy.canAct() || this.byteBuddy.cooldownActive(serverLevel) || !this.requirement.getAsBoolean()) {
                    this.lockedGoal.m_8041_();
                    return;
                }
                this.lockedGoal.m_8037_();
            }
        }

        public void m_8041_() {
            this.lockedGoal.m_8041_();
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.byteBuddy.armCooldown(serverLevel, this.cooldownTicks);
            }
        }

        public boolean m_6767_() {
            return this.lockedGoal.m_6767_();
        }
    }

    public static final class SupportAuras {
        public static void tickSupportLattice(ByteBuddyEntity byteBuddy) {
            Level level = byteBuddy.m_9236_();
            BlockPos buddyPos = byteBuddy.m_20183_();
            int radius = 5;
            if (level.f_46441_.m_188501_() < 0.1f) {
                BlockPos.m_121990_((BlockPos)buddyPos.m_7918_(-radius, -1, -radius), (BlockPos)buddyPos.m_7918_(radius, 2, radius)).limit(24L).forEach(blockPos -> {
                    CropBlock cropBlock;
                    BlockState blockState = level.m_8055_(blockPos);
                    Block patt76171$temp = blockState.m_60734_();
                    if (patt76171$temp instanceof CropBlock && !(cropBlock = (CropBlock)patt76171$temp).m_52307_(blockState) && level.f_46441_.m_188501_() < 0.05f) {
                        level.m_7731_(blockPos, cropBlock.m_52289_(cropBlock.m_52305_(blockState) + 1), 3);
                    }
                });
            }
            List players = level.m_45976_(Player.class, new AABB(buddyPos).m_82400_(5.0));
            for (Player player : players) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 0, true, false));
            }
            List byteBuddies = level.m_45976_(ByteBuddyEntity.class, new AABB(buddyPos).m_82400_(5.0));
            for (ByteBuddyEntity buddyEntity : byteBuddies) {
                buddyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 0, true, false));
            }
        }
    }

    public static enum TaskType {
        HARVEST,
        FORESTRY,
        PLANT,
        TILL,
        MOVE,
        HAUL,
        MINE,
        COMBAT,
        BREW,
        DISTRIBUTE_POTION,
        SORT,
        PICKUP,
        DEPOSIT,
        SHEAR,
        MILK,
        BREED,
        WRANGLE,
        NONE;

    }

    private static final class RangeItemHandler
    implements IItemHandler {
        private final ItemStackHandler itemStackHandler;
        private final int startSlot;
        private final int endSlot;

        RangeItemHandler(ItemStackHandler itemStackHandler, int startSlot, int end) {
            this.itemStackHandler = itemStackHandler;
            this.startSlot = startSlot;
            this.endSlot = end;
        }

        public int getSlots() {
            return this.endSlot - this.startSlot + 1;
        }

        private int map(int slot) {
            return this.startSlot + slot;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                return ItemStack.f_41583_;
            }
            return this.itemStackHandler.getStackInSlot(this.map(slot));
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack itemStack, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots()) {
                return itemStack;
            }
            return this.itemStackHandler.insertItem(this.map(slot), itemStack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots()) {
                return ItemStack.f_41583_;
            }
            return this.itemStackHandler.extractItem(this.map(slot), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                return 0;
            }
            return this.itemStackHandler.getSlotLimit(this.map(slot));
        }

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            if (slot < 0 || slot >= this.getSlots()) {
                return false;
            }
            return this.itemStackHandler.isItemValid(this.map(slot), itemStack);
        }
    }

    public static final class PlantRequest {
        public final BlockPos blockPos;
        public final BlockState blockState;
        public final Item seedItem;

        public PlantRequest(BlockPos blockPos, BlockState blockState, Item seedItem) {
            this.blockPos = blockPos;
            this.blockState = blockState;
            this.seedItem = seedItem;
        }
    }
}

