/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.miner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class QuarryGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private int targetReselectRetries = 0;
    private static final int seekingTimout = 20;
    private static final int movingTimeout = 300;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.5;
    private static final double finalApproachDist = 1.5;
    private static final double microDistMin = 0.08;
    private static final double microDistMax = 0.18;
    @Nullable
    private BlockPos claimedMinePos = null;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private static final int claimTimeout = 120;
    private long nextClaimRenewMine = 0L;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;
    private static final int mineEnergyCost = 30;

    public QuarryGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.m_21441_(BlockPathTypes.WATER, 8.0f);
        byteBuddy.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
    }

    public boolean m_8036_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos != null) {
            return true;
        }
        if (this.byteBuddy.getBuddyRole() != ByteBuddyEntity.BuddyRole.MINER) {
            this.failTask(BotDebug.FailReason.WRONG_ROLE, "role=" + this.byteBuddy.getBuddyRole());
            return false;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            this.failTask(BotDebug.FailReason.NO_DOCK, "no station bound");
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.PICKAXE, 30, 1)) {
            return false;
        }
        Optional<MinePlan> plan = this.findMinePlan();
        if (plan.isEmpty()) {
            return false;
        }
        this.targetPos = plan.get().breakPos();
        this.approachPos = plan.get().standPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "to mine " + this.targetPos.m_123344_());
        return true;
    }

    public boolean m_8045_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.PICKAXE, 30, 1);
    }

    public void m_8041_() {
        this.clearTimedAnimation();
        this.releaseMineClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.m_8041_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            boolean withinReach;
            PathNavigation pathNavigation;
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickTimedAnimation();
            if (this.targetPos == null || this.approachPos == null) {
                return;
            }
            GoalUtil.renewClaimIfNeeded(this.byteBuddy, serverLevel, ByteBuddyEntity.TaskType.MINE, this.claimedMinePos, this.targetPos, serverLevel.m_46467_(), 5, 120, () -> this.nextClaimRenewMine, t -> {
                this.nextClaimRenewMine = t;
            });
            BlockState targetState = this.byteBuddy.m_9236_().m_8055_(this.targetPos);
            if (this.currentPhase != BotDebug.GoalPhase.ACTING && !GoalUtil.canMineAt(this.byteBuddy.m_9236_(), this.targetPos)) {
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "target invalid");
                return;
            }
            Vec3 targetCenter = this.targetPos.m_252807_();
            this.navigatePhases(serverLevel);
            if (this.targetAnchor != null) {
                double distToTarget = this.byteBuddy.m_20182_().m_82554_(this.targetAnchor);
                if (distToTarget > 1.5) {
                    PathNavigation pathNavigation2 = this.byteBuddy.m_21573_();
                    if (pathNavigation2 instanceof GroundPathNavigation) {
                        boolean needsNewPath;
                        GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                        Path currentPath = pathNavigation3.m_26570_();
                        boolean bl = needsNewPath = currentPath == null || currentPath.m_77392_() || this.approachPos == null || !currentPath.m_77406_().equals((Object)this.approachPos);
                        if (needsNewPath) {
                            Path path;
                            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                            Path path2 = path = this.approachPos != null ? pathNavigation3.m_7864_(this.approachPos, 0) : null;
                            if (path != null) {
                                pathNavigation3.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
                                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                            } else {
                                this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                            }
                        }
                    } else {
                        this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                    }
                    return;
                }
                if (!this.edgeAnchored) {
                    GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                    if (distToTarget <= 0.08) {
                        GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                        this.edgeAnchored = true;
                        this.markProgress();
                        BotDebug.log(this.byteBuddy, "HARVEST: locked anchor");
                    } else {
                        this.byteBuddy.m_21573_().m_26573_();
                        this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                        if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                            this.lastAnchorDistSq = distToTarget;
                            this.markProgress();
                        }
                        BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.m_123344_()));
                    }
                } else {
                    double distSq = Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.m_20182_(), this.targetAnchor));
                    if (distSq > 0.18) {
                        this.edgeAnchored = false;
                    }
                }
            } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.m_21573_()) instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                Path path = pathNavigation4.m_7864_(this.approachPos, 0);
                pathNavigation4.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                return;
            }
            Vec3 buddyPos = this.byteBuddy.m_20182_();
            boolean bl = withinReach = GoalUtil.hDistSq(buddyPos, targetCenter) <= 0.9025 && Math.abs(buddyPos.f_82480_ - targetCenter.f_82480_) <= 1.5;
            if (withinReach) {
                if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                    this.byteBuddy.m_21563_().m_24950_(targetCenter.f_82479_, (double)this.targetPos.m_123342_(), targetCenter.f_82481_, 15.0f, 15.0f);
                } else {
                    if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                        return;
                    }
                    if (!this.verifyClaimOrAbort(serverLevel, ByteBuddyEntity.TaskType.MINE, this.claimedMinePos, this.targetPos)) {
                        return;
                    }
                    this.firePos = this.targetPos;
                    this.firePreState = targetState;
                    int totalTicks = GoalUtil.toTicks(2.0);
                    int startTicks = GoalUtil.toTicks(0.4);
                    this.startTimedAnimation(totalTicks, startTicks, this.targetPos, targetState);
                    BotDebug.log(this.byteBuddy, "MINE schedule: now=" + serverLevel.m_46467_() + " start=" + (serverLevel.m_46467_() + (long)startTicks) + " end=" + (serverLevel.m_46467_() + (long)totalTicks) + " firePos=" + this.firePos + " pre=" + targetState.m_60734_().m_49954_().getString());
                    return;
                }
            }
            if (this.targetAnchor != null && !this.edgeAnchored) {
                this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
            }
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
            case SEEKING: {
                this.handleSeeking();
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(30)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled, rescan");
            }
            return;
        }
        if (this.timedOut(300)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout, rescan");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.m_20182_(), this.targetAnchor)) <= 1.5;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.m_252807_();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.m_20182_(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
        Path path = pathNavigation2.m_26570_();
        if (path == null) {
            return;
        }
        if (serverLevel.m_46467_() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort act");
        }
    }

    private void handleSeeking() {
        if (!this.timedOut(20)) {
            return;
        }
        if (this.anchorRotateRetries++ < 2) {
            Optional<MinePlan> plan = this.findMinePlan();
            if (plan.isPresent()) {
                this.targetPos = plan.get().breakPos();
                this.approachPos = plan.get().standPos();
                this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
                this.resetProgress();
                this.enterPhase(BotDebug.GoalPhase.MOVING, "retry seek -> moving");
            } else {
                this.enterPhase(BotDebug.GoalPhase.IDLE, "seek exhausted");
            }
        } else {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout");
        }
    }

    private Optional<MinePlan> findMinePlan() {
        BlockPos dock = this.byteBuddy.getDock().orElse(null);
        if (dock == null) {
            return Optional.empty();
        }
        Level level = this.byteBuddy.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return Optional.empty();
        }
        ItemStack clipboard = dockBlock.getClipboardStack();
        boolean hasRegion = ClipboardItem.getRegion(clipboard).isPresent();
        BlockPos firstPos = hasRegion ? (BlockPos)ClipboardItem.getFirstPosition(clipboard).orElse(null) : null;
        BlockPos secondPos = hasRegion ? (BlockPos)ClipboardItem.getSecondPosition(clipboard).orElse(null) : null;
        ScanBox box = firstPos != null && secondPos != null ? this.makeRegionBox(serverLevel, firstPos, secondPos) : this.makeBehindDockBox(serverLevel, dock, this.byteBuddy.effectiveRadius(), dockBlock);
        ArrayList<MinePlan> candidates = new ArrayList<MinePlan>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int y = box.yMax; y >= box.yMin; --y) {
            if (box.mode == ScanMode.REGION) {
                for (int x = box.xMin; x <= box.xMax; ++x) {
                    for (int z = box.zMin; z <= box.zMax; ++z) {
                        this.tryAddCandidate(level, serverLevel, dockBlock, dock, y, x, z, cursor, candidates);
                    }
                }
            } else {
                int half = box.bandHalfWidth;
                BlockPos origin = box.origin;
                Direction back = box.backDir;
                Direction left = box.leftDir;
                for (int depth = 1; depth <= box.depth; ++depth) {
                    for (int side = -half; side <= half; ++side) {
                        int x = origin.m_123341_() + back.m_122429_() * depth + left.m_122429_() * side;
                        int z = origin.m_123343_() + back.m_122431_() * depth + left.m_122431_() * side;
                        this.tryAddCandidate(level, serverLevel, dockBlock, dock, y, x, z, cursor, candidates);
                    }
                }
            }
            if (!candidates.isEmpty()) break;
        }
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        candidates.sort(Comparator.comparingDouble(MinePlan::score));
        MinePlan pick = (MinePlan)candidates.get(0);
        if (!dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.MINE, pick.breakPos(), this.byteBuddy.m_20148_(), 120)) {
            return Optional.empty();
        }
        this.claimedMinePos = pick.breakPos();
        this.nextClaimRenewMine = serverLevel.m_46467_() + 5L;
        this.approachPlans = this.buildMineEdgeApproachPlans(level, pick.breakPos());
        this.anchorIndex = 0;
        this.approachPos = pick.standPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(pick.breakPos(), pick.standPos());
        this.edgeAnchored = false;
        return Optional.of(pick);
    }

    private List<Approach> buildMineEdgeApproachPlans(Level level, BlockPos blockPos) {
        ArrayList<Approach> list = new ArrayList<Approach>(8);
        BlockPos[] horizontal = new BlockPos[]{blockPos.m_122029_(), blockPos.m_122024_(), blockPos.m_122012_(), blockPos.m_122019_()};
        BlockPos[] horizontalPlusOne = new BlockPos[]{blockPos.m_122029_().m_7494_(), blockPos.m_122024_().m_7494_(), blockPos.m_122012_().m_7494_(), blockPos.m_122019_().m_7494_()};
        BlockPos[] horizontalMinusOne = new BlockPos[]{blockPos.m_122029_().m_7495_(), blockPos.m_122024_().m_7495_(), blockPos.m_122012_().m_7495_(), blockPos.m_122019_().m_7495_()};
        Consumer<BlockPos> addIfGood = standable -> {
            Path path;
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, standable)) {
                return;
            }
            Vec3 edgeAnchor = GoalUtil.getEdgeAnchor(blockPos, standable);
            if (edgeAnchor == null) {
                return;
            }
            PathNavigation pathNavigation = this.byteBuddy.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                v0 = pathNavigation2.m_7864_(standable, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) {
                return;
            }
            double horizontalDist = GoalUtil.hDistSq(this.byteBuddy.m_20182_(), edgeAnchor);
            list.add(new Approach((BlockPos)standable, edgeAnchor, horizontalDist, path));
        };
        for (BlockPos blockPositions : horizontal) {
            addIfGood.accept(blockPositions);
        }
        for (BlockPos blockPositionsPlusOne : horizontalPlusOne) {
            addIfGood.accept(blockPositionsPlusOne);
        }
        for (BlockPos blockPositionsMinusOne : horizontalMinusOne) {
            addIfGood.accept(blockPositionsMinusOne);
        }
        list.sort(Comparator.comparingDouble(Approach::distSq));
        return list;
    }

    private void performMine(BlockPos pos, BlockState pre) {
        Level level = this.byteBuddy.m_9236_();
        if (!GoalUtil.canMineAt(level, pos)) {
            BotDebug.log(this.byteBuddy, "MINE invalid at " + pos.m_123344_());
            this.releaseMineClaim();
            return;
        }
        if (!this.byteBuddy.consumeEnergy(30)) {
            this.releaseMineClaim();
            return;
        }
        ToolUtil.applyToolWear(this.byteBuddy, ToolUtil.ToolType.PICKAXE, this.byteBuddy.toolWearMultiplier());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List drops = Block.m_49874_((BlockState)pre, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)this.byteBuddy, (ItemStack)ItemStack.f_41583_);
            Vec3 c = pos.m_252807_();
            int inserted = 0;
            int dropped = 0;
            for (ItemStack stack : drops) {
                ItemStack rem = InventoryUtil.mergeInto(this.byteBuddy.getMainInv(), stack);
                if (!rem.m_41619_()) {
                    Containers.m_18992_((Level)level, (double)c.f_82479_, (double)c.f_82480_, (double)c.f_82481_, (ItemStack)rem);
                    dropped += rem.m_41613_();
                    continue;
                }
                inserted += stack.m_41613_();
            }
            level.m_46961_(pos, false);
            this.BuddyDebugLog(pos, inserted, dropped);
        }
        this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.MINE, pos);
        this.releaseMineClaim();
    }

    private void BuddyDebugLog(BlockPos pos, int inserted, int dropped) {
        BotDebug.log(this.byteBuddy, "MINE at " + pos.m_123344_() + " inserted=" + inserted + " dropped=" + dropped);
        BotDebug.mark(this.byteBuddy.m_9236_(), pos);
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = pathNavigation2.m_7864_(this.approachPos, 0)) == null) {
                return false;
            }
            pathNavigation2.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level2 = this.byteBuddy.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int approaches = this.approachPlans.size();
        for (int tries = 0; tries < approaches; ++tries) {
            ServerLevel serverLevel;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % approaches;
            Approach approachCandidates = this.approachPlans.get(this.anchorIndex);
            BlockPos standPos = approachCandidates.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.m_9236_(), standPos) || (anchor = approachCandidates.approachAnchor()) == null) continue;
            Path path = null;
            PathNavigation pathNavigation = this.byteBuddy.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                path = pathNavigation2.m_7864_(standPos, 0);
            }
            if (path == null) continue;
            this.approachPos = standPos;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            pathNavigation = this.byteBuddy.m_9236_();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.m_21573_().m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.m_9236_();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.m_21573_().m_26573_();
            Vec3 deltaMovement = this.byteBuddy.m_20184_();
            this.byteBuddy.m_20334_(deltaMovement.f_82479_ * 0.1, deltaMovement.f_82480_ * 0.1, deltaMovement.f_82481_ * 0.1);
            this.byteBuddy.setSlamming(true);
            this.actionStarted = false;
            long currentTime = serverLevel.m_46467_();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMultiplier = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMultiplier));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: MINE fire@" + startTick + " end@" + totalTicks);
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.m_46467_();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "MINE anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.performMine(this.firePos, this.firePreState);
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MINE: complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setSlamming(false);
    }

    private boolean verifyClaimOrAbort(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, @Nullable BlockPos claimedPos, @Nullable BlockPos currentTaskPos) {
        if (claimedPos == null) {
            return false;
        }
        if (currentTaskPos != null && !currentTaskPos.equals((Object)claimedPos)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        boolean buddyReserved = dockBlock.isReservedBy(serverLevel, taskType, claimedPos, this.byteBuddy.m_20148_());
        if (!buddyReserved) {
            BotDebug.log(this.byteBuddy, "lost " + taskType + " claim at " + claimedPos.m_123344_() + " \u2014 aborting");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "claim lost; rescan");
        }
        return buddyReserved;
    }

    private void releaseMineClaim() {
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (this.claimedMinePos != null && dockBlock != null) {
            dockBlock.releaseClaim(ByteBuddyEntity.TaskType.MINE, this.claimedMinePos, this.byteBuddy.m_20148_());
        }
        this.claimedMinePos = null;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        Level level;
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.SEEKING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.targetReselectRetries = 0;
        }
        if (phase == BotDebug.GoalPhase.ACTING && (level = this.byteBuddy.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "MINER: " + phase + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.releaseMineClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "MINER cannot start: " + reason + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.m_8041_();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.targetReselectRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private ScanBox makeRegionBox(ServerLevel level, BlockPos a, BlockPos b) {
        int xMin = Math.min(a.m_123341_(), b.m_123341_());
        int xMax = Math.max(a.m_123341_(), b.m_123341_());
        int yMin = this.clampY(level, Math.min(a.m_123342_(), b.m_123342_()));
        int yMax = this.clampY(level, Math.max(a.m_123342_(), b.m_123342_()));
        int zMin = Math.min(a.m_123343_(), b.m_123343_());
        int zMax = Math.max(a.m_123343_(), b.m_123343_());
        return new ScanBox(ScanMode.REGION, xMin, xMax, zMin, zMax, yMin, yMax, null, null, null, 0, 0);
    }

    private ScanBox makeBehindDockBox(ServerLevel level, BlockPos dock, int radius, DockingStationBlockEntity dockBlock) {
        Direction back = GoalUtil.backOfDock(dockBlock);
        Direction left = back.m_122427_();
        int yMin = this.clampY(level, level.m_141937_());
        int yMax = this.clampY(level, dock.m_123342_() + 2);
        int depth = Math.max(1, radius * 2);
        int half = Math.max(0, radius);
        return new ScanBox(ScanMode.BAND, 0, 0, 0, 0, yMin, yMax, dock, back, left, depth, half);
    }

    private int clampY(ServerLevel level, int y) {
        return Mth.m_14045_((int)y, (int)level.m_141937_(), (int)(level.m_151558_() - 1));
    }

    private void tryAddCandidate(Level level, ServerLevel serverLevel, DockingStationBlockEntity dockBlock, BlockPos dock, int y, int x, int z, BlockPos.MutableBlockPos cursor, ArrayList<MinePlan> out) {
        cursor.m_122178_(x, y, z);
        if (!GoalUtil.canMineAt(level, (BlockPos)cursor)) {
            return;
        }
        if (dockBlock.isReserved(serverLevel, ByteBuddyEntity.TaskType.MINE, (BlockPos)cursor)) {
            return;
        }
        if (!level.m_8055_(cursor.m_7494_()).m_60812_((BlockGetter)level, cursor.m_7494_()).m_83281_()) {
            return;
        }
        List<Approach> approaches = this.buildMineEdgeApproachPlans(level, cursor.m_7949_());
        if (approaches.isEmpty()) {
            return;
        }
        Approach best = approaches.get(0);
        double score = 0.0;
        score += GoalUtil.hDistSq(this.byteBuddy.m_20182_(), best.approachAnchor());
        score += (double)(dock.m_123342_() - cursor.m_123342_()) * 4.0;
        if (!level.m_6425_((BlockPos)cursor).m_76178_()) {
            score += 1000000.0;
        }
        out.add(new MinePlan(cursor.m_7949_(), best.targetPos(), best.path(), score));
    }

    private record MinePlan(BlockPos breakPos, BlockPos standPos, @Nullable Path path, double score) {
    }

    private static final class ScanBox {
        final ScanMode mode;
        final int xMin;
        final int xMax;
        final int zMin;
        final int zMax;
        final int yMin;
        final int yMax;
        final BlockPos origin;
        final Direction backDir;
        final Direction leftDir;
        final int depth;
        final int bandHalfWidth;

        private ScanBox(ScanMode mode, int xMin, int xMax, int zMin, int zMax, int yMin, int yMax, BlockPos origin, Direction backDir, Direction leftDir, int depth, int bandHalfWidth) {
            this.mode = mode;
            this.xMin = xMin;
            this.xMax = xMax;
            this.zMin = zMin;
            this.zMax = zMax;
            this.yMin = yMin;
            this.yMax = yMax;
            this.origin = origin;
            this.backDir = backDir;
            this.leftDir = leftDir;
            this.depth = depth;
            this.bandHalfWidth = bandHalfWidth;
        }
    }

    private static enum ScanMode {
        REGION,
        BAND;

    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

