/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.farmer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class TillGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private int targetReselectRetries = 0;
    private static final int seekingTimout = 20;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.25;
    private static final double finalApproachDist = 1.25;
    private static final double microDistMin = 0.08;
    private static final double microDistMax = 0.18;
    @Nullable
    private BlockPos claimedTillPos = null;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private static final int claimTimeOut = 120;
    private long nextClaimRenewTill = 0L;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;
    private static final int tillEnergyCost = 25;
    private static final int hydrationRadius = 4;
    private static final double dryPenalty = 10000.0;
    private static final double waterDistanceBonus = 500.0;
    private static final double dockDistanceBonus = 1.0;
    private static final double approachDistanceBonus = 25.0;

    public TillGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.m_21441_(BlockPathTypes.WATER, 8.0f);
        byteBuddy.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
    }

    public boolean m_8036_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() < this.animationEnd;
            }
            return true;
        }
        if (this.targetPos != null) {
            return true;
        }
        if (this.byteBuddy.getBuddyRole() != ByteBuddyEntity.BuddyRole.FARMER) {
            this.failTask(BotDebug.FailReason.WRONG_ROLE, "role=" + this.byteBuddy.getBuddyRole());
            return false;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            this.failTask(BotDebug.FailReason.NO_DOCK, "no station bound");
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.HOE, 25, 1)) {
            return false;
        }
        TillPlan tillPlan = this.findTillPlan();
        if (tillPlan != null) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
                if (!(dockBlock == null || this.claimedTillPos != null && this.claimedTillPos.equals((Object)tillPlan.blockPos()))) {
                    if (!dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.TILL, tillPlan.blockPos(), this.byteBuddy.m_20148_(), 120)) {
                        return false;
                    }
                    this.claimedTillPos = tillPlan.blockPos();
                    this.nextClaimRenewTill = serverLevel.m_46467_() + 5L;
                }
            }
            this.targetPos = tillPlan.blockPos();
            this.approachPos = tillPlan.approachPos();
            this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
            this.edgeAnchored = false;
            this.approachPlans = this.buildTillEdgeApproachPlans(this.byteBuddy.m_9236_(), this.targetPos);
            this.anchorIndex = 0;
            this.resetProgress();
            this.enterPhase(BotDebug.GoalPhase.MOVING, "to till site " + this.targetPos.m_123344_());
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.HOE, 25, 1);
    }

    public void m_8041_() {
        this.clearTimedAnimation();
        this.releaseTillClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.m_8041_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            boolean withinReachTill;
            PathNavigation pathNavigation;
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickTimedAnimation();
            if (this.targetPos == null || this.approachPos == null) {
                return;
            }
            Vec3 cropCenter = this.targetPos.m_252807_();
            if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.m_21563_().m_24950_(cropCenter.f_82479_, (double)this.targetPos.m_123342_(), cropCenter.f_82481_, 15.0f, 15.0f);
                return;
            }
            GoalUtil.renewClaimIfNeeded(this.byteBuddy, serverLevel, ByteBuddyEntity.TaskType.TILL, this.claimedTillPos, this.targetPos, serverLevel.m_46467_(), 5, 120, () -> this.nextClaimRenewTill, ticks -> {
                this.nextClaimRenewTill = ticks;
            });
            BlockState tillBlockState = this.byteBuddy.m_9236_().m_8055_(this.targetPos);
            if (this.currentPhase != BotDebug.GoalPhase.ACTING && !GoalUtil.canTillAt(this.byteBuddy.m_9236_(), this.targetPos)) {
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "till site invalid, rescan");
                return;
            }
            this.navigatePhases(serverLevel);
            if (this.targetAnchor != null) {
                double distToTarget = this.byteBuddy.m_20182_().m_82554_(this.targetAnchor);
                if (distToTarget > 1.25) {
                    PathNavigation pathNavigation2 = this.byteBuddy.m_21573_();
                    if (pathNavigation2 instanceof GroundPathNavigation) {
                        boolean needsNewPath;
                        GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                        Path currentPath = pathNavigation3.m_26570_();
                        boolean bl = needsNewPath = currentPath == null || currentPath.m_77392_() || this.approachPos == null || !currentPath.m_77406_().equals((Object)this.approachPos);
                        if (needsNewPath) {
                            Path path;
                            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                            Path path2 = path = this.approachPos != null ? pathNavigation3.m_7864_(this.approachPos, 0) : null;
                            if (path != null) {
                                pathNavigation3.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
                                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                            } else {
                                this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                            }
                        }
                    } else {
                        this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                    }
                    return;
                }
                if (!this.edgeAnchored) {
                    GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                    if (distToTarget <= 0.08) {
                        GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                        this.edgeAnchored = true;
                        this.markProgress();
                        BotDebug.log(this.byteBuddy, "TILL: locked anchor");
                    } else {
                        this.byteBuddy.m_21573_().m_26573_();
                        this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                        if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                            this.lastAnchorDistSq = distToTarget;
                            this.markProgress();
                        }
                        BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.m_123344_()));
                    }
                } else {
                    double distSq = Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.m_20182_(), this.targetAnchor));
                    if (distSq > 0.18) {
                        this.edgeAnchored = false;
                    }
                }
            } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.m_21573_()) instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                Path path = pathNavigation4.m_7864_(this.approachPos, 0);
                if (path != null) {
                    pathNavigation4.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
                    GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                } else {
                    Vec3 approachCenter = this.approachPos.m_252807_();
                    this.byteBuddy.m_21573_().m_26519_(approachCenter.f_82479_, (double)this.approachPos.m_123342_(), approachCenter.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                }
                return;
            }
            Vec3 buddyPos = this.byteBuddy.m_20182_();
            boolean bl = withinReachTill = GoalUtil.hDistSq(buddyPos, cropCenter) <= 0.9025 && Math.abs(buddyPos.f_82480_ - cropCenter.f_82480_) <= 1.25;
            if (this.currentPhase != BotDebug.GoalPhase.ACTING) {
                if (this.targetPos == null) {
                    BotDebug.log(this.byteBuddy, "TILL: targetPos null, aborting tick");
                    this.enterPhase(BotDebug.GoalPhase.IDLE, "null target");
                    return;
                }
                if (!GoalUtil.canTillAt(this.byteBuddy.m_9236_(), this.targetPos)) {
                    this.clearTarget();
                    this.enterPhase(BotDebug.GoalPhase.IDLE, "till site invalid, rescan");
                    return;
                }
            }
            if (withinReachTill) {
                if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                    this.byteBuddy.m_21563_().m_24950_(cropCenter.f_82479_, (double)this.targetPos.m_123342_(), cropCenter.f_82481_, 15.0f, 15.0f);
                } else {
                    if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                        return;
                    }
                    if (!this.verifyClaimOrAbort(serverLevel, ByteBuddyEntity.TaskType.TILL, this.claimedTillPos, this.targetPos)) {
                        return;
                    }
                    this.firePos = this.targetPos;
                    this.firePreState = tillBlockState;
                    int totalTicks = GoalUtil.toTicks(2.0);
                    int startTicks = GoalUtil.toTicks(0.4);
                    this.startTimedAnimation(totalTicks, startTicks, this.targetPos, tillBlockState);
                    BotDebug.log(this.byteBuddy, "TILL schedule: now=" + serverLevel.m_46467_() + " start=" + (serverLevel.m_46467_() + (long)startTicks) + " end=" + (serverLevel.m_46467_() + (long)totalTicks) + " firePos=" + this.firePos + " preState=" + this.firePreState.m_60734_().m_49954_().getString());
                    return;
                }
            }
            if (this.targetAnchor != null && !this.edgeAnchored) {
                this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
            }
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
            case SEEKING: {
                this.handleSeeking(serverLevel);
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled, rescan");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout, rescan");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.m_20182_(), this.targetAnchor)) <= 1.25;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.m_252807_();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.m_20182_(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
        Path path = pathNavigation2.m_26570_();
        if (path == null) {
            return;
        }
        if (serverLevel.m_46467_() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort act");
        }
    }

    private void handleSeeking(ServerLevel serverLevel) {
        if (!this.timedOut(20)) {
            return;
        }
        if (this.targetReselectRetries++ < 2) {
            TillPlan tillPlan = this.findTillPlan();
            if (tillPlan != null) {
                DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
                if (dockBlock != null && !dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.TILL, tillPlan.blockPos(), this.byteBuddy.m_20148_(), 120)) {
                    this.enterPhase(BotDebug.GoalPhase.SEEKING, "seek retry (claim failed)");
                    return;
                }
                this.claimedTillPos = tillPlan.blockPos();
                this.nextClaimRenewTill = serverLevel.m_46467_() + 5L;
                this.targetPos = tillPlan.blockPos();
                this.approachPos = tillPlan.approachPos();
                this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
                this.approachPlans = this.buildTillEdgeApproachPlans(this.byteBuddy.m_9236_(), this.targetPos);
                this.anchorIndex = 0;
                this.resetProgress();
                this.enterPhase(BotDebug.GoalPhase.MOVING, "retry seek -> moving");
            } else {
                this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout, no target");
            }
        } else {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout");
        }
    }

    private int waterDistance(Level level, BlockPos blockPos) {
        int radius = 4;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int topCandidateScore = 999;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -4; dx <= 4; ++dx) {
                for (int dz = -4; dz <= 4; ++dz) {
                    mutableBlockPos.m_122178_(blockPos.m_123341_() + dx, blockPos.m_123342_() + dy, blockPos.m_123343_() + dz);
                    if (!level.m_6425_((BlockPos)mutableBlockPos).m_205070_(FluidTags.f_13131_)) continue;
                    int candidateScore = Math.max(Math.abs(dx), Math.abs(dz));
                    if (candidateScore < topCandidateScore) {
                        topCandidateScore = candidateScore;
                    }
                    if (topCandidateScore != 0) continue;
                    return 0;
                }
            }
        }
        return topCandidateScore;
    }

    @Nullable
    private TillPlan findTillPlan() {
        BlockPos dockPos = this.byteBuddy.getDock().orElse(null);
        if (dockPos == null) {
            return null;
        }
        int radius = this.byteBuddy.effectiveRadius();
        Level level = this.byteBuddy.m_9236_();
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos.MutableBlockPos mutableDockPos = new BlockPos.MutableBlockPos();
        ArrayList<ScoredTillPlan> scores = new ArrayList<ScoredTillPlan>();
        Vec3 buddyPos = this.byteBuddy.m_20182_();
        for (int y = -1; y <= 2; ++y) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    List<Approach> approachPlans;
                    int waterDistance;
                    mutableDockPos.m_122178_(dockPos.m_123341_() + dx, dockPos.m_123342_() + y, dockPos.m_123343_() + dz);
                    if (!GoalUtil.canTillAt(level, (BlockPos)mutableDockPos) || dockBlock != null && dockBlock.isReserved(serverLevel, ByteBuddyEntity.TaskType.TILL, (BlockPos)mutableDockPos) || (waterDistance = this.waterDistance(level, (BlockPos)mutableDockPos)) == 999 || (approachPlans = this.buildTillEdgeApproachPlans(level, mutableDockPos.m_7949_())).isEmpty()) continue;
                    Approach best = approachPlans.get(0);
                    boolean isHydrated = waterDistance <= 4;
                    double score = 0.0;
                    score = !isHydrated ? (score += 10000.0) : (score += (double)Math.min(waterDistance, 4) * 500.0);
                    double dockDistanceX = mutableDockPos.m_123341_() - dockPos.m_123341_();
                    double dockDistanceZ = mutableDockPos.m_123343_() - dockPos.m_123343_();
                    score += (dockDistanceX * dockDistanceX + dockDistanceZ * dockDistanceZ) * 1.0;
                    Vec3 approachAnchor = best.approachAnchor();
                    double distanceToAnchorX = buddyPos.f_82479_ - approachAnchor.f_82479_;
                    double distanceToAnchorZ = buddyPos.f_82481_ - approachAnchor.f_82481_;
                    scores.add(new ScoredTillPlan(new TillPlan(mutableDockPos.m_7949_(), best.targetPos(), best.path(), isHydrated), score += (distanceToAnchorX * distanceToAnchorX + distanceToAnchorZ * distanceToAnchorZ) * 25.0));
                }
            }
        }
        if (scores.isEmpty()) {
            return null;
        }
        scores.sort(Comparator.comparingDouble(ScoredTillPlan::candidateScore));
        TillPlan chosenPlan = ((ScoredTillPlan)scores.get(0)).tillPlan();
        if (dockBlock != null) {
            if (!dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.TILL, chosenPlan.blockPos(), this.byteBuddy.m_20148_(), 120)) {
                return null;
            }
            this.claimedTillPos = chosenPlan.blockPos();
            this.nextClaimRenewTill = serverLevel.m_46467_() + 5L;
        }
        this.approachPlans = this.buildTillEdgeApproachPlans(level, chosenPlan.blockPos());
        this.anchorIndex = 0;
        this.approachPos = chosenPlan.approachPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(chosenPlan.blockPos(), chosenPlan.approachPos());
        this.edgeAnchored = false;
        return chosenPlan;
    }

    @Nullable
    private Approach nearestTillApproachFor(BlockPos blockPos) {
        List<Approach> plans = this.buildTillEdgeApproachPlans(this.byteBuddy.m_9236_(), blockPos);
        return plans.isEmpty() ? null : plans.get(0);
    }

    private List<Approach> buildTillEdgeApproachPlans(Level level, BlockPos blockPos) {
        ArrayList<Approach> list = new ArrayList<Approach>(8);
        BlockPos[] horizontal = new BlockPos[]{blockPos.m_122029_(), blockPos.m_122024_(), blockPos.m_122012_(), blockPos.m_122019_()};
        BlockPos[] horizontalPlusOne = new BlockPos[]{blockPos.m_122029_().m_7494_(), blockPos.m_122024_().m_7494_(), blockPos.m_122012_().m_7494_(), blockPos.m_122019_().m_7494_()};
        Consumer<BlockPos> addIfGood = standable -> {
            Path path;
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, standable)) {
                return;
            }
            Vec3 edgeAnchor = GoalUtil.getEdgeAnchor(blockPos, standable);
            if (edgeAnchor == null) {
                return;
            }
            PathNavigation pathNavigation = this.byteBuddy.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                v0 = pathNavigation2.m_7864_(standable, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) {
                return;
            }
            double horizontalDist = GoalUtil.hDistSq(this.byteBuddy.m_20182_(), edgeAnchor);
            list.add(new Approach((BlockPos)standable, edgeAnchor, horizontalDist, path));
        };
        for (BlockPos blockPositions : horizontal) {
            addIfGood.accept(blockPositions);
        }
        for (BlockPos blockPositionsPlusOne : horizontalPlusOne) {
            addIfGood.accept(blockPositionsPlusOne);
        }
        list.sort(Comparator.comparingDouble(Approach::distSq));
        return list;
    }

    private void performTill(BlockPos blockPos) {
        ServerLevel serverLevel;
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel && !this.verifyClaimOrAbort(serverLevel = (ServerLevel)level, ByteBuddyEntity.TaskType.TILL, this.claimedTillPos, blockPos)) {
            return;
        }
        if (!GoalUtil.canTillAt(level, blockPos)) {
            BotDebug.log(this.byteBuddy, "TILL invalid at " + blockPos.m_123344_());
            this.releaseTillClaim();
            return;
        }
        int energyCost = 25;
        if (!this.byteBuddy.consumeEnergy(energyCost)) {
            this.failTask(BotDebug.FailReason.OUT_OF_ENERGY, "need=" + energyCost);
            this.releaseTillClaim();
            return;
        }
        ToolUtil.applyToolWear(this.byteBuddy, ToolUtil.ToolType.HOE, this.byteBuddy.toolWearMultiplier());
        level.m_5594_(null, blockPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 0.8f + level.f_46441_.m_188501_() * 0.4f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level;
            int particlePoints = 12;
            for (int i = 0; i < particlePoints; ++i) {
                double particleInterval = Math.PI * 2 * (double)i / (double)particlePoints;
                serverLevel2.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(blockPos)), (double)blockPos.m_123341_() + 0.5 + Math.cos(particleInterval) * 0.5, (double)blockPos.m_123342_() + 0.125, (double)blockPos.m_123343_() + 0.5 + Math.sin(particleInterval) * 0.5, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        BlockState soilCandidate = level.m_8055_(blockPos);
        if (level.m_8055_(blockPos.m_7494_()).m_247087_()) {
            level.m_7731_(blockPos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
        if (soilCandidate.m_60713_(Blocks.f_50546_)) {
            level.m_7731_(blockPos, Blocks.f_50493_.m_49966_(), 3);
        } else {
            level.m_7731_(blockPos, Blocks.f_50093_.m_49966_(), 3);
        }
        this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.TILL, blockPos);
        this.releaseTillClaim();
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = pathNavigation2.m_7864_(this.approachPos, 0)) == null) {
                return false;
            }
            pathNavigation2.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level2 = this.byteBuddy.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int approaches = this.approachPlans.size();
        for (int tries = 0; tries < approaches; ++tries) {
            ServerLevel serverLevel;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % approaches;
            Approach approachCandidates = this.approachPlans.get(this.anchorIndex);
            BlockPos standPos = approachCandidates.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.m_9236_(), standPos) || (anchor = approachCandidates.approachAnchor()) == null) continue;
            Path path = null;
            PathNavigation pathNavigation = this.byteBuddy.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                path = pathNavigation2.m_7864_(standPos, 0);
            }
            if (path == null) continue;
            this.approachPos = standPos;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            pathNavigation = this.byteBuddy.m_9236_();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.m_21573_().m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.m_9236_();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.m_21573_().m_26573_();
            Vec3 deltaMovement = this.byteBuddy.m_20184_();
            this.byteBuddy.m_20334_(deltaMovement.f_82479_ * 0.1, deltaMovement.f_82480_ * 0.1, deltaMovement.f_82481_ * 0.1);
            this.byteBuddy.setSlamming(true);
            this.actionStarted = false;
            long currentTime = serverLevel.m_46467_();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMul = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMul));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: TILL fire@" + startTick + " end@" + totalTicks);
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.m_46467_();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "TILL anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.performTill(this.firePos);
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "TILL: complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setSlamming(false);
    }

    private boolean verifyClaimOrAbort(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, @Nullable BlockPos claimedPos, @Nullable BlockPos currentTaskPos) {
        if (claimedPos == null) {
            return false;
        }
        if (currentTaskPos != null && !currentTaskPos.equals((Object)claimedPos)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        boolean buddyReserved = dockBlock.isReservedBy(serverLevel, taskType, claimedPos, this.byteBuddy.m_20148_());
        if (!buddyReserved) {
            BotDebug.log(this.byteBuddy, "lost " + taskType + " claim at " + claimedPos.m_123344_() + " \u2014 aborting");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "claim lost; rescan");
        }
        return buddyReserved;
    }

    private void releaseTillClaim() {
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (this.claimedTillPos != null && dockBlock != null) {
            dockBlock.releaseClaim(ByteBuddyEntity.TaskType.TILL, this.claimedTillPos, this.byteBuddy.m_20148_());
        }
        this.claimedTillPos = null;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        Level level;
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.SEEKING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.targetReselectRetries = 0;
        }
        if (phase == BotDebug.GoalPhase.ACTING && (level = this.byteBuddy.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "FARMER: " + phase + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.releaseTillClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "FARMER cannot start: " + reason + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.m_8041_();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.targetReselectRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private record TillPlan(BlockPos blockPos, BlockPos approachPos, Path path, boolean isHydrated) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }

    private record ScoredTillPlan(TillPlan tillPlan, double candidateScore) {
    }
}

