/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.combat;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class BuddyMeleeAttackGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    private final double speed;
    private final boolean rememberTarget;
    private LivingEntity target;
    private int energyPerHit = 0;
    private static final ToolUtil.ToolType requiredTool = ToolUtil.ToolType.SWORD;
    private static final double safeDistance = 64.0;
    private static final float swellProgress = 0.55f;
    private boolean fleeingFromCreeper = false;
    private final double HIT_REACH;
    private static final double WINDUP_PAD = 0.5;
    private static final double KITE_TARGET = 2.5;
    private static final double KITE_ENTER = 3.0;
    private static final double KITE_EXIT = 3.0;
    private static final int REPATH_COOLDOWN = 2;
    private boolean requireKiteRadius = false;
    private int lastHurtTime = 0;
    private static final int HURT_COOLDOWN_TICKS = 12;
    private static final int MISS_COOLDOWN_TICKS = 10;
    private long hitTick = 0L;
    private long animEndTick = 0L;
    private boolean hitFired = false;
    private long nextAttackTick = 0L;
    private Phase phase = Phase.KITE;
    private long lastPathRecalcTick = 0L;

    public BuddyMeleeAttackGoal(ByteBuddyEntity byteBuddy, double speed, double hitReach, boolean rememberTarget) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.HIT_REACH = hitReach;
        this.rememberTarget = rememberTarget;
        this.energyPerHit = (int)(4.0 * byteBuddy.m_21133_(Attributes.f_22281_));
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.byteBuddy.m_5448_();
        boolean result = this.target == null || !this.target.m_6084_() ? false : (!GoalUtil.ensureUse(this.byteBuddy, requiredTool, this.energyPerHit, 1) ? false : this.byteBuddy.getDock().isEmpty());
        return result;
    }

    public boolean m_8045_() {
        boolean result;
        if (this.target == null || !this.target.m_6084_()) {
            result = false;
        } else if (this.rememberTarget) {
            boolean farOrNavigating = this.byteBuddy.m_20280_((Entity)this.target) > 3.0 || this.byteBuddy.m_21573_().m_26572_();
            boolean notKiting = this.phase != Phase.KITE || this.currentServerTime() < this.nextAttackTick;
            result = farOrNavigating || notKiting;
        } else {
            result = this.m_8036_();
        }
        return result;
    }

    public void m_8056_() {
        this.byteBuddy.m_21561_(true);
        this.clearAnim();
        this.phase = Phase.KITE;
        this.nextAttackTick = 0L;
        this.requireKiteRadius = false;
    }

    public void m_8041_() {
        this.byteBuddy.m_21561_(false);
        this.target = null;
        this.byteBuddy.m_21573_().m_26573_();
        this.clearAnim();
        this.phase = Phase.KITE;
        this.requireKiteRadius = false;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        long currentTick;
        ServerLevel levelServer;
        Level level = this.byteBuddy.m_9236_();
        ServerLevel serverLevel = level instanceof ServerLevel ? (levelServer = (ServerLevel)level) : null;
        long l = currentTick = serverLevel != null ? serverLevel.m_46467_() : 0L;
        if (this.target != null && this.target.m_6084_()) {
            LivingEntity latest = this.byteBuddy.m_5448_();
            if (latest != null) {
                this.target = latest;
            }
            this.tickAnim(currentTick);
            this.byteBuddy.m_21563_().m_24960_((Entity)this.target, 90.0f, 90.0f);
            boolean creeperHandled = this.handleCreeper(currentTick);
            if (!creeperHandled) {
                this.lowHealthFlee(this.byteBuddy, currentTick);
                double distanceSquared = this.byteBuddy.m_20280_((Entity)this.target);
                if (this.phase == Phase.KITE) {
                    boolean cooldownReady;
                    boolean bl = cooldownReady = currentTick >= this.nextAttackTick;
                    if (this.requireKiteRadius && distanceSquared < 9.0) {
                        this.kiteTowardRadius(2.5, Math.max(1.0, this.speed * 1.66), currentTick);
                    } else {
                        this.requireKiteRadius = false;
                        if (!cooldownReady || distanceSquared < 9.0) {
                            this.kiteTowardRadius(2.5, Math.max(1.0, this.speed * 1.66), currentTick);
                        } else {
                            this.phase = Phase.APPROACH;
                        }
                    }
                } else if (this.phase == Phase.APPROACH) {
                    if (currentTick < this.nextAttackTick) {
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                    } else {
                        this.throttledMoveToTarget(currentTick, this.speed);
                        if (this.inWindupRangeAabb()) {
                            if (this.byteBuddy.getEnergyStorage().getEnergyStored() >= this.energyPerHit) {
                                this.startWindup(currentTick);
                                this.phase = Phase.WINDUP;
                            } else {
                                this.strafeAround(this.target, Math.max(1.0, this.speed), currentTick);
                            }
                        }
                    }
                } else if (this.phase == Phase.WINDUP && (this.animEndTick <= 0L || currentTick >= this.animEndTick)) {
                    this.phase = Phase.KITE;
                }
            }
        }
    }

    private void throttledMoveToTarget(long currentTick, double runSpeed) {
        if (currentTick - this.lastPathRecalcTick >= 2L) {
            this.byteBuddy.m_21573_().m_5624_((Entity)this.target, runSpeed);
            this.lastPathRecalcTick = currentTick;
        }
    }

    private boolean handleCreeper(long currentTick) {
        boolean result;
        LivingEntity livingEntity = this.target;
        if (!(livingEntity instanceof Creeper)) {
            this.fleeingFromCreeper = false;
            result = false;
        } else {
            boolean dangerousNow;
            Creeper creeper = (Creeper)livingEntity;
            double distanceSquared = this.byteBuddy.m_20280_((Entity)this.target);
            float swelling = creeper.m_32320_(0.0f);
            boolean bl = dangerousNow = creeper.m_32311_() || swelling >= 0.55f;
            if (!this.fleeingFromCreeper) {
                if (dangerousNow && distanceSquared < 64.0) {
                    this.fleeingFromCreeper = true;
                    this.byteBuddy.m_21573_().m_26573_();
                }
            } else {
                boolean calmed;
                boolean bl2 = calmed = !creeper.m_32311_() && swelling <= 0.35f;
                if (calmed && distanceSquared >= 64.0) {
                    this.fleeingFromCreeper = false;
                }
            }
            if (this.fleeingFromCreeper) {
                this.fleeFrom(this.target, Math.max(1.0, this.speed * 1.66));
                this.ensureKiteUntil(currentTick + 10L);
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    private void lowHealthFlee(ByteBuddyEntity byteBuddy, long currentTick) {
        if ((double)byteBuddy.m_21223_() < (double)byteBuddy.m_21233_() * 0.4 && this.justGotHit()) {
            this.nextAttackTick = Math.max(this.nextAttackTick, currentTick + 12L);
            this.requireKiteRadius = true;
        }
    }

    private void ensureKiteUntil(long absoluteTick) {
        this.nextAttackTick = Math.max(this.nextAttackTick, absoluteTick);
        this.phase = Phase.KITE;
    }

    private void kiteTowardRadius(double targetRadius, double runSpeed, long currentTick) {
        if (this.target != null) {
            boolean alreadyOutside;
            double distance = Math.sqrt(this.byteBuddy.m_20280_((Entity)this.target));
            boolean bl = alreadyOutside = distance >= 2.5;
            if (alreadyOutside) {
                this.strafeAround(this.target, runSpeed, currentTick);
            } else {
                double delta = Mth.m_14008_((double)(targetRadius - distance), (double)2.0, (double)12.0);
                Vec3 away = this.byteBuddy.m_20182_().m_82546_(this.target.m_20182_());
                if (away.m_82556_() < 1.0E-4) {
                    away = new Vec3(1.0, 0.0, 0.0);
                }
                away = away.m_82541_().m_82490_(delta);
                Vec3 destination = this.byteBuddy.m_20182_().m_82520_(away.f_82479_, 0.0, away.f_82481_);
                Vec3 random = DefaultRandomPos.m_148407_((PathfinderMob)this.byteBuddy, (int)14, (int)6, (Vec3)this.target.m_20182_());
                if (random != null) {
                    destination = random;
                }
                if (currentTick - this.lastPathRecalcTick >= 2L) {
                    this.byteBuddy.m_21573_().m_26519_(destination.f_82479_, destination.f_82480_, destination.f_82481_, runSpeed);
                    this.lastPathRecalcTick = currentTick;
                }
            }
        }
    }

    private void strafeAround(LivingEntity pivot, double runSpeed, long currentTick) {
        Vec3 toMe = this.byteBuddy.m_20182_().m_82546_(pivot.m_20182_());
        if (toMe.m_82556_() < 1.0E-4) {
            toMe = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 perpendicular = new Vec3(-toMe.f_82481_, 0.0, toMe.f_82479_).m_82541_().m_82490_(2.5);
        Vec3 destination = this.byteBuddy.m_20182_().m_82549_(perpendicular);
        if (currentTick - this.lastPathRecalcTick >= 2L) {
            this.byteBuddy.m_21573_().m_26519_(destination.f_82479_, destination.f_82480_, destination.f_82481_, Math.max(1.0, runSpeed));
            this.lastPathRecalcTick = currentTick;
        }
    }

    private void fleeFrom(LivingEntity threat, double runSpeed) {
        Vec3 away = this.byteBuddy.m_20182_().m_82546_(threat.m_20182_());
        if (away.m_82556_() < 1.0E-4) {
            away = new Vec3(1.0, 0.0, 0.0);
        }
        away = away.m_82541_().m_82490_(8.0);
        Vec3 destination = this.byteBuddy.m_20182_().m_82520_(away.f_82479_, 0.0, away.f_82481_);
        Vec3 random = DefaultRandomPos.m_148407_((PathfinderMob)this.byteBuddy, (int)12, (int)6, (Vec3)threat.m_20182_());
        if (random != null) {
            destination = random;
        }
        this.byteBuddy.m_21573_().m_26519_(destination.f_82479_, destination.f_82480_, destination.f_82481_, runSpeed);
    }

    private boolean justGotHit() {
        int hurtTime = this.byteBuddy.f_20916_;
        boolean edge = hurtTime > 0 && this.lastHurtTime <= 0;
        this.lastHurtTime = hurtTime;
        boolean result = edge;
        return result;
    }

    private double toolReachBonus() {
        if (this.byteBuddy.getHeldTool().m_150930_((Item)ModItems.BUSTER_SWORD.get()) || this.byteBuddy.getHeldTool().m_150930_((Item)ModItems.TERRABLADE.get())) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean inMeleeRangeAabb() {
        if (this.target == null) {
            return false;
        }
        double reach = this.HIT_REACH + this.toolReachBonus();
        return this.byteBuddy.m_20191_().m_82377_(reach / 2.0, (double)this.byteBuddy.m_20205_(), reach / 2.0).m_82381_(this.target.m_20191_());
    }

    private boolean inWindupRangeAabb() {
        if (this.target == null) {
            return false;
        }
        double reach = this.HIT_REACH + this.toolReachBonus() + 0.5;
        return this.byteBuddy.m_20191_().m_82377_(reach / 2.0, (double)this.byteBuddy.m_20205_(), reach / 2.0).m_82381_(this.target.m_20191_());
    }

    private long currentServerTime() {
        long l;
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            l = serverLevel.m_46467_();
        } else {
            l = 0L;
        }
        return l;
    }

    private void startWindup(long currentTick) {
        this.hitFired = false;
        int totalTicks = GoalUtil.toTicks(1.6);
        int startTicks = GoalUtil.toTicks(0.7);
        this.hitTick = currentTick + (long)Math.max(0, startTicks);
        this.animEndTick = currentTick + (long)Math.max(1, totalTicks);
        this.byteBuddy.setSlicing(true);
        double attackSpeed = Math.max(0.1, this.byteBuddy.m_21133_(Attributes.f_22283_));
        int cooldownTicks = Mth.m_14045_((int)Mth.m_14165_((double)(20.0 / attackSpeed)), (int)4, (int)40);
        this.nextAttackTick = currentTick + (long)cooldownTicks;
    }

    private void clearAnim() {
        this.hitFired = false;
        this.hitTick = 0L;
        this.animEndTick = 0L;
        this.byteBuddy.setSlicing(false);
    }

    private void tickAnim(long currentTick) {
        if (this.animEndTick > 0L) {
            if (!this.hitFired && currentTick >= this.hitTick) {
                this.hitFired = true;
                LivingEntity latest = this.byteBuddy.m_5448_();
                if (latest != null) {
                    this.target = latest;
                }
                if (this.target != null && this.target.m_6084_()) {
                    if (this.inMeleeRangeAabb() && this.byteBuddy.consumeEnergy(this.energyPerHit)) {
                        this.byteBuddy.m_21011_(InteractionHand.MAIN_HAND, true);
                        this.byteBuddy.m_7327_((Entity)this.target);
                        ToolUtil.applyToolWear(this.byteBuddy, requiredTool, 1.0f);
                        this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.COMBAT, this.byteBuddy.m_20097_());
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                    } else {
                        BotDebug.log(this.byteBuddy, "COMBAT: miss/energy fail at hit frame");
                        this.phase = Phase.KITE;
                        this.requireKiteRadius = true;
                        this.nextAttackTick = Math.max(this.nextAttackTick, currentTick + 10L);
                    }
                } else {
                    this.phase = Phase.KITE;
                    this.requireKiteRadius = true;
                }
            }
            if (currentTick >= this.animEndTick) {
                this.clearAnim();
            }
        }
    }

    private static enum Phase {
        KITE,
        APPROACH,
        WINDUP;

    }
}

