/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class RandomWaveAtFriendGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    private final double radius;
    private final int cooldownTicks;
    private final int waveDurationTicks;
    private int cooldown;
    private int remaining;
    private LivingEntity target;

    public RandomWaveAtFriendGoal(ByteBuddyEntity byteBuddy, double radius, int cooldownTicks, int waveDurationTicks) {
        this.byteBuddy = byteBuddy;
        this.radius = radius;
        this.cooldownTicks = cooldownTicks;
        this.waveDurationTicks = waveDurationTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean hasEyesOn(LivingEntity livingEntity) {
        Vec3 origin = this.byteBuddy.m_146892_();
        Vec3 eyeDestination = livingEntity.m_146892_();
        BlockHitResult hitResult = this.byteBuddy.m_9236_().m_45547_(new ClipContext(origin, eyeDestination, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)this.byteBuddy));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private boolean inFov(LivingEntity livingEntity) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.m_20252_(1.0f).m_82541_();
        return look.m_82526_(dir = livingEntity.m_146892_().m_82546_(this.byteBuddy.m_146892_()).m_82541_()) > 0.2;
    }

    public boolean m_8036_() {
        if (this.byteBuddy.m_5803_() || this.byteBuddy.isWaving() || this.byteBuddy.isWaking()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        List candidates = this.byteBuddy.m_9236_().m_6443_(LivingEntity.class, this.byteBuddy.m_20191_().m_82400_(this.radius), livingEntity -> livingEntity.m_6084_() && livingEntity != this.byteBuddy && !(livingEntity instanceof Monster) && this.hasEyesOn((LivingEntity)livingEntity) && this.inFov((LivingEntity)livingEntity));
        if (candidates.isEmpty()) {
            return false;
        }
        if (this.byteBuddy.m_217043_().m_188503_(3) != 0) {
            return false;
        }
        this.target = (LivingEntity)candidates.get(this.byteBuddy.m_217043_().m_188503_(candidates.size()));
        this.remaining = this.waveDurationTicks;
        return this.target != null;
    }

    public void m_8056_() {
        this.byteBuddy.setWaving(true);
        this.byteBuddy.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
    }

    public boolean m_8045_() {
        return this.remaining > 0 && this.byteBuddy.m_6084_() && !this.byteBuddy.m_5803_() && this.target != null && this.target.m_6084_();
    }

    public void m_8037_() {
        if (this.target != null) {
            this.byteBuddy.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        }
        if (--this.remaining <= 0) {
            // empty if block
        }
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8041_() {
        this.byteBuddy.setWaving(false);
        this.cooldown = this.cooldownTicks;
        this.target = null;
        this.remaining = 0;
    }
}

