/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class DepositToDockGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.66;
    private static final double finalApproachDist = 1.66;
    private static final double microDistMin = 0.15;
    private static final double microDistMax = 0.28;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;

    public DepositToDockGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.m_21441_(BlockPathTypes.WATER, 8.0f);
        byteBuddy.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
    }

    public boolean m_8036_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() <= this.animationEnd;
            }
            return true;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 64)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        IItemHandler dockInventory = (IItemHandler)dockBlock.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
        if (!this.canDepositAny(dockInventory)) {
            return false;
        }
        BlockPos dockPos = dockBlock.m_58899_();
        Optional<DockPlan> plan = this.findDockPlan(dockPos);
        if (plan.isEmpty()) {
            return false;
        }
        this.targetPos = plan.get().targetPos();
        this.approachPos = plan.get().approachPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "approach dock " + this.approachPos.m_123344_());
        return true;
    }

    public boolean m_8045_() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.m_46467_() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 64);
    }

    public void m_8041_() {
        this.clearTimedAnimation();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.m_8041_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        boolean withinReach;
        PathNavigation pathNavigation;
        Level level = this.byteBuddy.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.tickTimedAnimation();
        if (this.targetPos == null || this.approachPos == null) {
            return;
        }
        Vec3 targetCenter = this.targetPos.m_252807_();
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            this.byteBuddy.m_21563_().m_24950_(targetCenter.f_82479_, targetCenter.f_82480_, targetCenter.f_82481_, 15.0f, 15.0f);
            return;
        }
        this.navigatePhases(serverLevel);
        if (this.targetAnchor != null) {
            double distToTarget = this.byteBuddy.m_20182_().m_82554_(this.targetAnchor);
            if (distToTarget > 1.66) {
                PathNavigation pathNavigation2 = this.byteBuddy.m_21573_();
                if (pathNavigation2 instanceof GroundPathNavigation) {
                    boolean needsNewPath;
                    GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                    Path currentPath = pathNavigation3.m_26570_();
                    boolean bl = needsNewPath = currentPath == null || currentPath.m_77392_() || this.approachPos == null || !currentPath.m_77406_().equals((Object)this.approachPos);
                    if (needsNewPath) {
                        Path path;
                        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                        Path path2 = path = this.approachPos != null ? pathNavigation3.m_7864_(this.approachPos, 0) : null;
                        if (path != null) {
                            pathNavigation3.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
                            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                        } else {
                            this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                        }
                    }
                } else {
                    this.byteBuddy.m_21573_().m_26519_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                }
                return;
            }
            if (!this.edgeAnchored) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                if (distToTarget <= 0.15) {
                    GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                    this.edgeAnchored = true;
                    this.markProgress();
                    BotDebug.log(this.byteBuddy, "DEPOSIT: locked anchor");
                } else {
                    this.byteBuddy.m_21573_().m_26573_();
                    this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
                    if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                        this.lastAnchorDistSq = distToTarget;
                        this.markProgress();
                    }
                    BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.m_123344_()));
                }
            } else {
                double distanceToTarget = this.byteBuddy.m_20182_().m_82554_(this.targetAnchor);
                if (distanceToTarget > 0.28) {
                    this.edgeAnchored = false;
                }
            }
        } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.m_21573_()) instanceof GroundPathNavigation) {
            GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            Path path = pathNavigation4.m_7864_(this.approachPos, 0);
            pathNavigation4.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            return;
        }
        Vec3 buddyPos = this.byteBuddy.m_20182_();
        boolean bl = withinReach = GoalUtil.hDistSq(buddyPos, targetCenter) <= 0.9025 && Math.abs(buddyPos.f_82480_ - targetCenter.f_82480_) <= 1.66;
        if (withinReach) {
            if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.m_21563_().m_24950_(targetCenter.f_82479_, targetCenter.f_82480_, targetCenter.f_82481_, 15.0f, 15.0f);
            } else {
                if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                    return;
                }
                this.firePos = this.targetPos;
                this.firePreState = this.byteBuddy.m_9236_().m_8055_(this.targetPos);
                this.startTimedAnimation(GoalUtil.toTicks(2.6), GoalUtil.toTicks(1.8), this.targetPos, this.firePreState);
                BlockEntity blockEntity = serverLevel.m_7702_(this.firePos);
                if (blockEntity instanceof DockingStationBlockEntity) {
                    DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
                    serverLevel.m_7731_(this.firePos, (BlockState)dockBlock.m_58900_().m_61124_((Property)DockingStationBlock.OPEN, (Comparable)Boolean.TRUE), 3);
                }
                BotDebug.log(this.byteBuddy, "DEPOSIT schedule now=" + serverLevel.m_46467_());
            }
        }
        if (this.targetAnchor != null && !this.edgeAnchored) {
            this.byteBuddy.m_21566_().m_6849_(this.targetAnchor.f_82479_, this.targetAnchor.f_82480_, this.targetAnchor.f_82481_, (double)this.byteBuddy.actionSpeedMultiplier());
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.m_20182_(), this.targetAnchor)) <= 1.66;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.m_252807_();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.m_20182_(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
        Path path = navigation.m_26570_();
        if (path == null) {
            return;
        }
        if (serverLevel.m_46467_() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort deposit");
        }
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            if (this.byteBuddy.m_9236_() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = navigation.m_7864_(this.approachPos, 0)) == null) {
                return false;
            }
            navigation.m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level = this.byteBuddy.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int n = this.approachPlans.size();
        for (int tries = 0; tries < n; ++tries) {
            Path path;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % n;
            Approach candidate = this.approachPlans.get(this.anchorIndex);
            BlockPos stand = candidate.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.m_9236_(), stand) || (anchor = candidate.approachAnchor()) == null) continue;
            PathNavigation pathNavigation = this.byteBuddy.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
                v0 = navigation.m_7864_(stand, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) continue;
            this.approachPos = stand;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            if (this.byteBuddy.m_9236_() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.m_21573_().m_26536_(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.m_9236_();
            if (pathNavigation instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.m_21573_().m_26573_();
            Vec3 deltaMovement = this.byteBuddy.m_20184_();
            this.byteBuddy.m_20334_(deltaMovement.f_82479_ * 0.1, deltaMovement.f_82480_ * 0.1, deltaMovement.f_82481_ * 0.1);
            this.byteBuddy.setWorking(true);
            this.actionStarted = false;
            long currentTime = serverLevel.m_46467_();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMultiplier = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMultiplier));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: DEPOSIT");
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.m_46467_();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "DEPOSIT anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.actionStarted = true;
                this.performDeposit(serverLevel, this.firePos);
                BlockEntity blockEntity = serverLevel.m_7702_(this.firePos);
                if (blockEntity instanceof DockingStationBlockEntity) {
                    DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
                    serverLevel.m_7731_(this.firePos, (BlockState)dockBlock.m_58900_().m_61124_((Property)DockingStationBlock.OPEN, (Comparable)Boolean.FALSE), 3);
                }
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "DEPOSIT complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setWorking(false);
    }

    private Optional<DockPlan> findDockPlan(BlockPos dockPos) {
        Path path;
        BlockState blockState;
        Direction facing;
        BlockPos approachPos;
        Level level = this.byteBuddy.m_9236_();
        if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, approachPos = dockPos.m_121945_(facing = (Direction)(blockState = level.m_8055_(dockPos)).m_61143_((Property)DockingStationBlock.FACING)))) {
            return Optional.empty();
        }
        PathNavigation pathNavigation = this.byteBuddy.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            v0 = pathNavigation2.m_7864_(approachPos, 0);
        } else {
            v0 = path = null;
        }
        if (path == null) {
            return Optional.empty();
        }
        Vec3 edgeAnchor = GoalUtil.getEdgeAnchor(dockPos, approachPos);
        if (edgeAnchor == null) {
            return Optional.empty();
        }
        this.approachPlans = List.of(new Approach(approachPos, edgeAnchor, GoalUtil.hDistSq(this.byteBuddy.m_20182_(), edgeAnchor), path));
        this.anchorIndex = 0;
        return Optional.of(new DockPlan(dockPos, approachPos, path));
    }

    private void performDeposit(ServerLevel serverLevel, BlockPos dockPos) {
        BlockEntity dockBE = serverLevel.m_7702_(dockPos);
        if (dockBE == null) {
            return;
        }
        IItemHandler dockInventory = (IItemHandler)dockBE.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
        int totalMoved = 0;
        for (int slot = 9; slot < this.byteBuddy.getMainInv().getSlots(); ++slot) {
            ItemStack itemRemainder;
            int insertedAmount;
            ItemStack stackInSlot = this.byteBuddy.getMainInv().getStackInSlot(slot);
            if (stackInSlot.m_41619_()) continue;
            ItemStack simulatedRemainder = this.tryInsertAll(dockInventory, stackInSlot, true);
            int insertableAmount = stackInSlot.m_41613_() - simulatedRemainder.m_41613_();
            if (insertableAmount <= 0 || (insertedAmount = insertableAmount - (itemRemainder = this.tryInsertAll(dockInventory, stackInSlot.m_255036_(insertableAmount), false)).m_41613_()) <= 0) continue;
            this.byteBuddy.getMainInv().extractItem(slot, insertedAmount, false);
            totalMoved += insertedAmount;
        }
        if (totalMoved > 0) {
            this.byteBuddy.consumeEnergy(totalMoved);
            BotDebug.log(this.byteBuddy, "DEPOSIT: moved " + totalMoved + " items to dock");
        }
    }

    private ItemStack tryInsertAll(IItemHandler destinationInventory, ItemStack itemStack, boolean simulate) {
        ItemStack itemRemainder = itemStack.m_41777_();
        for (int slot = 0; slot < destinationInventory.getSlots() && !(itemRemainder = destinationInventory.insertItem(slot, itemRemainder, simulate)).m_41619_(); ++slot) {
        }
        return itemRemainder;
    }

    private boolean canDepositAny(IItemHandler dockInventory) {
        if (dockInventory == null) {
            return false;
        }
        ItemStackHandler buddyInv = this.byteBuddy.getMainInv();
        int slots = buddyInv.getSlots();
        for (int slot = 9; slot < slots; ++slot) {
            ItemStack simulatedRemainder;
            ItemStack stackInSlot = buddyInv.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (simulatedRemainder = this.tryInsertAll(dockInventory, stackInSlot, true)).m_41613_() >= stackInSlot.m_41613_()) continue;
            return true;
        }
        return false;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.ACTING && this.byteBuddy.m_9236_() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "DEPOSITOR: " + phase + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        if (this.byteBuddy.m_9236_() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "DEPOSITOR cannot start: " + reason + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.m_8041_();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private record DockPlan(BlockPos targetPos, BlockPos approachPos, Path path) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

