/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.Nullable;

public class BuddyPickUpItemGoal
extends Goal {
    private static final boolean DEBUG = false;
    private static final int DEBUG_RATE_TICKS = 10;
    private final ByteBuddyEntity byteBuddy;
    private final double speed;
    private final double scanRange;
    private final double grabDistance;
    @Nullable
    private Vec3 approachTarget = null;
    private final int repathCooldownTicks;
    private ItemEntity target;
    private long lastPathTick;
    private int debugTickCounter;

    public BuddyPickUpItemGoal(ByteBuddyEntity byteBuddy, double speed, double scanRange, double grabDistance, int repathCooldownTicks) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.scanRange = scanRange;
        this.grabDistance = grabDistance;
        this.repathCooldownTicks = Math.max(2, repathCooldownTicks);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.byteBuddy.m_9236_().f_46443_) {
            this.debugOnce("canUse=false (client side)");
            return false;
        }
        if (!this.byteBuddy.canAct()) {
            this.debugOnce("canUse=false (cannot act: sleeping or gated)");
            return false;
        }
        this.target = this.findVisibleItem();
        if (this.target == null || !this.target.m_6084_()) {
            this.debugOnce("canUse=false (no visible item that fits)");
            return false;
        }
        ItemStack stack = this.target.m_32055_();
        if (stack.m_41619_()) {
            this.debugOnce("canUse=false (target stack empty)");
            return false;
        }
        boolean fits = this.byteBuddy.canFitInInventory(stack);
        this.debugOnce("canUse target=" + BuddyPickUpItemGoal.debugItem(this.target) + " fits=" + fits);
        return fits;
    }

    public boolean m_8045_() {
        boolean cont;
        if (this.byteBuddy.m_9236_().f_46443_) {
            this.debugOnce("continue=false (client side)");
            return false;
        }
        if (!this.byteBuddy.canAct()) {
            this.debugOnce("continue=false (cannot act)");
            return false;
        }
        if (this.target == null || !this.target.m_6084_()) {
            this.debugOnce("continue=false (target null/dead)");
            return false;
        }
        if (!this.byteBuddy.canFitInInventory(this.target.m_32055_())) {
            this.debugOnce("continue=false (no longer fits)");
            return false;
        }
        double maxChase = this.scanRange + 2.0;
        double distSq = this.byteBuddy.m_20280_((Entity)this.target);
        boolean closeEnough = distSq <= maxChase * maxChase;
        boolean pathing = this.byteBuddy.m_21573_().m_26572_();
        boolean bl = cont = closeEnough || pathing || this.isInPickupRange(this.target, this.grabDistance);
        if (!cont) {
            this.debugOnce("continue=false (too far and not pathing) dist=" + String.format("%.2f", Math.sqrt(distSq)));
        }
        return cont;
    }

    public void m_8056_() {
        this.lastPathTick = 0L;
        Vec3 vec3 = this.approachTarget = this.target != null ? this.findPickupApproach(this.target) : null;
        if (this.approachTarget != null) {
            this.debugOnce("start: path\u2192approach " + BuddyPickUpItemGoal.debugPos(this.approachTarget.f_82479_, this.approachTarget.f_82480_, this.approachTarget.f_82481_));
            this.byteBuddy.m_21573_().m_26519_(this.approachTarget.f_82479_, this.approachTarget.f_82480_, this.approachTarget.f_82481_, this.speed);
        } else if (this.target != null) {
            this.debugOnce("start: fallback path\u2192entity " + BuddyPickUpItemGoal.debugPos(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()));
            this.byteBuddy.m_21573_().m_5624_((Entity)this.target, this.speed);
        }
    }

    public void m_8041_() {
        this.debugOnce("stop");
        this.target = null;
        this.byteBuddy.m_21573_().m_26573_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        long now;
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        this.byteBuddy.m_21563_().m_24960_((Entity)this.target, 15.0f, 15.0f);
        boolean facing = this.isFacing((Entity)this.target, 0.9);
        if (this.isInPickupRange(this.target, this.grabDistance)) {
            this.debugEvery("tick: AABB overlap \u2192 pickup");
            if (this.isInPickupRange(this.target, this.grabDistance) && facing) {
                this.tryPickup(this.target);
                return;
            }
        }
        if ((now = (long)this.byteBuddy.f_19797_) - this.lastPathTick >= (long)this.repathCooldownTicks) {
            Vec3 newApproach = this.findPickupApproach(this.target);
            if (newApproach != null) {
                if (this.approachTarget == null || newApproach.m_82557_(this.approachTarget) > 0.25) {
                    this.approachTarget = newApproach;
                    this.debugEvery("tick: repath\u2192approach " + BuddyPickUpItemGoal.debugPos(newApproach.f_82479_, newApproach.f_82480_, newApproach.f_82481_));
                    this.byteBuddy.m_21573_().m_26519_(newApproach.f_82479_, newApproach.f_82480_, newApproach.f_82481_, this.speed);
                } else if (!this.byteBuddy.m_21573_().m_26572_()) {
                    this.debugEvery("tick: path done but no overlap \u2192 reassert approach");
                    this.byteBuddy.m_21573_().m_26519_(this.approachTarget.f_82479_, this.approachTarget.f_82480_, this.approachTarget.f_82481_, this.speed);
                }
            } else {
                this.debugEvery("tick: no standable approach \u2192 path\u2192item XYZ");
                this.byteBuddy.m_21573_().m_26519_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), this.speed);
            }
            this.lastPathTick = now;
        }
        if (!this.isInPickupRange(this.target, this.grabDistance) && !this.byteBuddy.m_21573_().m_26572_()) {
            this.debugEvery("tick: nav done, no overlap \u2192 micro-walk");
            this.byteBuddy.m_21566_().m_6849_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), Math.max(0.6, this.speed));
        }
    }

    private ItemEntity findVisibleItem() {
        double range = this.scanRange;
        AABB box = new AABB(this.byteBuddy.m_20185_() - range, this.byteBuddy.m_20186_() - range, this.byteBuddy.m_20189_() - range, this.byteBuddy.m_20185_() + range, this.byteBuddy.m_20186_() + range, this.byteBuddy.m_20189_() + range);
        List items = this.byteBuddy.m_9236_().m_6443_(ItemEntity.class, box, itemEntity -> itemEntity.m_6084_() && !itemEntity.m_32055_().m_41619_());
        ItemEntity best = null;
        double bestScore = Double.POSITIVE_INFINITY;
        for (ItemEntity itemEntity2 : items) {
            if (!this.byteBuddy.canFitInInventory(itemEntity2.m_32055_())) {
                this.debugEvery("scan skip " + BuddyPickUpItemGoal.debugItem(itemEntity2) + " fits=false");
                continue;
            }
            boolean fov = this.inFov((Entity)itemEntity2);
            boolean los = this.hasEyesOn((Entity)itemEntity2);
            double dist = this.byteBuddy.m_20280_((Entity)itemEntity2);
            double d = fov && los ? 0.0 : 1.0;
            double penalty = d;
            double score = dist + penalty;
            if (!(score < bestScore)) continue;
            bestScore = score;
            best = itemEntity2;
        }
        if (best != null) {
            this.debugOnce("scan best " + BuddyPickUpItemGoal.debugItem(best) + " dist=" + String.format("%.2f", Math.sqrt(bestScore)));
        }
        return best;
    }

    private boolean hasEyesOn(Entity entity) {
        Vec3 origin = this.byteBuddy.m_146892_();
        Vec3 eyeDest = entity.m_146892_();
        BlockHitResult hit = this.byteBuddy.m_9236_().m_45547_(new ClipContext(origin, eyeDest, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)this.byteBuddy));
        boolean miss = hit.m_6662_() == HitResult.Type.MISS;
        this.debugEvery("LOS " + BuddyPickUpItemGoal.debugItemPos(entity) + " \u2192 " + hit.m_6662_());
        return miss;
    }

    private boolean isFacing(Entity entity, double dotThreshold) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.m_20252_(1.0f).m_82541_();
        return look.m_82526_(dir = entity.m_146892_().m_82546_(this.byteBuddy.m_146892_()).m_82541_()) >= dotThreshold;
    }

    private boolean inFov(Entity entity) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.m_20252_(1.0f).m_82541_();
        double dot = look.m_82526_(dir = entity.m_146892_().m_82546_(this.byteBuddy.m_146892_()).m_82541_());
        boolean validSight = dot > 0.2;
        this.debugEvery("FOV " + BuddyPickUpItemGoal.debugItemPos(entity) + " dot=" + String.format("%.3f", dot) + " validSight=" + validSight);
        return validSight;
    }

    private boolean isInPickupRange(ItemEntity itemEntity, double grabRadius) {
        boolean aabbTouch = this.byteBuddy.m_20191_().m_82377_(grabRadius / 2.0, (double)this.byteBuddy.m_20205_(), grabRadius / 2.0).m_82381_(itemEntity.m_20191_());
        this.debugEvery("range " + BuddyPickUpItemGoal.debugItem(itemEntity) + " aabb=" + aabbTouch + " \u2192 " + aabbTouch);
        return aabbTouch;
    }

    @Nullable
    private Vec3 findPickupApproach(ItemEntity item) {
        int[][] OFFS = new int[][]{{0, 0}, {1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        Level level = this.byteBuddy.m_9236_();
        BlockPos itemPos = BlockPos.m_274561_((double)item.m_20185_(), (double)item.m_20186_(), (double)item.m_20189_());
        Vec3 best = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int[] o : OFFS) {
            Vec3 center;
            double d;
            BlockPos p = itemPos.m_7918_(o[0], 0, o[1]);
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, p) || !((d = (center = new Vec3((double)p.m_123341_() + 0.5, (double)p.m_123342_(), (double)p.m_123343_() + 0.5)).m_82557_(item.m_20182_())) < bestDist)) continue;
            bestDist = d;
            best = center;
        }
        return best;
    }

    private void tryPickup(ItemEntity itemEntity) {
        Level level = this.byteBuddy.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!itemEntity.m_6084_()) {
            this.debugOnce("pickup aborted (target not alive)");
            return;
        }
        ItemStack stack = itemEntity.m_32055_();
        int before = stack.m_41613_();
        ItemStack leftover = InventoryUtil.mergeInto(this.byteBuddy.getMainInv(), stack);
        int taken = before - leftover.m_41613_();
        this.debugOnce("pickup " + BuddyPickUpItemGoal.debugItem(itemEntity) + " before=" + before + " taken=" + taken + " leftover=" + leftover.m_41613_());
        if (taken <= 0) {
            return;
        }
        serverLevel.m_7726_().m_8394_((Entity)this.byteBuddy, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.m_19879_(), this.byteBuddy.m_19879_(), taken));
        serverLevel.m_6263_(null, this.byteBuddy.m_20185_(), this.byteBuddy.m_20186_(), this.byteBuddy.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + (this.byteBuddy.m_217043_().m_188501_() - this.byteBuddy.m_217043_().m_188501_()) * 0.4f);
        if (leftover.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(leftover);
        }
        this.byteBuddy.m_21011_(InteractionHand.MAIN_HAND, true);
    }

    private void debugEvery(String message) {
    }

    private void debugOnce(String message) {
    }

    private static String debugItem(ItemEntity itemEntity) {
        ItemStack s = itemEntity.m_32055_();
        return "Item{" + s.m_41611_().getString() + " x" + s.m_41613_() + " @" + String.format("%.1f,%.1f,%.1f", itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_()) + "}";
    }

    private static String debugPos(double x, double y, double z) {
        return String.format("(%.2f, %.2f, %.2f)", x, y, z);
    }

    private static String debugItemPos(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return BuddyPickUpItemGoal.debugItem(itemEntity);
        }
        return "Entity@" + String.format("(%.2f, %.2f, %.2f)", entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }
}

