/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class BuddyFollowOwnerGoal
extends Goal {
    public static final int teleportDistance = 32;
    private static final int minHorizontalDistance = 2;
    private static final int maxVerticalScan = 2;
    private final ByteBuddyEntity byteBuddy;
    private LivingEntity owner;
    private final LevelReader level;
    private final PathNavigation navigation;
    private final double speed;
    private final float startDist;
    private final float stopDist;
    private final boolean canFly;
    private final boolean teleportIfStuck;
    private int timeToRecalculatePath;
    private float oldWaterCost;

    public BuddyFollowOwnerGoal(ByteBuddyEntity byteBuddy, double speed, float startDist, float stopDist, boolean teleportIfStuck) {
        this(byteBuddy, speed, startDist, stopDist, teleportIfStuck, byteBuddy.m_21573_() instanceof FlyingPathNavigation);
    }

    public BuddyFollowOwnerGoal(ByteBuddyEntity byteBuddy, double speed, float startDist, float stopDist, boolean teleportIfStuck, boolean canFly) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.startDist = startDist;
        this.stopDist = stopDist;
        this.teleportIfStuck = teleportIfStuck;
        this.canFly = canFly;
        this.level = byteBuddy.m_9236_();
        this.navigation = byteBuddy.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(this.navigation instanceof GroundPathNavigation) && !(this.navigation instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported travel type for BuddyFollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        ServerLevel serverLevel = this.levelAsServer(this.byteBuddy);
        if (serverLevel == null) {
            return false;
        }
        ServerPlayer owner = this.byteBuddy.getOwner(serverLevel);
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (owner.m_9236_() != this.byteBuddy.m_9236_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.byteBuddy.m_20280_((Entity)owner) < (double)(this.startDist * this.startDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.owner == null || !this.owner.m_6084_()) {
            return false;
        }
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.owner.m_9236_() != this.byteBuddy.m_9236_()) {
            return false;
        }
        return !(this.byteBuddy.m_20280_((Entity)this.owner) <= (double)(this.stopDist * this.stopDist));
    }

    private boolean unableToMove() {
        if (this.byteBuddy.getDock().isPresent()) {
            return true;
        }
        if (this.byteBuddy.m_20159_()) {
            return true;
        }
        if (this.byteBuddy.m_21523_()) {
            return true;
        }
        return this.byteBuddy.m_5803_();
    }

    public void m_8056_() {
        this.timeToRecalculatePath = 0;
        this.oldWaterCost = this.byteBuddy.m_21439_(BlockPathTypes.WATER);
        this.byteBuddy.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.byteBuddy.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        if (this.owner.m_9236_() != this.byteBuddy.m_9236_()) {
            return;
        }
        this.byteBuddy.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.byteBuddy.m_8132_());
        if (--this.timeToRecalculatePath > 0) {
            return;
        }
        this.timeToRecalculatePath = this.m_183277_(10);
        double distSq = this.byteBuddy.m_20280_((Entity)this.owner);
        if (this.teleportIfStuck && distSq >= 1024.0) {
            if (this.tryTeleportNearOwner(this.owner, 2, 16)) {
                this.navigation.m_26573_();
                return;
            }
            this.navigation.m_5624_((Entity)this.owner, this.speed);
        } else {
            this.navigation.m_5624_((Entity)this.owner, this.speed);
        }
    }

    private boolean tryTeleportNearOwner(LivingEntity owner, int minRadius, int maxRadius) {
        int tries = 12;
        double ownerX = owner.m_20185_();
        double ownerY = owner.m_20186_();
        double ownerZ = owner.m_20189_();
        for (int i = 0; i < 12; ++i) {
            BlockPos basePos;
            BlockPos safePos;
            double angle = Math.PI * 2 * (double)i / 12.0;
            int radius = minRadius + this.byteBuddy.m_217043_().m_188503_(Math.max(1, maxRadius - minRadius + 1));
            int dx = (int)Math.round(Math.cos(angle) * (double)radius);
            int dz = (int)Math.round(Math.sin(angle) * (double)radius);
            int px = (int)Math.floor(ownerX) + dx;
            int pz = (int)Math.floor(ownerZ) + dz;
            if (Math.abs((double)px - owner.m_20185_()) < 2.0 && Math.abs((double)pz - owner.m_20189_()) < 2.0 || (safePos = this.findStandableColumnNear(basePos = new BlockPos(px, (int)Math.floor(ownerY), pz), 2)) == null || !this.canTeleportTo(safePos)) continue;
            this.byteBuddy.m_6021_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findStandableColumnNear(BlockPos blockPos, int yScan) {
        for (int dy = -yScan; dy <= yScan; ++dy) {
            BlockPos standPos = blockPos.m_7918_(0, dy, 0);
            if (!ByteBuddyEntity.isStandableTerrain(this.byteBuddy.m_9236_(), standPos)) continue;
            return standPos;
        }
        return null;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathType = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState below = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && below.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos offset = pos.m_121996_((Vec3i)this.byteBuddy.m_20183_());
        return this.level.m_45756_((Entity)this.byteBuddy, this.byteBuddy.m_20191_().m_82338_(offset));
    }

    @Nullable
    private ServerLevel levelAsServer(ByteBuddyEntity byteBuddy) {
        ServerLevel serverLevel;
        Level level = byteBuddy.m_9236_();
        return level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
    }
}

