/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.datagen;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import net.turtleboi.bytebuddies.block.ModBlocks;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.turtlecore.datagen.CoreLanguageProvider;

public class ModLanguageProvider
extends CoreLanguageProvider {
    public ModLanguageProvider(PackOutput output) {
        super(output, "bytebuddies");
    }

    protected void addTranslations() {
        this.add("creativetab.bytebuddies.bytebuddies_tab", "ByteBuddies");
        this.addEntityType((Supplier)ModEntities.BYTEBUDDY, "ByteBuddy");
        this.addSimpleNameEffect((Supplier)ModEffects.SUPERCHARGED);
        this.addSimpleNameBlock((Supplier)ModBlocks.BAUXITE_ORE);
        this.addSimpleNameBlock((Supplier)ModBlocks.DEEPSLATE_BAUXITE_ORE);
        this.addSimpleNameBlock((Supplier)ModBlocks.ALUMINUM_BLOCK);
        this.addSimpleNameBlock((Supplier)ModBlocks.STEEL_BLOCK);
        this.addSimpleNameBlock((Supplier)ModBlocks.CHARGED_STEEL_BLOCK);
        this.addSimpleNameBlock((Supplier)ModBlocks.BLUESTONE_ORE);
        this.addSimpleNameBlock((Supplier)ModBlocks.DEEPSLATE_BLUESTONE_ORE);
        this.addSimpleNameBlock((Supplier)ModBlocks.BLUESTONE_BLOCK);
        this.addSimpleNameBlock((Supplier)ModBlocks.DOCKING_STATION);
        this.addSimpleNameBlock((Supplier)ModBlocks.GENERATOR);
        this.addSimpleNameBlock((Supplier)ModBlocks.SOLAR_PANEL);
        this.addItem((Supplier)ModItems.BUSTER_SWORD, "Steel Breaker");
        this.addItem((Supplier)ModItems.TERRABLADE, "World Splitter");
        this.addSimpleItemName((Supplier)ModItems.RAW_BAUXITE);
        this.addSimpleItemName((Supplier)ModItems.ALUMINUM_INGOT);
        this.addSimpleItemName((Supplier)ModItems.ALUMINUM_NUGGET);
        this.addSimpleItemName((Supplier)ModItems.CARBON_ALLOY);
        this.addSimpleItemName((Supplier)ModItems.STEEL_INGOT);
        this.addSimpleItemName((Supplier)ModItems.STEEL_NUGGET);
        this.addSimpleItemName((Supplier)ModItems.CHARGED_STEEL_INGOT);
        this.addSimpleItemName((Supplier)ModItems.CHARGED_STEEL_NUGGET);
        this.addSimpleItemName((Supplier)ModItems.BLUESTONE_DUST);
        this.addSimpleItemName((Supplier)ModItems.COPPER_PLATING);
        this.addSimpleItemName((Supplier)ModItems.IRON_PLATING);
        this.addSimpleItemName((Supplier)ModItems.GOLD_PLATING);
        this.addSimpleItemName((Supplier)ModItems.ALUMINUM_PLATING);
        this.addSimpleItemName((Supplier)ModItems.STEEL_PLATING);
        this.addSimpleItemName((Supplier)ModItems.CHARGED_STEEL_PLATING);
        this.addSimpleItemName((Supplier)ModItems.CARBON_PASTE);
        this.addSimpleItemName((Supplier)ModItems.SIMPLE_BATTERY);
        this.addSimpleItemName((Supplier)ModItems.ADVANCED_BATTERY);
        this.addSimpleItemName((Supplier)ModItems.BIOCELL_BATTERY);
        this.addSimpleItemName((Supplier)ModItems.REINFORCED_BATTERY);
        this.addSimpleItemName((Supplier)ModItems.SUPER_CHARGED_BATTERY);
        this.addSimpleItemName((Supplier)ModItems.CHIP);
        this.addSimpleItemName((Supplier)ModItems.SUPER_CHIP);
        this.addSimpleItemName((Supplier)ModItems.WRENCH);
        this.addSimpleItemName((Supplier)ModItems.CLIPBOARD);
        this.addSimpleItemName((Supplier)ModItems.PROPELLER_UNIT);
        this.addSimpleItemName((Supplier)ModItems.AQUATIC_MOTOR);
        this.addSimpleItemName((Supplier)ModItems.SOLAR_ARRAY);
        this.addSimpleItemName((Supplier)ModItems.GYROSCOPIC_STABILIZER);
        this.addSimpleItemName((Supplier)ModItems.ARC_WELDER);
        this.addSimpleItemName((Supplier)ModItems.GEOTHERMAL_REGULATOR);
        this.addSimpleItemName((Supplier)ModItems.DYNAMO_COIL);
        this.addSimpleItemName((Supplier)ModItems.MAGNETIC_CRESCENT);
        this.addSimpleItemName((Supplier)ModItems.BASIC_STORAGE_CELL);
        this.addSimpleItemName((Supplier)ModItems.ADVANCED_STORAGE_CELL);
        this.addSimpleItemName((Supplier)ModItems.ENDERLINK_STORAGE_CELL);
        this.addSimpleItemName((Supplier)ModItems.REINFORCED_IRON_PLATING);
        this.addSimpleItemName((Supplier)ModItems.REINFORCED_STEEL_PLATING);
        this.addSimpleItemName((Supplier)ModItems.REINFORCED_NETHERITE_PLATING);
        this.addSimpleItemName((Supplier)ModItems.REINFORCED_CHARGED_STEEL_PLATING);
        this.add((Item)ModItems.BYTEBUDDY_SPAWN_EGG.get(), "ByteBuddy");
        ModItems.FLOPPY_DISKS.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            RegistryObject item = (RegistryObject)entry.getValue();
            String path = item.getId().m_135815_();
            String display = ModLanguageProvider.floppyDisplayName(path).orElseGet(() -> ModLanguageProvider.toName((String)path));
            this.add("item.bytebuddies." + path, display);
        });
        this.add("tooltip.bytebuddies.floppy.tier_line", "Tier: %s");
        this.add("tooltip.bytebuddies.floppy_tier.copper", "Copper");
        this.add("tooltip.bytebuddies.floppy_tier.iron", "Iron");
        this.add("tooltip.bytebuddies.floppy_tier.gold", "Gold");
        this.add("tooltip.bytebuddies.floppy.desc.black", "Reduces tool wear and increases bot's durability (Health)");
        this.add("tooltip.bytebuddies.floppy.desc.blue", "Expands sensing and action radius around the bot\u2019s station or active job.");
        this.add("tooltip.bytebuddies.floppy.desc.cyan", "On a successful action, there\u2019s a chance to spawn a short-lived hologram that performs parallel tasks");
        this.add("tooltip.bytebuddies.floppy.desc.green", "Reduces battery drain and consumable use where applicable.");
        this.add("tooltip.bytebuddies.floppy.desc.pink", "Supportive aura that buffs nearby allies and tasks.");
        this.add("tooltip.bytebuddies.floppy.desc.purple", "Improves yield from actions the bot performs.");
        this.add("tooltip.bytebuddies.floppy.desc.red", "Overclock for more power and speed at a higher energy cost.");
        this.add("tooltip.bytebuddies.floppy.desc.yellow", "When a task succeeds, roll for a byproduct tied to that task\u2019s context");
    }

    private static Optional<String> floppyDisplayName(String registryPath) {
        if (!registryPath.endsWith("_floppy")) {
            return Optional.empty();
        }
        String stem = registryPath.substring(0, registryPath.length() - "_floppy".length());
        int ix = stem.indexOf(95);
        if (ix <= 0 || ix >= stem.length() - 1) {
            return Optional.empty();
        }
        String color = stem.substring(ix + 1);
        return Optional.of(ModLanguageProvider.capitalize(color) + " Floppy Disk");
    }

    private static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }
}

