/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.bytebuddies.datagen.ModBlockLootTableProvider;
import net.turtleboi.bytebuddies.datagen.ModBlockStateProvider;
import net.turtleboi.bytebuddies.datagen.ModBlockTagProvider;
import net.turtleboi.bytebuddies.datagen.ModDataPackProvider;
import net.turtleboi.bytebuddies.datagen.ModGlobalLootModifierProvider;
import net.turtleboi.bytebuddies.datagen.ModItemModelProvider;
import net.turtleboi.bytebuddies.datagen.ModItemTagProvider;
import net.turtleboi.bytebuddies.datagen.ModLanguageProvider;
import net.turtleboi.bytebuddies.datagen.ModRecipeProvider;

@Mod.EventBusSubscriber(modid="bytebuddies", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLanguageProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataPackProvider(packOutput, lookupProvider));
    }
}

