/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public final class HueShiftTextureCache {
    private final ResourceLocation originalTexture;
    private final Map<Integer, ResourceLocation> cachedLocation = new HashMap<Integer, ResourceLocation>();
    private final List<Rect> recolorRegions;
    private final String keyPrefix;

    public HueShiftTextureCache(ResourceLocation originalTexture, String keyPrefix, List<Rect> recolorRegions) {
        this.originalTexture = originalTexture;
        this.keyPrefix = keyPrefix;
        this.recolorRegions = recolorRegions;
    }

    public ResourceLocation getOrCreate(int targetRGB) {
        return this.cachedLocation.computeIfAbsent(targetRGB, this::hueShift);
    }

    private ResourceLocation hueShift(int targetRGB) {
        NativeImage baseTexture;
        Minecraft minecraft = Minecraft.m_91087_();
        try (InputStream inputLocation = minecraft.m_91098_().m_215595_(this.originalTexture);){
            baseTexture = NativeImage.m_85058_((InputStream)inputLocation);
        }
        catch (IOException ioException) {
            return this.originalTexture;
        }
        if (baseTexture.m_84982_() != 64 || baseTexture.m_85084_() != 64) {
            // empty if block
        }
        NativeImage newTexture = new NativeImage(baseTexture.m_85102_(), baseTexture.m_84982_(), baseTexture.m_85084_(), false);
        for (int y = 0; y < baseTexture.m_85084_(); ++y) {
            for (int x = 0; x < baseTexture.m_84982_(); ++x) {
                int abgr = baseTexture.m_84985_(x, y);
                int argb = HueShiftTextureCache.abgrToArgb(abgr);
                int a = argb >>> 24 & 0xFF;
                if (a == 0) {
                    newTexture.m_84988_(x, y, abgr);
                    continue;
                }
                if (this.recolorRegions.isEmpty() || HueShiftTextureCache.inAnyRect(x, y, this.recolorRegions)) {
                    int recoloredARGB = HueShiftTextureCache.hueReplaceARGB(argb, targetRGB);
                    newTexture.m_84988_(x, y, HueShiftTextureCache.argbToAbgr(recoloredARGB));
                    continue;
                }
                newTexture.m_84988_(x, y, abgr);
            }
        }
        DynamicTexture dynamicTexture = new DynamicTexture(newTexture);
        String hexCode = String.format(Locale.ROOT, "%06x", targetRGB & 0xFFFFFF);
        String imagePath = this.keyPrefix + hexCode;
        ResourceLocation resourceLocation = new ResourceLocation(this.originalTexture.m_135827_(), imagePath.toLowerCase(Locale.ROOT));
        minecraft.m_91097_().m_118495_(resourceLocation, (AbstractTexture)dynamicTexture);
        return resourceLocation;
    }

    private static boolean inAnyRect(int x, int y, List<Rect> rectList) {
        for (Rect rect : rectList) {
            if (x < rect.x || x >= rect.x + rect.w || y < rect.y || y >= rect.y + rect.h) continue;
            return true;
        }
        return false;
    }

    private static int hueReplaceARGB(int argb, int targetRGB) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >>> 16 & 0xFF;
        int green = argb >>> 8 & 0xFF;
        int blue = argb & 0xFF;
        int blackThreshold = 1;
        if (red <= blackThreshold && green <= blackThreshold && blue <= blackThreshold) {
            return alpha << 24;
        }
        int targetRed = targetRGB >>> 16 & 0xFF;
        int targetGreen = targetRGB >>> 8 & 0xFF;
        int targetBlue = targetRGB & 0xFF;
        if (targetRed == 0 && targetGreen == 0 && targetBlue == 0) {
            return alpha << 24;
        }
        boolean targetIsGray = Math.abs(targetRed - targetGreen) <= 1 && Math.abs(targetGreen - targetBlue) <= 1;
        float[] sourceHsv = HueShiftTextureCache.rgbToHsv(red, green, blue);
        float sourceSaturation = sourceHsv[1];
        float sourceValue = sourceHsv[2];
        if (targetIsGray) {
            float targetValue = (float)Math.max(targetRed, Math.max(targetGreen, targetBlue)) / 255.0f;
            float outputValue = HueShiftTextureCache.clamp(sourceValue * targetValue);
            int outputRgb = HueShiftTextureCache.hsvToRgb(0.0f, 0.0f, outputValue);
            return alpha << 24 | outputRgb;
        }
        float[] targetHsv = HueShiftTextureCache.rgbToHsv(targetRed, targetGreen, targetBlue);
        float outputHue = targetHsv[0];
        int outputRgb = HueShiftTextureCache.hsvToRgb(outputHue, sourceSaturation, sourceValue);
        return alpha << 24 | outputRgb;
    }

    private static float clamp(float x) {
        return x < 0.0f ? 0.0f : Math.min(x, 1.0f);
    }

    private static float[] rgbToHsv(int red, int green, int blue) {
        float minimum;
        float redFloat = (float)red / 255.0f;
        float greenFloat = (float)green / 255.0f;
        float blueFloat = (float)blue / 255.0f;
        float maximum = Math.max(redFloat, Math.max(greenFloat, blueFloat));
        float delta = maximum - (minimum = Math.min(redFloat, Math.min(greenFloat, blueFloat)));
        float hue = delta == 0.0f ? 0.0f : (maximum == redFloat ? (greenFloat - blueFloat) / delta % 6.0f : (maximum == greenFloat ? (blueFloat - redFloat) / delta + 2.0f : (redFloat - greenFloat) / delta + 4.0f));
        if ((hue /= 6.0f) < 0.0f) {
            hue += 1.0f;
        }
        float saturation = maximum == 0.0f ? 0.0f : delta / maximum;
        return new float[]{hue, saturation, maximum};
    }

    private static int hsvToRgb(float hue, float saturation, float value) {
        float chroma = value * saturation;
        float xComponent = chroma * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
        float match = value - chroma;
        float redPrime = 0.0f;
        float greenPrime = 0.0f;
        float bluePrime = 0.0f;
        float hueSector = hue * 6.0f;
        if (hueSector < 1.0f) {
            redPrime = chroma;
            greenPrime = xComponent;
        } else if (hueSector < 2.0f) {
            redPrime = xComponent;
            greenPrime = chroma;
        } else if (hueSector < 3.0f) {
            greenPrime = chroma;
            bluePrime = xComponent;
        } else if (hueSector < 4.0f) {
            greenPrime = xComponent;
            bluePrime = chroma;
        } else if (hueSector < 5.0f) {
            redPrime = xComponent;
            bluePrime = chroma;
        } else {
            redPrime = chroma;
            bluePrime = xComponent;
        }
        int redOut = Math.round((redPrime + match) * 255.0f);
        int greenOut = Math.round((greenPrime + match) * 255.0f);
        int blueOut = Math.round((bluePrime + match) * 255.0f);
        return redOut << 16 | greenOut << 8 | blueOut;
    }

    static int abgrToArgb(int abgr) {
        int alpha = abgr >>> 24 & 0xFF;
        int blue = abgr >>> 16 & 0xFF;
        int green = abgr >>> 8 & 0xFF;
        int red = abgr & 0xFF;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    static int argbToAbgr(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >>> 16 & 0xFF;
        int green = argb >>> 8 & 0xFF;
        int blue = argb & 0xFF;
        return alpha << 24 | blue << 16 | green << 8 | red;
    }

    public record Rect(int x, int y, int w, int h) {
    }
}

