/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.entity;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BlockEntity
implements IEnergyStorage,
MenuProvider {
    private int progress = 0;
    private int maxProgress = 0;
    private final EnergyStorage energyStorage = new EnergyStorage(48000, 640, 640);
    private final ItemStackHandler fuelSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            return AbstractFurnaceBlockEntity.m_58399_((ItemStack)itemStack);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.m_6596_();
            if (!GeneratorBlockEntity.this.f_58857_.m_5776_()) {
                GeneratorBlockEntity.this.f_58857_.m_7260_(GeneratorBlockEntity.this.m_58899_(), GeneratorBlockEntity.this.m_58900_(), GeneratorBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final ItemStackHandler batterySlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            return InventoryUtil.isBattery(itemStack);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.m_6596_();
            if (!GeneratorBlockEntity.this.f_58857_.m_5776_()) {
                GeneratorBlockEntity.this.f_58857_.m_7260_(GeneratorBlockEntity.this.m_58899_(), GeneratorBlockEntity.this.m_58900_(), GeneratorBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private int tickCount = 0;
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(this::getEnergyStorage);

    public GeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GENERATOR_BE.get(), pos, blockState);
    }

    public Component m_5446_() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level == null || level.f_46443_) {
            return;
        }
        ItemStack fuelItemStack = this.getFuelSlot().getStackInSlot(0);
        if (!fuelItemStack.m_41619_() && this.progress <= 0 && this.maxProgress == 0) {
            int burnTime = ForgeHooks.getBurnTime((ItemStack)fuelItemStack, (RecipeType)RecipeType.f_44108_);
            if (burnTime > 0) {
                this.maxProgress = burnTime;
                this.progress = 1;
                fuelItemStack.m_41774_(1);
                GeneratorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        } else if (this.progress > 0 && this.progress < this.maxProgress) {
            ++this.progress;
            this.generateEnergy(16);
            GeneratorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        } else if (this.progress >= this.maxProgress && this.maxProgress > 0) {
            this.resetProgress();
            GeneratorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        ++this.tickCount;
        if (this.tickCount % 20 == 0) {
            this.pushEnergyToNeighbors();
            this.giveBatteryEnergy();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.m_6596_();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.batterySlot.getSlots());
        for (int i = 0; i < this.batterySlot.getSlots(); ++i) {
            inventory.m_6836_(i, this.batterySlot.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public ItemStackHandler getBatterySlot() {
        return this.batterySlot;
    }

    public ItemStackHandler getFuelSlot() {
        return this.fuelSlot;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.m_14045_((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void m_183515_(CompoundTag nbtData) {
        super.m_183515_(nbtData);
        nbtData.m_128405_("progress", this.progress);
        nbtData.m_128405_("maxProgress", this.maxProgress);
        nbtData.m_128365_("BatterySlot", (Tag)this.batterySlot.serializeNBT());
        nbtData.m_128365_("FuelSlot", (Tag)this.fuelSlot.serializeNBT());
        nbtData.m_128405_("Energy", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag nbtData) {
        super.m_142466_(nbtData);
        this.progress = nbtData.m_128451_("progress");
        this.maxProgress = nbtData.m_128451_("maxProgress");
        if (nbtData.m_128441_("BatterySlot")) {
            this.batterySlot.deserializeNBT(nbtData.m_128469_("BatterySlot"));
        }
        if (nbtData.m_128441_("FuelSlot")) {
            this.fuelSlot.deserializeNBT(nbtData.m_128469_("FuelSlot"));
        }
        if (nbtData.m_128441_("Energy")) {
            this.setEnergyUnsafe(nbtData.m_128451_("Energy"));
        }
        this.m_6596_();
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public int generateEnergy(int energyGenerated) {
        int maxEnergy;
        int energyStored = this.energyStorage.getEnergyStored();
        if (energyStored < (maxEnergy = this.energyStorage.getMaxEnergyStored())) {
            int potentialEnergy = maxEnergy - energyStored;
            int energyActuallyGenerated = Math.min(potentialEnergy, Math.max(0, energyGenerated));
            int receivedEnergy = this.energyStorage.receiveEnergy(energyActuallyGenerated, false);
            if (receivedEnergy > 0) {
                this.m_6596_();
            }
            return receivedEnergy;
        }
        return 0;
    }

    public int giveBatteryEnergy() {
        Item item;
        int energyMoved = 0;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return 0;
        }
        IEnergyStorage energySource = this.getEnergyStorage();
        ItemStack batteryInSlot = this.getBatterySlot().getStackInSlot(0);
        if (energySource != null && energySource.getEnergyStored() > 0 && !batteryInSlot.m_41619_() && (item = batteryInSlot.m_41720_()) instanceof BatteryItem) {
            int energyDrained;
            int acceptedEnergy;
            int canExtract;
            BatteryItem batteryItem = (BatteryItem)item;
            int missingEnergy = batteryItem.getCapacity() - batteryItem.getEnergy(batteryInSlot);
            int requestedEnergy = Math.min(missingEnergy, batteryItem.getIoRate());
            if (missingEnergy > 0 && requestedEnergy > 0 && (canExtract = energySource.extractEnergy(requestedEnergy, true)) > 0 && (acceptedEnergy = batteryItem.receive(batteryInSlot, canExtract, false)) > 0 && (energyDrained = energySource.extractEnergy(acceptedEnergy, false)) > 0) {
                energyMoved = energyDrained;
                this.m_6596_();
            }
        }
        return energyMoved;
    }

    private void pushEnergyToNeighbors() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity neighborBlockEntity;
            if (this.energyStorage.getEnergyStored() <= 0) break;
            BlockPos neighborPos = this.f_58858_.m_121945_(direction);
            if (this.f_58857_.m_8055_(neighborPos).m_204336_(ModTags.Blocks.GENERATORS) || (neighborBlockEntity = this.f_58857_.m_7702_(neighborPos)) == null) continue;
            neighborBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(neighbor -> {
                if (!neighbor.canReceive()) {
                    return;
                }
                int canExtract = this.energyStorage.extractEnergy(640, true);
                if (canExtract <= 0) {
                    return;
                }
                int accepted = neighbor.receiveEnergy(canExtract, false);
                if (accepted <= 0) {
                    return;
                }
                this.energyStorage.extractEnergy(accepted, false);
                this.m_6596_();
            });
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }
}

