/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.screen.custom.menu.DockingStationMenu;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockingStationBlockEntity
extends BlockEntity
implements IEnergyStorage,
MenuProvider {
    public final int mainInvSize = 27;
    public static final int batterySlot = 0;
    public static final int clipboardSlot = 1;
    public final int totalInvSize = 29;
    private final ItemStackHandler mainInv = new ItemStackHandler(29){

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (slot == 0) {
                return InventoryUtil.isBattery(itemStack);
            }
            if (slot == 1) {
                return itemStack.m_41720_() instanceof ClipboardItem;
            }
            return true;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            if (slot == 0 || slot == 1) {
                return 1;
            }
            return 64;
        }

        protected void onContentsChanged(int slot) {
            DockingStationBlockEntity.this.m_6596_();
            if (DockingStationBlockEntity.this.f_58857_ != null && !((DockingStationBlockEntity)DockingStationBlockEntity.this).f_58857_.f_46443_) {
                DockingStationBlockEntity.this.f_58857_.m_7260_(DockingStationBlockEntity.this.m_58899_(), DockingStationBlockEntity.this.m_58900_(), DockingStationBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final Set<UUID> boundBuddies = new HashSet<UUID>();
    public int dockBaseRadius = 4;
    private final EnergyStorage energyStorage = new EnergyStorage(48000, 640, 640);
    private int tickCount = 0;
    private final Map<TaskKey, Reservation> reservations = new HashMap<TaskKey, Reservation>();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::getMainInv);
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(this::getEnergyStorage);

    public DockingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntities.DOCKING_STATION_BE.get(), blockPos, blockState);
    }

    public void addBoundBuddy(ByteBuddyEntity byteBuddy) {
        if (this.boundBuddies.add(byteBuddy.m_20148_())) {
            ByteBuddies.LOGGER.info("[ByteBuddies] dock {} added bot {}", (Object)this.f_58858_, (Object)byteBuddy.m_20148_());
            this.m_6596_();
        }
    }

    public void removeBoundBuddy(ByteBuddyEntity byteBuddy) {
        if (this.boundBuddies.remove(byteBuddy.m_20148_())) {
            ByteBuddies.LOGGER.info("[ByteBuddies] dock {} removed bot {}", (Object)this.f_58858_, (Object)byteBuddy.m_20148_());
            this.m_6596_();
        }
    }

    public Set<UUID> getBoundBuddyUUIDs() {
        return Collections.unmodifiableSet(this.boundBuddies);
    }

    public List<Integer> findByteBuddyEntityIds(ServerLevel serverLevel) {
        ArrayList<Integer> byteBuddyIds = new ArrayList<Integer>();
        for (UUID uuid : this.boundBuddies) {
            Entity entity = serverLevel.m_8791_(uuid);
            if (!(entity instanceof ByteBuddyEntity)) continue;
            ByteBuddyEntity byteBuddy = (ByteBuddyEntity)entity;
            byteBuddyIds.add(byteBuddy.m_19879_());
        }
        return byteBuddyIds;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level != null) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.pruneReservations(serverLevel);
            }
            ++this.tickCount;
            if (this.tickCount % 20 == 0) {
                this.consumeEnergy(this.boundBuddies.size() * 25);
                BatteryItem.dockBlockDrainBatteries(this);
            }
            AABB boundingBox = new AABB(blockPos).m_82400_((double)this.dockBaseRadius);
            for (ByteBuddyEntity byteBuddyEntity : level.m_45976_(ByteBuddyEntity.class, boundingBox)) {
            }
        }
    }

    public ItemStackHandler getMainInv() {
        return this.mainInv;
    }

    public ItemStack getBatteryStack() {
        return this.mainInv.getStackInSlot(0);
    }

    public ItemStack getClipboardStack() {
        return this.mainInv.getStackInSlot(1);
    }

    @Nullable
    public BlockPos getFirstPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getFirstPosition(clipboard).orElse(null);
    }

    @Nullable
    public BlockPos getSecondPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getSecondPosition(clipboard).orElse(null);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.m_14045_((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag dataList = new ListTag();
        for (UUID id : this.boundBuddies) {
            dataList.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        pTag.m_128365_("BoundBots", (Tag)dataList);
        pTag.m_128365_("MainInv", (Tag)this.mainInv.serializeNBT());
        pTag.m_128405_("Energy", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.boundBuddies.clear();
        ListTag dataList = pTag.m_128437_("BoundBots", 8);
        for (int i = 0; i < dataList.size(); ++i) {
            this.boundBuddies.add(UUID.fromString(dataList.m_128778_(i)));
        }
        if (pTag.m_128441_("MainInv")) {
            this.mainInv.deserializeNBT(pTag.m_128469_("MainInv"));
        }
        this.m_6596_();
        if (pTag.m_128441_("Energy")) {
            this.setEnergyUnsafe(pTag.m_128451_("Energy"));
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.bytebuddies.docking_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new DockingStationMenu(containerId, playerInventory, this);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.mainInv.getSlots());
        for (int i = 0; i < this.mainInv.getSlots(); ++i) {
            inventory.m_6836_(i, this.mainInv.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private static long currentTime(ServerLevel serverLevel) {
        return serverLevel.m_46467_();
    }

    private static long reservationTime(long time, int ticks) {
        return time + (long)ticks;
    }

    public void pruneReservations(ServerLevel serverLevel) {
        long time = DockingStationBlockEntity.currentTime(serverLevel);
        this.reservations.entrySet().removeIf(entry -> ((Reservation)entry.getValue()).expiresAt <= time);
    }

    public boolean isReserved(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
        this.pruneReservations(serverLevel);
        return this.reservations.containsKey(new TaskKey(taskType, blockPos));
    }

    public boolean isReservedBy(ServerLevel serverLevel, ByteBuddyEntity.TaskType task, BlockPos blockPos, UUID buddyId) {
        this.pruneReservations(serverLevel);
        Reservation reservation = this.reservations.get(new TaskKey(task, blockPos));
        return reservation != null && reservation.buddyId.equals(buddyId);
    }

    public boolean tryClaim(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId, int reservationTicks) {
        this.pruneReservations(serverLevel);
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && !reservation.buddyId.equals(buddyId)) {
            return false;
        }
        this.reservations.put(taskKey, new Reservation(buddyId, DockingStationBlockEntity.reservationTime(DockingStationBlockEntity.currentTime(serverLevel), reservationTicks)));
        return true;
    }

    public void renewClaim(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId, int reservationTicks) {
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && reservation.buddyId.equals(buddyId)) {
            reservation.expiresAt = DockingStationBlockEntity.reservationTime(DockingStationBlockEntity.currentTime(serverLevel), reservationTicks);
        }
    }

    public void releaseClaim(ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId) {
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && reservation.buddyId.equals(buddyId)) {
            this.reservations.remove(taskKey);
        }
    }

    public void releaseAllFor(UUID buddyId) {
        this.reservations.entrySet().removeIf(e -> ((Reservation)e.getValue()).buddyId.equals(buddyId));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public boolean consumeEnergy(int energyCost) {
        if (this.energyStorage.getEnergyStored() >= energyCost) {
            this.energyStorage.extractEnergy(energyCost, false);
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
    }

    private record TaskKey(ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
    }

    private static final class Reservation {
        final UUID buddyId;
        long expiresAt;

        Reservation(UUID buddyId, long expiresAt) {
            this.buddyId = buddyId;
            this.expiresAt = expiresAt;
        }
    }
}

