/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BluestoneOreBlock
extends Block {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    public static final Vector3f BLUESTONE_PARTICLE_COLOR = Vec3.m_82501_((int)3127497).m_252839_();
    public static final DustParticleOptions BLUESTONE = new DustParticleOptions(BLUESTONE_PARTICLE_COLOR, 1.0f);

    public BluestoneOreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BluestoneOreBlock.interact(state, level, pos);
        super.m_6256_(state, level, pos, player);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_20161_()) {
            BluestoneOreBlock.interact(state, level, pos);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            BluestoneOreBlock.spawnParticles(pLevel, pPos);
        } else {
            BluestoneOreBlock.interact(pState, pLevel, pPos);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private static void interact(BlockState state, Level level, BlockPos pos) {
        BluestoneOreBlock.spawnParticles(level, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.m_213646_(state, level, pos, stack, dropExperience);
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return UniformInt.m_146622_((int)1, (int)5).m_214085_(randomSource);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            BluestoneOreBlock.spawnParticles(level, pos);
        }
    }

    private static void spawnParticles(Level level, BlockPos pos) {
        double d0 = 0.5625;
        RandomSource randomsource = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomsource.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomsource.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomsource.m_188501_();
            level.m_7106_((ParticleOptions)BLUESTONE, (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }
}

