/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.turtleboi.bytebuddies.block.custom.BluestoneOreBlock;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.custom.GeneratorBlock;
import net.turtleboi.bytebuddies.block.custom.SolarPanelBlock;
import net.turtleboi.bytebuddies.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"bytebuddies");
    public static final RegistryObject<Block> BAUXITE_ORE = ModBlocks.registerBlock("bauxite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistryObject<Block> DEEPSLATE_BAUXITE_ORE = ModBlocks.registerBlock("deepslate_bauxite_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistryObject<Block> ALUMINUM_BLOCK = ModBlocks.registerBlock("aluminum_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> STEEL_BLOCK = ModBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> CHARGED_STEEL_BLOCK = ModBlocks.registerBlock("charged_steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> BLUESTONE_ORE = ModBlocks.registerBlock("bluestone_ore", () -> new BluestoneOreBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60977_().m_60953_(ModBlocks.litBlockEmission(9)).m_60913_(3.0f, 3.0f)));
    public static final RegistryObject<Block> DEEPSLATE_BLUESTONE_ORE = ModBlocks.registerBlock("deepslate_bluestone_ore", () -> new BluestoneOreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BLUESTONE_ORE.get())).m_284180_(MapColor.f_283875_).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> BLUESTONE_BLOCK = ModBlocks.registerBlock("bluestone_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50330_)));
    public static final RegistryObject<Block> DOCKING_STATION = ModBlocks.registerBlock("docking_station", () -> new DockingStationBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> GENERATOR = ModBlocks.registerBlock("generator", () -> new GeneratorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> SOLAR_PANEL = ModBlocks.registerBlock("solar_panel", () -> new SolarPanelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }
}

