/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;

public class RegionChunkCounter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long countSimple(Path file) {
        if (Files.notExists(file, new LinkOption[0])) {
            return 0L;
        }
        try (FileChannel stream = FileChannel.open(file, StandardOpenOption.READ);){
            ByteBuffer header = ByteBuffer.allocate(4096);
            if (stream.read(header) != 4096) {
                long l2 = 0L;
                return l2;
            }
            header.flip();
            IntBuffer offsets = header.asIntBuffer();
            int count = 0;
            for (int k = 0; k < 1024; ++k) {
                int l3 = offsets.get(k);
                if (l3 == 0) continue;
                int sector = l3 >> 8 & 0xFFFFFF;
                int metadata = l3 & 0xFF;
                if (sector < 2 || metadata == 0) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long[] countChunks(Path file, Path folder, LongList chunks) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return new long[2];
        }
        try (FileChannel stream = FileChannel.open(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            ByteBuffer header = ByteBuffer.allocate(8192);
            IntBuffer offsets = header.asIntBuffer();
            offsets.limit(1024);
            int result = stream.read(header);
            if (result != 8192) {
                long[] lArray2 = new long[2];
                return lArray2;
            }
            long j = Files.size(file);
            IntArrayList list = new IntArrayList();
            for (int k = 0; k < 1024; ++k) {
                int l = offsets.get(k);
                if (l == 0) continue;
                int sector = l >> 8 & 0xFFFFFF;
                int metadata = l & 0xFF;
                if (sector < 2 || metadata == 0) {
                    offsets.put(k, 0);
                    continue;
                }
                if ((long)sector * 4096L > j) {
                    offsets.put(k, 0);
                    continue;
                }
                list.add(sector);
            }
            long[] output = new long[2];
            ByteBuffer data = ByteBuffer.allocate(5);
            for (int i = 0; i < 1024; ++i) {
                int totalSize;
                int offset = offsets.get(i);
                if (offset == 0) continue;
                int sector = offset >> 8 & 0xFFFFFF;
                int sectorCount = offset & 0xFF;
                stream.read(data, (long)sector * 4096L);
                data.flip();
                if (data.remaining() != 5) {
                    data.clear();
                    continue;
                }
                int length = data.getInt();
                byte metadata = data.get();
                if ((metadata & 0x80) != 0) {
                    if (!RegionFileVersion.m_63764_((int)(metadata & 0xFFFFFF7F))) {
                        data.clear();
                        continue;
                    }
                    Path extendedChunk = folder.resolve("c." + i / 32 + "." + i % 32 + ".mcc");
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        long count = Files.size(extendedChunk);
                        output[0] = output[0] + count;
                        output[1] = output[1] + 1L;
                        if (chunks != null) {
                            chunks.add(count);
                        }
                    }
                    data.clear();
                    continue;
                }
                if (RegionFileVersion.m_63764_((int)metadata) && length != 0 && (totalSize = length - 1) >= 0 && totalSize <= sectorCount * 4096) {
                    output[0] = output[0] + (long)totalSize;
                    output[1] = output[1] + 1L;
                    if (chunks != null) {
                        chunks.add((long)totalSize);
                    }
                }
                data.clear();
            }
            long[] lArray = output;
            return lArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new long[2];
        }
    }
}

