/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;

public class DeltaTimer {
    LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    long total = 0L;
    long start = 0L;
    long last = 0L;
    int limit;

    public DeltaTimer() {
        this(200);
    }

    public DeltaTimer(int limit) {
        this.limit = limit;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void finish() {
        long delta = System.currentTimeMillis() - this.start;
        this.total += delta;
        this.queue.enqueue(delta);
        if (this.queue.size() > this.limit) {
            this.total -= this.queue.dequeueLong();
        }
        this.last = delta;
    }

    public void reset() {
        this.total = 0L;
        this.queue.clear();
    }

    public long getDeltaTime() {
        return System.currentTimeMillis() - this.start;
    }

    public long getLastValue() {
        return this.last;
    }

    public long getAverage() {
        return this.queue.isEmpty() ? 0L : this.total / (long)this.queue.size();
    }
}

