/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;

public class AverageCounter {
    IntPriorityQueue allValues = new IntArrayFIFOQueue();
    int limit;
    int count = 0;
    int average = 0;
    int last;

    public AverageCounter(int limit) {
        this.limit = limit;
    }

    public void addOne() {
        ++this.count;
    }

    public void addMore(int amount) {
        this.count += amount;
    }

    public void onFinished() {
        this.allValues.enqueue(this.count);
        this.average += this.count;
        this.last = this.count;
        this.count = 0;
        if (this.allValues.size() > this.limit) {
            this.average -= this.allValues.dequeueInt();
        }
    }

    public int getAverage() {
        return this.allValues.isEmpty() ? 0 : this.average / this.allValues.size();
    }

    public int getLast() {
        return this.last;
    }

    public void clear() {
        this.allValues.clear();
        this.count = 0;
        this.average = 0;
        this.last = 0;
    }
}

