/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.utils.config.api.ConfigType;
import pregenerator.common.utils.config.gui.api.BackgroundTexture;
import pregenerator.common.utils.config.gui.api.IModConfig;
import pregenerator.common.utils.config.gui.screen.ConfigScreen;
import pregenerator.common.utils.config.gui.screen.RequestScreen;

public class ConfigFeatures {
    @OnlyIn(value=Dist.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, String ... path) {
        ConfigFeatures.openRemoteConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ConfigFeatures.openLocalConfigFolder(config, texture, path);
            return;
        }
        if (config.getConfigType() == ConfigType.CLIENT) {
            ChunkPregenerator.LOGGER.info("Tried to open a local config in the Remote Opener");
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config when there was no remote attached");
            return;
        }
        if (!mc.m_91091_() && !mc.f_91074_.m_20310_(4)) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config without permission");
            return;
        }
        mc.m_91152_((Screen)new RequestScreen(texture.asHolder(), ConfigScreen.Navigator.create(config).withWalker(path), mc.f_91080_, config));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, String ... path) {
        ConfigFeatures.openLocalConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        if (!config.isLocalConfig()) {
            ChunkPregenerator.LOGGER.info("Tried to open a Remote config in the Local Opener");
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ConfigScreen(ConfigScreen.Navigator.create(config).withWalker(path), config, mc.f_91080_, texture.asHolder()));
    }
}

