/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.impl.internal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraftforge.fml.ModContainer;
import pregenerator.common.utils.config.api.ConfigType;
import pregenerator.common.utils.config.gui.api.BackgroundTexture;
import pregenerator.common.utils.config.gui.api.IModConfig;
import pregenerator.common.utils.config.gui.api.IModConfigs;

public class ModConfigList
implements IModConfigs {
    ModContainer container;
    List<IModConfigs> configs;

    public ModConfigList(ModContainer container, List<IModConfigs> configs) {
        this.container = container;
        this.configs = configs;
    }

    public static IModConfigs createMultiIfApplicable(ModContainer container, List<IModConfigs> configs) {
        return configs.size() == 1 ? configs.get(0) : new ModConfigList(container, configs);
    }

    @Override
    public String getModName() {
        return this.container.getModInfo().getDisplayName();
    }

    @Override
    public List<IModConfig> getConfigInstances(ConfigType type) {
        ObjectArrayList configs = new ObjectArrayList();
        for (IModConfigs config : this.configs) {
            configs.addAll(config.getConfigInstances(type));
        }
        return configs;
    }

    @Override
    public BackgroundTexture.BackgroundHolder getBackground() {
        for (IModConfigs config : this.configs) {
            BackgroundTexture.BackgroundHolder texture = config.getBackground();
            if (texture.getTexture() == BackgroundTexture.DEFAULT) continue;
            return texture;
        }
        return BackgroundTexture.DEFAULT.asHolder();
    }
}

