/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.gui.screen;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.ModList;
import pregenerator.common.utils.config.gui.api.BackgroundTexture;
import pregenerator.common.utils.config.gui.api.IConfigNode;
import pregenerator.common.utils.config.gui.api.IModConfig;
import pregenerator.common.utils.config.gui.config.ArrayElement;
import pregenerator.common.utils.config.gui.config.CompoundElement;
import pregenerator.common.utils.config.gui.config.ConfigElement;
import pregenerator.common.utils.config.gui.config.Element;
import pregenerator.common.utils.config.gui.config.FolderElement;
import pregenerator.common.utils.config.gui.config.ListScreen;
import pregenerator.common.utils.config.gui.config.SelectionElement;
import pregenerator.common.utils.config.gui.screen.MultiChoiceScreen;
import pregenerator.common.utils.config.gui.widgets.CarbonButton;
import pregenerator.common.utils.config.gui.widgets.CarbonIconCheckbox;
import pregenerator.common.utils.config.gui.widgets.GuiUtils;
import pregenerator.common.utils.config.gui.widgets.Icon;

public class ConfigScreen
extends ListScreen {
    private static final Comparator<Element> SORTER = (K, V) -> {
        int sort = (V instanceof FolderElement ? 1 : 0) - (K instanceof FolderElement ? 1 : 0);
        return sort != 0 ? sort : String.CASE_INSENSITIVE_ORDER.compare(K.getName(), V.getName());
    };
    Screen parent;
    IModConfig config;
    IConfigNode node;
    CarbonIconCheckbox deepSearch;
    CarbonIconCheckbox onlyChanged;
    CarbonIconCheckbox onlyNonDefault;
    boolean wasChanged = false;
    Navigator nav;
    List<Element> cache = null;

    public ConfigScreen(IModConfig config, Screen parent) {
        this(Navigator.create(config), config, parent);
    }

    public ConfigScreen(Navigator nav, IModConfig config, Screen parent) {
        this(nav, config, parent, BackgroundTexture.DEFAULT.asHolder());
    }

    public ConfigScreen(Navigator nav, IModConfig config, Screen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((Component)Component.m_237119_(), customTexture);
        this.nav = nav;
        this.config = config;
        this.node = config.getRootNode();
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    public ConfigScreen(Navigator nav, IConfigNode node, Screen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((Component)Component.m_237119_(), customTexture);
        this.nav = nav;
        this.node = node;
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    @Override
    protected void m_7856_() {
        String walkNode;
        super.m_7856_();
        int x = this.f_96543_ / 2 - 100;
        int y = this.f_96544_;
        if (this.node.isRoot()) {
            this.m_142416_((GuiEventListener)new CarbonButton(x - 51, y - 27, 100, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.save"), this::save));
            this.m_142416_((GuiEventListener)new CarbonButton(x + 51, y - 27, 100, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset"), this::reset));
            this.m_142416_((GuiEventListener)new CarbonButton(x + 153, y - 27, 100, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.back"), this::goBack));
        } else {
            this.m_142416_((GuiEventListener)new CarbonButton(x + 101, y - 27, 100, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.back"), this::goBack));
            this.m_142416_((GuiEventListener)new CarbonButton(x - 1, y - 27, 100, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.home"), this::goToRoot));
        }
        if (this.shouldHaveSearch()) {
            this.deepSearch = (CarbonIconCheckbox)this.m_142416_((GuiEventListener)new CarbonIconCheckbox(x + 205, 25, 20, 20, Icon.SEARCH_SELECTED, Icon.SEARCH, false).withListener(this::onDeepSearch).setTooltip(this, "gui.chunk_pregen.config.deepsearch"));
            this.onlyChanged = (CarbonIconCheckbox)this.m_142416_((GuiEventListener)new CarbonIconCheckbox(x + 227, 25, 20, 20, Icon.SET_DEFAULT, Icon.REVERT, false).withListener(this::onChangedButton).setTooltip(this, "gui.chunk_pregen.config.changed_only"));
            this.onlyNonDefault = (CarbonIconCheckbox)this.m_142416_((GuiEventListener)new CarbonIconCheckbox(x + 249, 25, 20, 20, Icon.NOT_DEFAULT_SELECTED, Icon.NOT_DEFAULT, false).withListener(this::onDefaultButton).setTooltip(this, "gui.chunk_pregen.config.default_only"));
        }
        if ((walkNode = this.nav.getWalkNode()) != null) {
            FolderElement element = this.getElement(walkNode);
            if (element != null) {
                element.onPress(null);
            }
            this.nav.consumeWalker();
        }
    }

    private void onDeepSearch() {
        if (this.onlyChanged.selected() || this.onlyNonDefault.selected()) {
            this.deepSearch.setSelected(false);
        } else {
            this.wasChanged = true;
        }
    }

    private void onChangedButton() {
        this.deepSearch.setSelected(false);
        this.onlyNonDefault.setSelected(false);
    }

    private void onDefaultButton() {
        this.deepSearch.setSelected(false);
        this.onlyChanged.setSelected(false);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.shouldHaveSearch() && (this.onlyChanged.selected() || this.onlyNonDefault.selected() || this.wasChanged)) {
            this.onSearchChange(this.searchBox, this.searchBox.m_94155_().toLowerCase(Locale.ROOT));
            this.wasChanged = this.onlyChanged.selected() || this.onlyNonDefault.selected();
        }
    }

    @Override
    public void handleForground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawScrollingString(graphics, this.f_96547_, this.nav.getHeader(), 50.0f, 6.0f, this.f_96543_ - 100, 10.0f, ConfigElement.GuiAlign.CENTER, -1, 0);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= 50.0 && mouseX <= (double)(this.f_96543_ - 100) && mouseY >= 6.0 && mouseY <= 16.0) {
            float scroll = GuiUtils.calculateScrollOffset(this.f_96543_ - 100, this.f_96547_, ConfigElement.GuiAlign.CENTER, this.nav.getHeader(), 0);
            Screen screen = this.nav.getScreen(this.f_96547_, (int)(mouseX - (double)ConfigElement.GuiAlign.CENTER.align(50, this.f_96543_ - 100, this.f_96547_.m_92852_((FormattedText)this.nav.getHeader())) - (double)scroll));
            if (screen instanceof ConfigScreen) {
                this.f_96541_.m_91152_(screen);
                return true;
            }
            if (screen != null) {
                this.leave();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(SORTER);
        return list;
    }

    private void goToRoot(Button button) {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            this.f_96541_.m_91152_((Screen)prev);
        }
    }

    private void leave() {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            Screen toOpen = prev.parent;
            if (this.node.isRoot() && prev.isChanged()) {
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(T -> this.f_96541_.m_91152_((Screen)(T ? toOpen : this)), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.warn.changed"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.warn.changed.desc").m_130940_(ChatFormatting.GRAY)));
                return;
            }
            this.f_96541_.m_91152_(toOpen);
        }
    }

    private void reset(Button button) {
        this.f_96541_.m_91152_((Screen)new MultiChoiceScreen(T -> {
            if (T.isMain()) {
                this.processAction(IConfigNode::setDefault);
            } else if (T.isOther()) {
                this.processAction(IConfigNode::setPrevious);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset_all.title"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset_all.message").m_130940_(ChatFormatting.GRAY), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset_all.default"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset_all.reset"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reset_all.cancel")));
    }

    private void save(Button button) {
        List<IConfigNode> value = this.processedChanged(IConfigNode::save);
        this.config.save();
        if (this.findFirst(IConfigNode::requiresRestart, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.f_96541_.m_91152_(this.parent), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.restart.title"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.restart.message").m_130940_(ChatFormatting.GRAY), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.ok"));
            this.f_96541_.m_91152_((Screen)choice);
            return;
        }
        if (this.f_96541_.f_91073_ != null && this.findFirst(IConfigNode::requiresReload, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.f_96541_.m_91152_(this.parent), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reload.title"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.reload.message").m_130940_(ChatFormatting.GRAY), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.ok"));
            this.f_96541_.m_91152_((Screen)choice);
            return;
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private <T> boolean findFirst(Predicate<T> filter, List<T> elements) {
        int m = elements.size();
        for (int i = 0; i < m; ++i) {
            if (!filter.test(elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<IConfigNode> processedChanged(Consumer<IConfigNode> action) {
        ObjectArrayList output = new ObjectArrayList();
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            if (!node.isChanged()) continue;
            action.accept(node);
            output.add(node);
        }
        return output;
    }

    private void processAction(Consumer<IConfigNode> action) {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            action.accept(node);
        }
    }

    @Override
    protected void onSearchChange(EditBox box, String value) {
        if (!(this.deepSearch.selected() && !value.isEmpty() || this.onlyChanged.selected() || this.onlyNonDefault.selected())) {
            super.onSearchChange(box, value);
            return;
        }
        if (this.cache == null) {
            this.cache = this.sortElements(ConfigScreen.getAllElements(this.node));
            this.cache.forEach(x$0 -> this.addInternal((Element)((Object)x$0)));
        }
        if (this.onlyNonDefault.selected()) {
            ObjectArrayList subCache = new ObjectArrayList();
            for (Element element : this.cache) {
                if (element.isDefault()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, (List<Element>)subCache);
            return;
        }
        if (this.onlyChanged.selected()) {
            ObjectArrayList subCache = new ObjectArrayList();
            for (Element element : this.cache) {
                if (!element.isChanged()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, (List<Element>)subCache);
            return;
        }
        super.onSearchChange(box, value, this.cache);
    }

    private void goBack(Button button) {
        if (this.node.isRoot() && this.isChanged()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(T -> this.f_96541_.m_91152_((Screen)(T ? this.parent : this)), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.warn.changed"), (Component)Component.m_237115_((String)"gui.chunk_pregen.config.warn.changed.desc").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private boolean isChanged() {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            if (!node.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getListWidth() {
        return 340;
    }

    @Override
    protected int getScrollPadding() {
        return 175;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IConfigNode child : this.node.getChildren()) {
            if (child.isLeaf()) {
                if (child.isArray()) {
                    elements.accept(new ArrayElement(child));
                    continue;
                }
                if (child.getDataType().size() > 1) {
                    elements.accept(new CompoundElement(child));
                    continue;
                }
                if (child.isForcingSuggestions()) {
                    elements.accept(new SelectionElement(child));
                    continue;
                }
                ConfigElement element = child.getDataType().get(0).create(child);
                if (element == null) continue;
                elements.accept(element);
                continue;
            }
            elements.accept(new FolderElement(child, this.nav));
        }
    }

    private static List<Element> getAllElements(IConfigNode init) {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)init);
        ObjectArrayList results = new ObjectArrayList();
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            if (node.isArray()) {
                results.add(new ArrayElement(node));
                continue;
            }
            if (node.getDataType().size() > 1) {
                results.add(new CompoundElement(node));
                continue;
            }
            if (node.getValidValues().size() > 0) {
                results.add(new SelectionElement(node));
                continue;
            }
            ConfigElement element = node.getDataType().get(0).create(node);
            if (element == null) continue;
            results.add(element);
        }
        return results;
    }

    public FolderElement getElement(String name) {
        for (Element element : this.allEntries) {
            FolderElement folder;
            if (!(element instanceof FolderElement) || (folder = (FolderElement)element).getNode() == null || !name.equalsIgnoreCase(folder.getNode().getNodeName())) continue;
            return folder;
        }
        return null;
    }

    public static class Navigator {
        private static final Component SPLITTER = Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        List<Component> layer = new ObjectArrayList();
        List<Screen> screenByIndex = new ObjectArrayList();
        List<String> walker = null;
        MutableComponent buildCache = null;

        private Navigator() {
        }

        public Navigator(Component base) {
            this.layer.add(base);
        }

        public static Navigator create(IModConfig config) {
            Navigator nav = new Navigator((Component)Component.m_237113_((String)ModList.get().getModContainerById(config.getModId()).map(T -> T.getModInfo().getDisplayName()).orElse("Unknown")));
            nav.setScreenForLayer(null);
            return nav.add((Component)Component.m_237115_((String)("gui.chunk_pregen.config.type." + config.getConfigType().name().toLowerCase())));
        }

        public Navigator add(Component name) {
            return this.add(name, null);
        }

        public Navigator add(Component name, String walkerEntry) {
            Navigator nav = new Navigator();
            nav.layer.addAll(this.layer);
            nav.screenByIndex.addAll(this.screenByIndex);
            nav.layer.add(name);
            if (this.walker != null && this.walker.size() > 1 && walkerEntry != null && this.walker.indexOf(walkerEntry.toLowerCase(Locale.ROOT)) == 0) {
                nav.walker = new ObjectArrayList();
                for (int i = 1; i < this.walker.size(); ++i) {
                    nav.walker.add(this.walker.get(i));
                }
            }
            return nav;
        }

        public Navigator withWalker(String ... traversePath) {
            this.walker = new ObjectArrayList();
            for (String path : traversePath) {
                this.walker.add(path.toLowerCase(Locale.ROOT));
            }
            return this;
        }

        public void setScreenForLayer(Screen owner) {
            if (this.layer.size() > this.screenByIndex.size()) {
                this.screenByIndex.add(owner);
            } else {
                this.screenByIndex.set(this.layer.size() - 1, owner);
            }
        }

        public Screen getScreen(Font font, int x) {
            int splitterWidth = font.m_92852_((FormattedText)SPLITTER);
            int m = this.layer.size();
            for (int i = 0; i < m; ++i) {
                int width = font.m_92852_((FormattedText)this.layer.get(i));
                if (x >= 0 && x <= width) {
                    return this.screenByIndex.get(i);
                }
                x -= width;
                x -= splitterWidth;
            }
            return null;
        }

        protected void consumeWalker() {
            this.walker = null;
        }

        protected String getWalkNode() {
            return this.walker == null ? null : this.walker.get(0);
        }

        public Component getHeader() {
            if (this.buildCache == null) {
                this.buildCache = Component.m_237119_();
                int m = this.layer.size();
                for (int i = 0; i < m; ++i) {
                    this.buildCache.m_7220_(this.layer.get(i));
                    if (i == m - 1) continue;
                    this.buildCache.m_7220_(SPLITTER);
                }
            }
            return this.buildCache;
        }
    }
}

