/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pregenerator.common.utils.config.api.ISuggestedEnum;

public interface ISuggestionProvider {
    public void provideSuggestions(Consumer<Suggestion> var1, Predicate<Suggestion> var2);

    public static ISuggestionProvider single(Suggestion value) {
        return new SingleSuggestion(value);
    }

    public static ISuggestionProvider array(Suggestion ... elements) {
        return new SimpleSuggestion((List<Suggestion>)ObjectArrayList.wrap((Object[])elements));
    }

    public static ISuggestionProvider list(List<Suggestion> elements) {
        return new SimpleSuggestion(elements);
    }

    public static <E extends Enum<E>> ISuggestionProvider enums(Class<E> type) {
        return new EnumSuggestion<E>(type);
    }

    public static class SingleSuggestion
    implements ISuggestionProvider {
        Suggestion value;

        private SingleSuggestion(Suggestion value) {
            this.value = value;
        }

        @Override
        public void provideSuggestions(Consumer<Suggestion> output, Predicate<Suggestion> filter) {
            if (filter.test(this.value)) {
                output.accept(this.value);
            }
        }
    }

    public static class Suggestion {
        String name;
        String value;
        Object type;

        private Suggestion(String name, String value, Object type) {
            this.name = name;
            this.value = Objects.requireNonNull(value);
            this.type = type;
            if (value.trim().isEmpty()) {
                throw new IllegalArgumentException("Value isn't allowed to be empty");
            }
        }

        public static Suggestion namedTypeValue(String name, String value, Object type) {
            return new Suggestion(name, value, type);
        }

        public static Suggestion value(String value) {
            return new Suggestion(value, value, null);
        }

        public static Suggestion namedValue(String name, String value) {
            return new Suggestion(name, value, null);
        }

        public static Suggestion typedValue(String value, Object type) {
            return new Suggestion(value, value, type);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Object getType() {
            return this.type;
        }
    }

    public static class SimpleSuggestion
    implements ISuggestionProvider {
        List<Suggestion> suggestions;

        private SimpleSuggestion(List<Suggestion> suggestions) {
            this.suggestions = suggestions;
        }

        @Override
        public void provideSuggestions(Consumer<Suggestion> output, Predicate<Suggestion> filter) {
            for (Suggestion value : this.suggestions) {
                if (!filter.test(value)) continue;
                output.accept(value);
            }
        }
    }

    public static class EnumSuggestion<E extends Enum<E>>
    implements ISuggestionProvider {
        Class<E> enumClass;

        private EnumSuggestion(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public void provideSuggestions(Consumer<Suggestion> output, Predicate<Suggestion> filter) {
            for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
                Suggestion suggestion;
                ISuggestedEnum<Enum> wrapper = ISuggestedEnum.getWrapper(value);
                Suggestion suggestion2 = suggestion = wrapper == null ? Suggestion.value(value.name()) : Suggestion.namedValue(wrapper.getName(value), value.name());
                if (!filter.test(suggestion)) continue;
                output.accept(suggestion);
            }
        }
    }
}

