/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.minitasks;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.minitasks.BaseScanTask;
import pregenerator.common.utils.misc.TrackedRegionFile;

public class ScanSize
extends BaseScanTask {
    private static final BitSet FULL_SET = ScanSize.create();
    List<Path> filesToProcess = new ObjectArrayList();
    int step = 0;
    int processed = 0;
    int lastFive;
    LongSet fullRegionFiles = new LongOpenHashSet();
    LongSet generatedChunks = new LongOpenHashSet();
    int[] totalSize = new int[4];
    int[] actualSize = new int[4];

    public ScanSize(ResourceKey<Level> dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public void interrupt() {
    }

    @Override
    public boolean update(long startTime) {
        if (this.step == 0) {
            this.filesToProcess.addAll(this.getRegionFiles());
            this.step = 1;
            return true;
        }
        if (this.step == 1) {
            while (System.currentTimeMillis() - startTime < 50L && this.processed < this.filesToProcess.size()) {
                this.processChunk(this.filesToProcess.get(this.processed++));
                int newProgress = (int)((float)this.processed / (float)this.filesToProcess.size() * 100.0f);
                if (newProgress - this.lastFive < 5) continue;
                this.lastFive = newProgress;
                this.sendMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.progress", TextUtil.NUMBERS.format(newProgress)).m_6879_().m_130940_(ChatFormatting.AQUA));
            }
            if (this.processed == this.filesToProcess.size()) {
                this.step = 2;
                int centerX = this.totalSize[0] + (this.totalSize[2] - this.totalSize[0]) / 2;
                int centerZ = this.totalSize[1] + (this.totalSize[3] - this.totalSize[1]) / 2;
                this.actualSize[0] = centerX - 1;
                this.actualSize[1] = centerZ - 1;
                this.actualSize[2] = centerX + 1;
                this.actualSize[3] = centerZ + 1;
            }
            return true;
        }
        if (this.step == 2) {
            while (System.currentTimeMillis() - startTime < 50L) {
                int invalidCount = 0;
                for (int i = 0; i < 4; ++i) {
                    int width = this.getWidth(i);
                    boolean invalid = false;
                    for (int o = 0; o < width; ++o) {
                        if (!this.isInvalid(i, o)) continue;
                        invalid = true;
                        break;
                    }
                    if (invalid) {
                        ++invalidCount;
                        continue;
                    }
                    this.grow(i);
                }
                if (invalidCount != 4) continue;
                this.step = 3;
                break;
            }
            return true;
        }
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.size_scan.total_area"));
        this.sendForceMessage((Component)this.from(this.totalSize).m_130940_(ChatFormatting.GOLD));
        this.sendForceMessage((Component)this.to(this.totalSize).m_130940_(ChatFormatting.GOLD));
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.size_scan.actual_area"));
        this.sendForceMessage((Component)this.from(this.actualSize).m_130940_(ChatFormatting.GOLD));
        this.sendForceMessage((Component)this.to(this.actualSize).m_130940_(ChatFormatting.GOLD));
        int minX = (this.actualSize[2] - this.actualSize[0]) / 2 - 2;
        int minZ = (this.actualSize[3] - this.actualSize[1]) / 2 - 2;
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.size_scan.suggestion", TextUtil.NUMBERS.format(Math.min(minX, minZ))));
        return false;
    }

    private MutableComponent from(int[] array) {
        return TextUtil.translate("mini_task.chunk_pregen.size_scan.from", TextUtil.NUMBERS.format(array[0] * 16), TextUtil.NUMBERS.format(array[1] * 16));
    }

    private MutableComponent to(int[] array) {
        return TextUtil.translate("mini_task.chunk_pregen.size_scan.to", TextUtil.NUMBERS.format(array[2] * 16 + 16), TextUtil.NUMBERS.format(array[3] * 16 + 16));
    }

    @Override
    public boolean hasClientOverlay() {
        return false;
    }

    @Override
    public byte getClientDataId() {
        return 0;
    }

    @Override
    public void writeData(FriendlyByteBuf buffer) {
    }

    private void processChunk(Path regionFile) {
        ChunkPos pos = this.getRegionPosition(regionFile);
        if (pos == null) {
            return;
        }
        try {
            TrackedRegionFile file = new TrackedRegionFile(regionFile, regionFile.getParent());
            BitSet set = new BitSet(1024);
            for (int i = 0; i < 1024; ++i) {
                if (!file.m_63682_(new ChunkPos(i % 32, i / 32))) continue;
                set.set(i);
            }
            if (FULL_SET.equals(set)) {
                this.fullRegionFiles.add(pos.m_45588_());
                this.addRegion(pos.f_45578_ << 5, pos.f_45579_ << 5, (pos.f_45578_ << 5) + 31, (pos.f_45579_ << 5) + 31);
            } else {
                int minX = 31;
                int minZ = 31;
                int maxX = 0;
                int maxZ = 0;
                for (int i = 0; i < 1024; ++i) {
                    if (!set.get(i)) continue;
                    int x = i % 32;
                    int z = i / 32;
                    this.generatedChunks.add(ChunkPos.m_45589_((int)((pos.f_45578_ << 5) + x), (int)((pos.f_45579_ << 5) + z)));
                    minX = Math.min(minX, x);
                    minZ = Math.min(minZ, z);
                    maxX = Math.max(maxX, x);
                    maxZ = Math.max(maxZ, z);
                }
                this.addRegion((pos.f_45578_ << 5) + minX, (pos.f_45579_ << 5) + minZ, (pos.f_45578_ << 5) + maxX, (pos.f_45579_ << 5) + maxZ);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addRegion(int minX, int minZ, int maxX, int maxZ) {
        this.totalSize[0] = Math.min(this.totalSize[0], minX);
        this.totalSize[1] = Math.min(this.totalSize[1], minZ);
        this.totalSize[2] = Math.max(this.totalSize[2], maxX);
        this.totalSize[3] = Math.max(this.totalSize[3], maxZ);
    }

    private int getWidth(int axis) {
        int offset = axis % 2;
        return this.actualSize[2 + offset] - this.actualSize[offset];
    }

    private boolean isInvalid(int axis, int offset) {
        switch (axis) {
            case 0: {
                return this.isUnfinished(this.actualSize[0] + offset, this.actualSize[1] - 1);
            }
            case 1: {
                return this.isUnfinished(this.actualSize[2] + 1, this.actualSize[1] + offset);
            }
            case 2: {
                return this.isUnfinished(this.actualSize[0] + offset, this.actualSize[3] + 1);
            }
            case 3: {
                return this.isUnfinished(this.actualSize[0] - 1, this.actualSize[1] + offset);
            }
        }
        return false;
    }

    private void grow(int axis) {
        int n = axis;
        this.actualSize[n] = this.actualSize[n] + (axis / 2 * 2 - 1);
    }

    private boolean isUnfinished(int x, int z) {
        for (int i = 1; i < 13; ++i) {
            if (this.hasChunk(x + i, z) && this.hasChunk(x - i, z) && this.hasChunk(x, z + i) && this.hasChunk(x, z - i)) continue;
            return true;
        }
        return false;
    }

    private boolean hasChunk(int x, int z) {
        if (this.fullRegionFiles.contains(ChunkPos.m_45589_((int)(x >> 5), (int)(z >> 5)))) {
            return true;
        }
        return this.generatedChunks.contains(ChunkPos.m_45589_((int)x, (int)z));
    }

    static BitSet create() {
        BitSet set = new BitSet(1024);
        set.set(0, 1023);
        return set;
    }
}

