/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.BitSet;
import net.minecraft.world.level.ChunkPos;
import pregenerator.common.manager.IProcess;

public class ChunkShapeBuilder {
    public static Long2ObjectMap<BitSet> getSquareShape(int xPos, int zPos, int radius, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                ChunkShapeBuilder.create(x + xPos, z + zPos, (Long2ObjectMap<BitSet>)result);
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getSquareExspansionShape(int xPos, int zPos, int minRadius, int maxRadius, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (x > -minRadius && x <= minRadius && z > -minRadius && z <= minRadius) continue;
                ChunkShapeBuilder.create(x + xPos, z + zPos, (Long2ObjectMap<BitSet>)result);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getCircleShape(int xPos, int zPos, int radius, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                progress.growValue(1);
                if (ChunkShapeBuilder.isNotInReach(x, z, radius)) continue;
                ChunkShapeBuilder.create(x + xPos, z + zPos, (Long2ObjectMap<BitSet>)result);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getCircleExpansionShape(int xPos, int zPos, int minRadius, int maxRadius, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (ChunkShapeBuilder.isNotInRange(x, z, minRadius, maxRadius)) continue;
                ChunkShapeBuilder.create(x + xPos, z + zPos, (Long2ObjectMap<BitSet>)result);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> genSquareArea(int minX, int minZ, int maxX, int maxZ, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                ChunkShapeBuilder.create(x, z, (Long2ObjectMap<BitSet>)result);
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> genCircleArea(int minX, int minZ, int maxX, int maxZ, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        int xRadius = maxX - minX;
        int zRadius = maxZ - minZ;
        for (int x = 0; x < xRadius; ++x) {
            for (int z = 0; z < zRadius; ++z) {
                progress.growValue(1);
                if (ChunkShapeBuilder.isNotInReachEllipse(x, z, xRadius, zRadius)) continue;
                ChunkShapeBuilder.create(x + minX, z + minZ, (Long2ObjectMap<BitSet>)result);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> genSpecific(LongCollection chunks, IProcess.PrepareProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        LongIterator iter = chunks.iterator();
        while (iter.hasNext()) {
            progress.growValue(1);
            long value = iter.nextLong();
            ChunkShapeBuilder.create(ChunkPos.m_45592_((long)value), ChunkPos.m_45602_((long)value), (Long2ObjectMap<BitSet>)result);
        }
        return result;
    }

    static void create(int x, int z, Long2ObjectMap<BitSet> map) {
        long value = ChunkPos.m_45589_((int)(x >> 5), (int)(z >> 5));
        BitSet set = (BitSet)map.get(value);
        if (set == null) {
            set = new BitSet(1024);
            map.put(value, (Object)set);
        }
        set.set((z & 0x1F) * 32 + (x & 0x1F));
    }

    static boolean isNotInRange(int x, int y, int minRadius, int maxRadius) {
        long distance = x * x + y * y;
        return distance >= (long)(maxRadius * maxRadius) || distance < (long)(minRadius * minRadius);
    }

    static boolean isNotInReachEllipse(int x, int y, int width, int height) {
        double posX = (double)x / (double)width - 0.5;
        double posY = (double)y / (double)height - 0.5;
        return posX * posX + posY * posY >= 0.25;
    }

    static boolean isNotInReach(int x, int y, int radius) {
        return x * x + y * y >= radius * radius;
    }
}

