/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

public class DeletionSquareArea
extends BaseDeletionTask {
    long min;
    long max;
    long center;

    public DeletionSquareArea(String name, ResourceKey<Level> type, ChunkPos min, ChunkPos max) {
        super(name, type);
        this.min = min.m_45588_();
        this.max = max.m_45588_();
        this.center = ChunkPos.m_45589_((int)(min.f_45578_ + (max.f_45578_ - min.f_45578_) / 2), (int)(min.f_45579_ + (max.f_45579_ - min.f_45579_) / 2));
    }

    public DeletionSquareArea(CompoundTag nbt) {
        super(nbt);
        this.min = nbt.m_128454_("min");
        this.max = nbt.m_128454_("max");
        this.center = nbt.m_128454_("center");
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = super.write();
        tag.m_128356_("min", this.min);
        tag.m_128356_("max", this.max);
        tag.m_128356_("center", this.center);
        return tag;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.square_area");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return Math.max((ChunkPos.m_45592_((long)this.max) - ChunkPos.m_45592_((long)this.min)) / 2, (ChunkPos.m_45602_((long)this.max) - ChunkPos.m_45602_((long)this.min)) / 2);
    }

    @Override
    public Area getArea() {
        return new Area(new ChunkPos(this.min), new ChunkPos(this.max));
    }

    @Override
    public long getTaskSize() {
        long x = ChunkPos.m_45592_((long)this.max) - ChunkPos.m_45592_((long)this.min);
        long z = ChunkPos.m_45602_((long)this.max) - ChunkPos.m_45602_((long)this.min);
        return x * z * 4L;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.square_area"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.from", new Object[]{min.f_45578_, min.f_45579_}, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.to", new Object[]{max.f_45578_, max.f_45579_}, builder, ChatFormatting.YELLOW);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        return deleter.init(ChunkShapeBuilder.genSquareArea(min.f_45578_, min.f_45579_, max.f_45578_, max.f_45579_, progress), new ChunkPos(this.center), progress);
    }
}

