/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionCircleExpansion
extends BaseDeletionTask {
    long center;
    int minRadius;
    int maxRadius;

    public DeletionCircleExpansion(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.minRadius = nbt.m_128451_("minRadius");
        this.maxRadius = nbt.m_128451_("maxRadius");
    }

    public DeletionCircleExpansion(String name, ResourceKey<Level> type, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type);
        this.center = center.m_45588_();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128356_("center", this.center);
        nbt.m_128405_("minRadius", this.minRadius);
        nbt.m_128405_("maxRadius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.f_45578_, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.f_45579_, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.minRadius, builder, ChatFormatting.BLUE);
        ITask.insert("task.chunk_pregen.max_radius", this.maxRadius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)((long)this.maxRadius * 2L) * Math.PI) - (long)((double)((long)this.minRadius * 2L) * Math.PI);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getCircleExpansionShape(center.f_45578_, center.f_45579_, this.minRadius, this.maxRadius, progress), center, progress);
    }
}

