/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;

public interface ICoordinate {
    public int getPositon(CommandSourceStack var1, boolean var2);

    public static ICoordinate parseCoordinate(StringReader reader) throws CommandSyntaxException {
        switch (reader.peek()) {
            case '^': {
                return new SpawnCoordinate(ICoordinate.parseNumber(ICoordinate.skip(reader)));
            }
            case '~': {
                return new PlayerCoordinate(ICoordinate.parseNumber(ICoordinate.skip(reader)));
            }
        }
        return new NormalCoordinate(ICoordinate.parseNumber(reader));
    }

    public static StringReader skip(StringReader reader) {
        reader.skip();
        return reader;
    }

    public static int parseNumber(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() != ' ') {
            int result = reader.readInt();
            if (reader.canRead() && Character.toLowerCase(reader.peek()) == 'b') {
                reader.skip();
                return result >> 4;
            }
            return result;
        }
        return 0;
    }

    public static class SpawnCoordinate
    implements ICoordinate {
        int offset;

        public SpawnCoordinate(int offset) {
            this.offset = offset;
        }

        @Override
        public int getPositon(CommandSourceStack source, boolean isX) {
            BlockPos pos = source.m_81372_().m_220360_();
            return ((isX ? pos.m_123341_() : pos.m_123343_()) >> 4) + this.offset;
        }
    }

    public static class PlayerCoordinate
    implements ICoordinate {
        int offset;

        public PlayerCoordinate(int offset) {
            this.offset = offset;
        }

        @Override
        public int getPositon(CommandSourceStack source, boolean isX) {
            if (source.m_81373_() == null) {
                return this.offset;
            }
            BlockPos pos = source.m_81373_().m_20183_();
            return ((isX ? pos.m_123341_() : pos.m_123343_()) >> 4) + this.offset;
        }
    }

    public static class NormalCoordinate
    implements ICoordinate {
        int value;

        public NormalCoordinate(int value) {
            this.value = value;
        }

        @Override
        public int getPositon(CommandSourceStack source, boolean isX) {
            return this.value;
        }
    }
}

