/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import pregenerator.base.api.TextUtil;
import pregenerator.common.commands.arguments.CenterLocation;
import pregenerator.common.commands.arguments.ICoordinate;

public class CenterArgument
implements ArgumentType<Coordinates> {
    private static final Collection<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0 0", "~ ~", "^ ^", "^1 ^-5", "~0.5 ~-5", "0b 0", "^1b ^-5b", "~0.5 ~-5b"});
    public static final SimpleCommandExceptionType POS_INCOMPLETE = new SimpleCommandExceptionType((Message)TextUtil.translate("argument.chunk_pregen.error.incomplete"));
    public static final SuggestionEntry[] SUGGESTIONS = new SuggestionEntry[]{new SuggestionEntry("0 0", "argument.chunk_pregen.position.chunk"), new SuggestionEntry("~ ~", "argument.chunk_pregen.position.player"), new SuggestionEntry("^ ^", "argument.chunk_pregen.position.spawn"), new SuggestionEntry("1b 100", "argument.chunk_pregen.position.block"), new SuggestionEntry("^100 ^", "argument.chunk_pregen.position.spawn.chunk"), new SuggestionEntry("^100b 100", "argument.chunk_pregen.position.spawn.block"), new SuggestionEntry("~100 ~", "argument.chunk_pregen.position.player.chunk"), new SuggestionEntry("~100b ^100", "argument.chunk_pregen.position.player.block")};
    public static final SuggestionEntry[] SIMPLE_SUGGESTION = new SuggestionEntry[]{new SuggestionEntry("0 0", "argument.chunk_pregen.position.chunk"), new SuggestionEntry("~ ~", "argument.chunk_pregen.position.player")};

    public static CenterArgument center() {
        return new CenterArgument();
    }

    public Coordinates parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ICoordinate coord = ICoordinate.parseCoordinate(reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            return new CenterLocation(coord, ICoordinate.parseCoordinate(reader));
        }
        reader.setCursor(start);
        throw POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String[] value = builder.getRemaining().split(" ");
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < SUGGESTIONS.length; ++j) {
                if (!SUGGESTIONS[j].matches(value[i])) continue;
                SUGGESTIONS[j].suggest(builder);
            }
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> listSimpleSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String[] value = builder.getRemaining().split(" ");
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < SIMPLE_SUGGESTION.length; ++j) {
                if (!SIMPLE_SUGGESTION[j].matches(value[i])) continue;
                SIMPLE_SUGGESTION[j].suggest(builder);
            }
        }
        return builder.buildFuture();
    }

    public static BlockPos getBlockPos(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((Coordinates)context.getArgument(name, Coordinates.class)).m_119568_((CommandSourceStack)context.getSource());
    }

    public static BlockPos getVanillaBlockPos(Coordinates argument, CommandSourceStack source) {
        if (argument instanceof WorldCoordinates) {
            WorldCoordinates input = (WorldCoordinates)argument;
            Vec3 result = input.m_6955_(source);
            if (input.m_6888_()) {
                result = result.m_82492_(source.m_81371_().m_7096_(), 0.0, 0.0).m_82520_(source.m_81371_().m_7096_() / 16.0, 0.0, 0.0);
            }
            if (input.m_6892_()) {
                result = result.m_82492_(0.0, source.m_81371_().m_7098_(), 0.0).m_82520_(0.0, source.m_81371_().m_7098_() / 16.0, 0.0);
            }
            if (input.m_6900_()) {
                result = result.m_82492_(0.0, 0.0, source.m_81371_().m_7094_()).m_82520_(0.0, 0.0, source.m_81371_().m_7094_() / 16.0);
            }
            return BlockPos.m_274446_((Position)result);
        }
        return argument.m_119568_(source);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class SuggestionEntry {
        String entry;
        Component tooltip;

        public SuggestionEntry(String entry, String tooltip) {
            this.entry = entry.toLowerCase(Locale.ROOT);
            this.tooltip = TextUtil.translate(tooltip);
        }

        public boolean matches(String s) {
            return this.entry.startsWith(s.toLowerCase(Locale.ROOT));
        }

        public void suggest(SuggestionsBuilder builder) {
            builder.suggest(this.entry, (Message)this.tooltip);
        }
    }
}

