/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class RetrogenCommand {
    public static CommandBuilder createRetogenCommand() {
        CommandBuilder start = new CommandBuilder("retrogen");
        start.literal("add");
        start.arg("id", (ArgumentType<?>)ResourceLocationArgument.m_106984_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(K, V) -> SharedSuggestionProvider.m_82926_(RetrogenManager.INSTANCE.getInactiveFeatures(((CommandSourceStack)K.getSource()).m_5894_()), (SuggestionsBuilder)V)), RetrogenCommand::add);
        start.literal("remove");
        start.arg("id", (ArgumentType<?>)ResourceLocationArgument.m_106984_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(K, V) -> SharedSuggestionProvider.m_82926_(RetrogenManager.INSTANCE.getActiveFeatures(), (SuggestionsBuilder)V)), RetrogenCommand::remove).popTop();
        start.literal("show", RetrogenCommand::show).popTop();
        start.literal("list", RetrogenCommand::listAll);
        start.literal("sorted", RetrogenCommand::listMods);
        start.arg("mod", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(C, S) -> SharedSuggestionProvider.m_82970_(RetrogenCommand.createMappedElements((CommandContext<CommandSourceStack>)C).keySet(), (SuggestionsBuilder)S)), RetrogenCommand::listCategory);
        start.arg("category", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(C, S) -> SharedSuggestionProvider.m_82970_(RetrogenCommand.createMappedElements((CommandContext<CommandSourceStack>)C).get(StringArgumentType.getString((CommandContext)C, (String)"mod")).keySet(), (SuggestionsBuilder)S)), RetrogenCommand::listMapped).popTop();
        return start;
    }

    private static void add(CommandWrapper source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            source.sendErrorMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.error.active"));
            return;
        }
        ResourceLocation location = source.get("id", ResourceLocation.class);
        if (source.getSource().m_5894_().m_175515_(Registries.f_256988_).m_7804_(location)) {
            RetrogenManager.INSTANCE.enableFeature(location);
            source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.add", location));
        }
    }

    private static void remove(CommandWrapper source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            source.sendErrorMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.error.active"));
            return;
        }
        ResourceLocation location = source.get("id", ResourceLocation.class);
        if (source.getSource().m_5894_().m_175515_(Registries.f_256988_).m_7804_(location)) {
            RetrogenManager.INSTANCE.disableFeature(location);
            source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.remove", location));
        }
    }

    private static void show(CommandWrapper source) {
        Set<ResourceLocation> locations = RetrogenManager.INSTANCE.getActiveFeatures();
        if (locations.isEmpty()) {
            source.sendErrorMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.error.empty"));
            return;
        }
        source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.enabled", locations.size()));
        for (ResourceLocation location : locations) {
            source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.feature", location.toString(), TextUtil.translate("commands.chunk_pregen.retrogen.disable").m_6879_().m_130948_(RetrogenCommand.createCommand(location, false))));
        }
    }

    private static void listAll(CommandWrapper source) {
        RetrogenCommand.list(source, (List<ResourceLocation>)new ObjectArrayList((Collection)source.getSource().m_5894_().m_175515_(Registries.f_256988_).m_6566_()));
    }

    private static void listMapped(CommandWrapper source) {
        RetrogenCommand.list(source, (List<ResourceLocation>)new ObjectArrayList((Collection)RetrogenCommand.createMappedElements(source.getContext()).get(source.get("mod", String.class)).get(source.get("category", String.class))));
    }

    private static void list(CommandWrapper wrapper, List<ResourceLocation> locations) {
        locations.removeAll(RetrogenManager.INSTANCE.getActiveFeatures());
        if (locations.isEmpty()) {
            wrapper.sendErrorMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.error.full"));
            return;
        }
        locations.sort(Comparator.comparing(ResourceLocation::m_135815_, String.CASE_INSENSITIVE_ORDER));
        wrapper.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.disabled", locations.size()));
        for (ResourceLocation location : locations) {
            wrapper.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.feature", TextUtil.literalPascal(location.m_135815_()).m_130940_(ChatFormatting.GOLD), TextUtil.getModName(location.m_135827_()).m_130940_(ChatFormatting.BLUE)).m_130948_(RetrogenCommand.createCommand(location, true)));
        }
    }

    private static void listCategory(CommandWrapper source) {
        String mod = source.get("mod", String.class);
        ObjectArrayList list = new ObjectArrayList(RetrogenCommand.createMappedElements(source.getContext()).get(mod).keySet());
        list.sort(String.CASE_INSENSITIVE_ORDER);
        for (String s : list) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen retrogen list sorted " + mod + " " + s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.translate("commands.chunk_pregen.retrogen.list")));
            source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.category", TextUtil.literalPascal(s).m_130940_(ChatFormatting.GOLD).m_130948_(style)));
        }
    }

    private static void listMods(CommandWrapper source) {
        ObjectArrayList list = new ObjectArrayList(RetrogenCommand.createMappedElements(source.getContext()).keySet());
        list.sort(String.CASE_INSENSITIVE_ORDER);
        for (String s : list) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen retrogen list sorted " + s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.translate("commands.chunk_pregen.retrogen.list")));
            source.sendFeedBackMessage((Component)TextUtil.translate("commands.chunk_pregen.retrogen.mod", TextUtil.literalPascal(s).m_130940_(ChatFormatting.GOLD).m_130948_(style)));
        }
    }

    private static Map<String, Map<String, List<ResourceLocation>>> createMappedElements(CommandContext<CommandSourceStack> source) {
        RegistryAccess registry = ((CommandSourceStack)source.getSource()).m_5894_();
        return RetrogenCommand.createMappedElements((Registry<PlacedFeature>)registry.m_175515_(Registries.f_256988_), registry.m_175515_(Registries.f_256833_));
    }

    private static Map<String, Map<String, List<ResourceLocation>>> createMappedElements(Registry<PlacedFeature> registry, Registry<Feature<?>> featureRegistry) {
        Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry entry : registry.m_6579_()) {
            Map map = result.computeIfAbsent(((ResourceKey)entry.getKey()).m_135782_().m_135827_(), T -> new Object2ObjectLinkedOpenHashMap());
            map.computeIfAbsent(featureRegistry.m_7981_((Object)((ConfiguredFeature)((PlacedFeature)entry.getValue()).f_191775_().m_203334_()).f_65377_()).m_135815_(), T -> new ObjectArrayList()).add(((ResourceKey)entry.getKey()).m_135782_());
        }
        return result;
    }

    private static Style createCommand(ResourceLocation args, boolean add) {
        String s = (add ? "/pregen retrogen add " : "/pregen retrogen remove ") + args.toString();
        return Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.translate(add ? "commands.chunk_pregen.retrogen.enable" : "commands.chunk_pregen.retrogen.disable")));
    }
}

