/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import net.minecraft.network.chat.Component;
import pregenerator.base.api.TextUtil;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class InfoCommand {
    public static CommandBuilder createInfoCommand() {
        CommandBuilder builder = new CommandBuilder("info");
        builder.literal("listen", InfoCommand::listen).popTop();
        builder.literal("unlisten", InfoCommand::unlisten).popTop();
        builder.literal("autolisten", InfoCommand::autoListenState).literal("enable", InfoCommand::enableAuto).pop();
        builder.literal("disable", InfoCommand::disableAuto).pop();
        builder.literal("reset", InfoCommand::resetAuto).popTop();
        return builder;
    }

    public static void listen(CommandWrapper source) {
        ServerManager.INSTANCE.addListener(source.getSenderId());
    }

    public static void unlisten(CommandWrapper source) {
        ServerManager.INSTANCE.removeListener(source.getSenderId());
    }

    public static void enableAuto(CommandWrapper source) {
        if (TaskStorage.getListeners().add(source.getSenderId(), true)) {
            source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.listening.started", source.getSource().m_81368_()));
            return;
        }
        source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.info.listening.already", source.getSource().m_81368_()));
    }

    public static void disableAuto(CommandWrapper source) {
        if (TaskStorage.getListeners().add(source.getSenderId(), false)) {
            source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.ignoring.started", source.getSource().m_81368_()));
            return;
        }
        source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.info.ignoring.already", source.getSource().m_81368_()));
    }

    public static void resetAuto(CommandWrapper source) {
        TaskStorage.getListeners().remove(source.getSenderId());
        source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.reset", source.getSource().m_81368_()));
    }

    public static void autoListenState(CommandWrapper source) {
        switch (TaskStorage.getListeners().getState(source.getSenderId())) {
            case 0: {
                source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.listening.state", source.getName()));
                break;
            }
            case 1: {
                source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.ignoring.state", source.getName()));
                break;
            }
            case 2: {
                source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.not_listening.state", source.getName()));
            }
        }
    }
}

