/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui.commands;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenCheckBox;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.base.impl.comp.PregenTreeList;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionTimeOut;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.networking.packets.MemoryPacket;
import pregenerator.common.networking.packets.TaskPacket;
import pregenerator.common.utils.misc.Area;
import pregenerator.common.utils.misc.GenShape;

public class TaskScreen
extends BasePregenScreen
implements MemoryPacket.IMemoryReceiver,
TaskPacket.ISpeedReceiver {
    public static final Component[][] TYPES = new Component[][]{{TextUtil.translate("gui.chunk_pregen.task_screen.nodes.pause"), TextUtil.translate("gui.chunk_pregen.task_screen.nodes.resume")}, {TextUtil.translate("gui.chunk_pregen.task_screen.nodes.start"), TextUtil.translate("gui.chunk_pregen.task_screen.nodes.stop")}, {TextUtil.translate("gui.chunk_pregen.task_screen.nodes.delete")}};
    Screen parent;
    PregenTreeList.TreeState<TaskNode> elements = new PregenTreeList.TreeState().setRowWidth(320).setTopPadding(43);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    PregenText.TextState search = new PregenText.TextState("", "Search").setCallback(this.elements::search);
    Object2FloatMap<ResourceKey<Level>> speeds = new Object2FloatOpenHashMap();
    Object2BooleanMap<UUID> activeTasks = new Object2BooleanOpenHashMap();
    Set<ResourceKey<Level>> activeLevels = new ObjectOpenHashSet();
    Object2LongMap<ResourceKey<Level>> usedMemory = new Object2LongLinkedOpenHashMap();
    long maxMemory = 1L;
    Component header = TextUtil.translate("gui.chunk_pregen.task_screen.header");

    public TaskScreen(Screen parent) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.elements.add(new TaskNode[]{new RootNode((Component)TextUtil.translate("gui.chunk_pregen.task_screen.gen_tasks"), false)});
        this.elements.add(new TaskNode[]{new RootNode((Component)TextUtil.translate("gui.chunk_pregen.task_screen.deletion_tasks"), true)});
        this.speeds.defaultReturnValue(1.0f);
        this.updateMemory();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.tree(this.elements);
        this.text(-96, 20, 188, 14, Align.CENTER, Align.START, this.search);
        this.checkbox(96, 20, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.m_7379_());
    }

    private void updateMemory() {
        this.sendToServer(new MemoryPacket.RequestFree());
        for (ResourceKey<Level> key : this.dimensions()) {
            this.sendToServer(new MemoryPacket.RequestUsed(key));
        }
        this.sendToServer(new TaskPacket.RequestSpeeds());
        this.sendToServer(new TaskPacket.RequestTasks());
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.tick % 40 == 0) {
            this.updateMemory();
        }
    }

    public void m_7379_() {
        this.setScreen(this.parent);
    }

    @Override
    public void receivedMemory(ResourceKey<Level> dimension, long value, boolean free) {
        if (free) {
            this.maxMemory = value;
        } else {
            this.usedMemory.put(dimension, value);
        }
    }

    public void acceptTasks(List<ITask> tasks, List<IDeletionTask> deletionTasks, Object2BooleanMap<UUID> activeTasks) {
        this.activeTasks.clear();
        this.activeTasks.putAll(activeTasks);
        TaskNode node = this.elements.getNodes().get(0);
        node.clear();
        for (ITask iTask : tasks) {
            node.addChildNode(new GenNode(iTask));
        }
        node = this.elements.getNodes().get(1);
        node.clear();
        for (IDeletionTask iDeletionTask : deletionTasks) {
            node.addChildNode(new DeletionNode(iDeletionTask));
        }
        this.elements.updateSearch();
    }

    @Override
    public void acceptSpeedData(Object2FloatMap<ResourceKey<Level>> speeds) {
        this.speeds.clear();
        this.speeds.putAll(speeds);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawText(graphics, this.header, 0.0f, -this.centerY + 5, Align.CENTER, -2105377);
    }

    public class TaskNode
    extends PregenTreeList.TreeEntry<TaskNode> {
        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        public void clear() {
            this.childNodes().clear();
        }
    }

    public class RootNode
    extends TaskNode {
        Component text;
        boolean delete;

        public RootNode(Component text, boolean delete) {
            this.text = text;
            this.delete = delete;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long current = this.getCurrent();
            long max = this.getMax();
            float progress = Math.max((float)current / (float)max * 95.0f, 0.0f);
            TaskScreen.this.drawSimpleRect(graphics, left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            TaskScreen.this.drawColorRegion(graphics, left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            float f = left + 20;
            int n = top + height / 2;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2, Align.START, -1);
            MutableComponent memory = TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(current), TextUtil.findBestMemory(max));
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)memory, left + width - 97, top, 95.0f, 10.0f, Align.START, -2105377, this.hashCode());
            TaskScreen.this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.tasks", this.childNodes().size()), left + width - 96, top + 13, Align.START, -2105377);
        }

        public long getMax() {
            if (this.delete) {
                long total = 0L;
                LongIterator iter = TaskScreen.this.usedMemory.values().iterator();
                while (iter.hasNext()) {
                    total += iter.nextLong();
                }
                return total;
            }
            return TaskScreen.this.maxMemory;
        }

        public long getCurrent() {
            if (this.delete) {
                Object2LongLinkedOpenHashMap dimensions = new Object2LongLinkedOpenHashMap();
                dimensions.defaultReturnValue(0L);
                for (TaskNode child : this.childNodes()) {
                    if (!(child instanceof ITaskNode)) continue;
                    ITaskNode node = (ITaskNode)((Object)child);
                    dimensions.addTo(node.dimension(), node.getUsedMemory());
                }
                long total = 0L;
                for (Object2LongMap.Entry entry : TaskScreen.this.usedMemory.object2LongEntrySet()) {
                    total += Math.min(entry.getLongValue(), dimensions.getLong(entry.getKey()));
                }
                return total;
            }
            long total = 0L;
            for (TaskNode child : this.childNodes()) {
                if (!(child instanceof ITaskNode)) continue;
                total += ((ITaskNode)((Object)child)).getUsedMemory();
            }
            return total;
        }

        @Override
        public int getItemHeight() {
            return 25;
        }
    }

    public class GenNode
    extends TaskNode
    implements ITaskNode {
        ITask task;
        PregenButton[] actions = new PregenButton[]{this.addChild(new PregenButton(0, 0, 60, 14, TYPES[0][0], this::pauseResume)), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[1][1], this::startStop)).setTooltip(this::getFailure), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[2][0], this::remove))};

        public GenNode(ITask task) {
            this.task = task;
        }

        private void startStop(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(TaskScreen.this.activeTasks.containsKey((Object)this.task.getTaskId()) ? 2 : 3, this.task.getName()));
        }

        private void pauseResume(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(TaskScreen.this.activeTasks.getBoolean((Object)this.task.getTaskId()) ? 0 : 1, this.task.getName()));
        }

        private void remove(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(4, this.task.getName()));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.task.getName().toLowerCase().startsWith(searchString) || this.searchResourceLocation(searchString, this.task.getDimension().m_135782_());
        }

        @Override
        public ResourceKey<Level> dimension() {
            return this.task.getDimension();
        }

        @Override
        public long getUsedMemory() {
            return TextUtil.getWorldSize(this.task.getTaskSize(), this.task.getDimension());
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long chunks = this.task.getTaskSize();
            long usage = TextUtil.getWorldSize(chunks, this.task.getDimension());
            float speed = TaskScreen.this.speeds.getFloat(this.task.getDimension());
            long time = (long)((float)chunks / speed * 50.0f);
            TaskScreen.this.drawSimpleRect(graphics, left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            float progress = (float)usage / (float)TaskScreen.this.maxMemory * 95.0f;
            TaskScreen.this.drawColorRegion(graphics, left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            int size = 95;
            MutableComponent mutableComponent = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.name", this.task.getName()).m_130940_(ChatFormatting.RED);
            float f = left + 2;
            float f2 = top - 1;
            float f3 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent, f, f2, f3, 9.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent2 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.dim", TextUtil.dimension(this.task.getDimension())).m_130940_(ChatFormatting.GOLD);
            float f4 = left + 2;
            float f5 = top + 10;
            float f6 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent2, f4, f5, f6, 9.0f, Align.START, -2105377, this.task.hashCode());
            Area area = this.task.getArea();
            MutableComponent mutableComponent3 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.from", BasePregenScreen.NUMBERS.format(area.getMinX()), BasePregenScreen.NUMBERS.format(area.getMinZ())).m_130940_(ChatFormatting.DARK_AQUA);
            float f7 = left + 2;
            float f8 = top + 21;
            float f9 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent3, f7, f8, f9, 9.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent4 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.to", BasePregenScreen.NUMBERS.format(area.getMaxX()), BasePregenScreen.NUMBERS.format(area.getMaxZ())).m_130940_(ChatFormatting.DARK_AQUA);
            float f10 = left + 2;
            float f11 = top + 32;
            float f12 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent4, f10, f11, f12, 9.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent5 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.eta", TextUtil.getTime(time), BasePregenScreen.FLOATING_NUMBERS.format(speed)).m_130940_(ChatFormatting.DARK_GREEN);
            float f13 = left + 2;
            float f14 = top + 43;
            float f15 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent5, f13, f14, f15, 9.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(usage), TextUtil.findBestMemory(TaskScreen.this.maxMemory)), left + width - size - 2, top, size, 10.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.nodes.chunks", BasePregenScreen.NUMBERS.format(chunks)).m_130940_(ChatFormatting.BLUE), left + width - size - 2, top + 10, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent6 = this.task.getShapeName().m_6879_().m_130940_(ChatFormatting.GOLD);
            float f16 = left + width - size - 2;
            float f17 = top + 21;
            float f18 = size;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent6, f16, f17, f18, 9.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)GenerationType.values()[this.task.getGenType()].createText().m_6879_().m_130940_(ChatFormatting.DARK_AQUA), left + width - size - 2, top + 30, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            if (TaskScreen.this.activeTasks.containsKey((Object)this.task.getTaskId())) {
                TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translateStyled("gui.chunk_pregen.task_screen.nodes.active", ChatFormatting.RED), left + width - size - 2, top + 40, size, 12.0f, Align.START, -2105377, this.task.hashCode());
                this.actions[0].f_93624_ = true;
                this.actions[0].m_93666_(TYPES[0][TaskScreen.this.activeTasks.getBoolean((Object)this.task.getTaskId()) ? 0 : 1]);
                this.actions[1].m_93666_(TYPES[1][1]);
                this.actions[1].f_93623_ = true;
            } else {
                this.actions[0].f_93624_ = false;
                this.actions[1].m_93666_(TYPES[1][0]);
                this.actions[1].f_93623_ = !TaskScreen.this.activeLevels.contains(this.task.getDimension());
            }
            int offset = left + 1;
            for (PregenButton button : this.actions) {
                if (!button.f_93624_) continue;
                button.m_252865_(offset);
                button.m_253211_(top + height - button.m_93694_() + 1);
                button.m_88315_(graphics, mouseX, mouseY, partialTicks);
                offset += 61;
            }
        }

        private Component getFailure(PregenButton button) {
            return button.f_93623_ ? null : TextUtil.translate("gui.chunk_pregen.task_screen.nodes.already_running", TextUtil.dimension(this.task.getDimension())).m_130940_(ChatFormatting.RED);
        }

        @Override
        public int getItemHeight() {
            return 70;
        }
    }

    public class DeletionNode
    extends TaskNode
    implements ITaskNode {
        IDeletionTask task;
        PregenButton[] actions = new PregenButton[]{this.addChild(new PregenButton(0, 0, 60, 14, TYPES[0][0], this::pauseResume)), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[1][1], this::startStop)).setTooltip(this::getFailure), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[2][0], this::remove))};

        public DeletionNode(IDeletionTask task) {
            this.task = task;
        }

        private void startStop(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(TaskScreen.this.activeTasks.containsKey((Object)this.task.getTaskId()) ? 2 : 3, this.task.getName()));
        }

        private void pauseResume(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(TaskScreen.this.activeTasks.getBoolean((Object)this.task.getTaskId()) ? 0 : 1, this.task.getName()));
        }

        private void remove(Button button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(4, this.task.getName()));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.task.getName().toLowerCase().startsWith(searchString) || this.searchResourceLocation(searchString, this.task.getDimension().m_135782_());
        }

        @Override
        public long getUsedMemory() {
            if (this.task instanceof DeletionExcess || this.task instanceof DeletionTimeOut) {
                long chunks = GenShape.SQUARE.calculateRadius(this.task.getMaxRadius());
                return Math.max(0L, TaskScreen.this.usedMemory.getLong(this.task.getDimension()) - TextUtil.getWorldSize(chunks, this.task.getDimension()));
            }
            return TextUtil.getWorldSize(this.task.getTaskSize(), this.task.getDimension());
        }

        @Override
        public ResourceKey<Level> dimension() {
            return this.task.getDimension();
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long chunks = this.task.getTaskSize();
            long used = TaskScreen.this.usedMemory.getLong(this.task.getDimension());
            long deletion = Math.min(this.getUsedMemory(), used);
            TaskScreen.this.drawSimpleRect(graphics, left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            float progress = Math.min((float)deletion / (float)used * 95.0f, 95.0f);
            TaskScreen.this.drawColorRegion(graphics, left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            int size = 95;
            MutableComponent mutableComponent = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.name", this.task.getName()).m_130940_(ChatFormatting.RED);
            float f = left + 2;
            float f2 = top - 1;
            float f3 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent, f, f2, f3, 9.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent2 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.dim", TextUtil.dimension(this.task.getDimension())).m_130940_(ChatFormatting.GOLD);
            float f4 = left + 2;
            float f5 = top + 10;
            float f6 = width - 102;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent2, f4, f5, f6, 9.0f, Align.START, -2105377, this.task.hashCode());
            if (!(this.task instanceof DeletionExcess) && !(this.task instanceof DeletionTimeOut)) {
                Area area = this.task.getArea();
                MutableComponent mutableComponent3 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.from", BasePregenScreen.NUMBERS.format(area.getMinX()), BasePregenScreen.NUMBERS.format(area.getMinZ())).m_130940_(ChatFormatting.DARK_AQUA);
                float f7 = left + 2;
                float f8 = top + 21;
                float f9 = width - 102;
                Objects.requireNonNull(this.font);
                TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent3, f7, f8, f9, 9.0f, Align.START, -2105377, this.task.hashCode());
                MutableComponent mutableComponent4 = TextUtil.translate("gui.chunk_pregen.task_screen.nodes.to", BasePregenScreen.NUMBERS.format(area.getMaxX()), BasePregenScreen.NUMBERS.format(area.getMaxZ())).m_130940_(ChatFormatting.DARK_AQUA);
                float f10 = left + 2;
                float f11 = top + 32;
                float f12 = width - 102;
                Objects.requireNonNull(this.font);
                TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent4, f10, f11, f12, 9.0f, Align.START, -2105377, this.task.hashCode());
            }
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(deletion), TextUtil.findBestMemory(used)), left + width - size - 2, top, size, 10.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.nodes.chunks", BasePregenScreen.NUMBERS.format(chunks)).m_130940_(ChatFormatting.BLUE), left + width - size - 2, top + 10, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            MutableComponent mutableComponent5 = this.task.getShapeName().m_6879_().m_130940_(ChatFormatting.GOLD);
            float f13 = left + width - size - 2;
            float f14 = top + 21;
            float f15 = size;
            Objects.requireNonNull(this.font);
            TaskScreen.this.drawUnalignedScrollText(graphics, (Component)mutableComponent5, f13, f14, f15, 9.0f, Align.START, -2105377, this.task.hashCode());
            if (TaskScreen.this.activeTasks.containsKey((Object)this.task.getTaskId())) {
                TaskScreen.this.drawUnalignedScrollText(graphics, (Component)TextUtil.translateStyled("gui.chunk_pregen.task_screen.nodes.active", ChatFormatting.RED), left + width - size - 2, top + 30, size, 12.0f, Align.START, -2105377, this.task.hashCode());
                this.actions[0].f_93624_ = true;
                this.actions[0].m_93666_(TYPES[0][TaskScreen.this.activeTasks.getBoolean((Object)this.task.getTaskId()) ? 0 : 1]);
                this.actions[1].m_93666_(TYPES[1][1]);
                this.actions[1].f_93623_ = true;
            } else {
                this.actions[0].f_93624_ = false;
                this.actions[1].m_93666_(TYPES[1][0]);
                this.actions[1].f_93623_ = !TaskScreen.this.activeLevels.contains(this.task.getDimension());
            }
            int offset = left + 1;
            for (PregenButton button : this.actions) {
                if (!button.f_93624_) continue;
                button.m_252865_(offset);
                button.m_253211_(top + height - button.m_93694_() + 1);
                button.m_88315_(graphics, mouseX, mouseY, partialTicks);
                offset += 61;
            }
        }

        private Component getFailure(PregenButton button) {
            return button.f_93623_ ? null : TextUtil.translate("gui.chunk_pregen.task_screen.nodes.already_running", TextUtil.dimension(this.task.getDimension())).m_130940_(ChatFormatting.RED);
        }

        @Override
        public int getItemHeight() {
            return 59;
        }
    }

    public static interface ITaskNode {
        public long getUsedMemory();

        public ResourceKey<Level> dimension();
    }
}

