/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.impl.RenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.OverlayPacket;
import pregenerator.common.utils.config.internal.PregenOverlay;

public class ProcessorRenderer {
    Map<ResourceKey<Level>, IProcessorInfo> byType = new Object2ObjectOpenHashMap();
    Map<UUID, IProcessorInfo> byTaskId = new Object2ObjectOpenHashMap();
    List<ResourceKey<Level>> infos = new ObjectArrayList();
    List<UUID> miniInfos = new ObjectArrayList();
    int ticker = 0;

    public void onInfoPacketReceived(byte[] data) {
        IProcessorInfo info;
        int i;
        if (data.length <= 0) {
            this.byType.clear();
            this.infos.clear();
            this.byTaskId.clear();
            this.infos.clear();
            return;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        ObjectOpenHashSet found = new ObjectOpenHashSet();
        ObjectOpenHashSet foundMini = new ObjectOpenHashSet();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
            found.add(type);
            info = this.byType.get(type);
            if (info != null) {
                buffer.readByte();
                info.read(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_())));
                continue;
            }
            info = IProcessorInfo.create(buffer.readByte());
            if (info == null) continue;
            info.setDimension((ResourceKey<Level>)type);
            info.read(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_())));
            this.byType.put((ResourceKey<Level>)type, info);
            this.infos.add((ResourceKey<Level>)type);
        }
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            UUID id = buffer.m_130259_();
            foundMini.add(id);
            info = this.byTaskId.get(id);
            if (info != null) {
                buffer.readByte();
                info.read(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_())));
                continue;
            }
            info = IProcessorInfo.create(buffer.readByte());
            if (info == null) continue;
            info.setTaskId(id);
            info.read(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_())));
            this.byTaskId.put(id, info);
            this.miniInfos.add(id);
        }
        this.infos.retainAll((Collection<?>)found);
        this.byType.keySet().retainAll((Collection<?>)found);
        this.miniInfos.retainAll((Collection<?>)foundMini);
        this.byTaskId.keySet().retainAll((Collection<?>)foundMini);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUIRenderer(GuiGraphics graphics) {
        IProcessorInfo info;
        int i;
        IProcessorInfo info2;
        int i2;
        if (!this.shouldRender()) {
            return;
        }
        int yLevel = 0;
        int m = this.infos.size();
        for (i2 = 0; i2 < m; ++i2) {
            info2 = this.byType.get(this.infos.get(i2));
            yLevel += info2 != null ? info2.getHeight() : 0;
        }
        m = this.miniInfos.size();
        for (i2 = 0; i2 < m; ++i2) {
            info2 = this.byTaskId.get(this.miniInfos.get(i2));
            yLevel += info2 != null ? info2.getHeight() : 0;
        }
        RenderHelper helper = new RenderHelper();
        helper.init(graphics);
        PregenOverlay overlay = PregenConfig.INSTANCE.pregenOverlay;
        float zoom = (float)overlay.getScale();
        float invZoom = 1.0f / zoom;
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_85837_(0.0, 0.0, 250.0);
        if (zoom != 1.0f) {
            stack.m_85841_(zoom, zoom, 1.0f);
        }
        yLevel = this.calculateHeight(overlay.vAlign(), (int)((float)this.getScreenHeight() * invZoom), yLevel);
        int screenX = (int)((float)this.getScreenWidth() * invZoom);
        int m2 = this.infos.size();
        for (i = 0; i < m2; ++i) {
            info = this.byType.get(this.infos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(overlay.hAlign(), screenX, info), yLevel, zoom);
            yLevel += info.getHeight();
        }
        m2 = this.miniInfos.size();
        for (i = 0; i < m2; ++i) {
            info = this.byTaskId.get(this.miniInfos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(overlay.hAlign(), screenX, info), yLevel, zoom);
            yLevel += info.getHeight();
        }
        stack.m_85849_();
    }

    public boolean onClick(int mouseX, int mouseY) {
        IProcessorInfo info;
        int i;
        if (!this.shouldRender()) {
            return false;
        }
        float scale = 1.0f / (float)PregenConfig.INSTANCE.pregenOverlay.getScale();
        mouseX = (int)((float)mouseX * scale);
        mouseY = (int)((float)mouseY * scale);
        int m = this.infos.size();
        for (i = 0; i < m; ++i) {
            info = this.byType.get(this.infos.get(i));
            if (info == null || !info.onClick(mouseX, mouseY)) continue;
            return true;
        }
        m = this.miniInfos.size();
        for (i = 0; i < m; ++i) {
            info = this.byTaskId.get(this.miniInfos.get(i));
            if (info == null || !info.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        if (!this.shouldRender() && NetworkManager.INSTANCE.isInstalledOnServer()) {
            return;
        }
        if (++this.ticker % PregenConfig.INSTANCE.pregenOverlay.getPollDelay() == 0) {
            NetworkManager.INSTANCE.sendToServer(new OverlayPacket.Request());
        }
    }

    public boolean shouldRender() {
        return PregenConfig.INSTANCE.pregenOverlay.isEnabled();
    }

    public void setVisible(boolean value) {
        PregenConfig.INSTANCE.pregenOverlay.setEnabled(value);
        PregenConfig.INSTANCE.save();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenHeight() {
        return Minecraft.m_91087_().m_91268_().m_85446_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }
}

