/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.DynamicPregenList;
import pregenerator.common.utils.misc.SmoothDouble;

public class PregenList<T extends ListEntry<T>>
extends DynamicPregenList<T>
implements BasePregenScreen.ITooltipProvider {
    ListState<T> state;

    public PregenList(Screen owner, int width, int height, int startY, int endY, ListState<T> state) {
        super(owner.getMinecraft(), width, height, startY, endY, state.getItemHeight());
        this.state = state;
        state.setOwner(this);
        this.applySearch(state.getSearch());
        if (state.isFramed()) {
            this.m_93471_(true);
        }
    }

    public PregenList(Screen owner, ListState<T> state) {
        this(owner, owner.f_96543_, owner.f_96544_, state.getTopPadding(), owner.f_96544_ - state.getBottomPadding(), state);
    }

    @Override
    public void provideTooltips(Consumer<Component> tooltips) {
        for (ListEntry entry : this.m_6702_()) {
            if (!(entry instanceof BasePregenScreen.ITooltipProvider)) continue;
            entry.provideTooltips(tooltips);
        }
    }

    public int m_5759_() {
        return this.state.getRowWidth();
    }

    protected boolean m_7987_(int p_94019_) {
        return this.state.isFramed();
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + this.state.getRowWidth() / 2 + 14;
    }

    public void m_93410_(double value) {
        this.state.setScrollAmount(Math.max(0.0, Math.min(value, (double)this.m_93518_())));
    }

    public double m_93517_() {
        return this.state.getScrollAmount();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.state.scrollAmount.update(partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void applySearch(String search) {
        this.state.updateSearch(search);
        if (search == null || search.isEmpty()) {
            this.m_5988_(this.state.getNodes());
            this.m_93410_(this.m_93517_());
            return;
        }
        String actualSearch = search.toLowerCase(Locale.ROOT);
        ObjectArrayList nodes = new ObjectArrayList();
        for (ListEntry entry : this.state.getNodes()) {
            if (!entry.containsSearch(actualSearch)) continue;
            nodes.add(entry);
        }
        this.m_5988_(nodes);
        this.m_93410_(this.m_93517_());
    }

    @Override
    protected void m_239227_(GuiGraphics graphics, int mouseX, int mouseY, float particalTicks) {
        if (this.state.getItemWidth() <= 0) {
            super.m_239227_(graphics, mouseX, mouseY, particalTicks);
            return;
        }
        this.hovered = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPos(mouseX, mouseY) : null;
        int entryWidth = this.state.getItemWidth();
        int minX = this.m_5747_();
        int width = this.m_5759_();
        int size = this.m_5773_();
        int yOff = this.f_93390_ + 4 - (int)this.m_93517_() + this.f_93395_;
        int xOffset = 0;
        int yOffset = 0;
        boolean hasRendered = false;
        BasePregenScreen.pushScissors(minX, this.f_93390_ + this.f_93395_, width, this.f_93391_ - this.f_93390_);
        for (int i = 0; i < size; ++i) {
            int minY;
            int maxY;
            if (xOffset + entryWidth > width) {
                yOffset += this.state.itemHeight;
                xOffset = 0;
            }
            if ((maxY = (minY = yOffset + yOff) + this.f_93389_) >= this.f_93390_ && minY <= this.f_93391_) {
                hasRendered = true;
                this.m_238964_(graphics, mouseX, mouseY, particalTicks, i, minX + xOffset, minY, entryWidth, this.state.itemHeight - 4);
            } else if (hasRendered) break;
            xOffset += entryWidth;
        }
        BasePregenScreen.popScissors();
    }

    @Override
    protected void centerScrollOn(T element) {
        if (this.state.getItemWidth() <= 0) {
            super.centerScrollOn(element);
            return;
        }
        int index = this.m_6702_().indexOf(element);
        if (index <= 0) {
            this.m_93410_(0.0);
            return;
        }
        this.m_93410_(((index /= this.m_5759_() / this.state.getItemWidth()) + 1) * this.state.getItemHeight() - (this.f_93391_ - this.f_93390_) / 2);
    }

    @Override
    protected T getEntryAtPos(double mouseX, double mouseY) {
        if (this.state.getItemWidth() <= 0) {
            return (T)((ListEntry)super.getEntryAtPos(mouseX, mouseY));
        }
        int centerWidth = this.m_5759_() / 2;
        int centerX = this.f_93393_ + this.f_93388_ / 2;
        int minX = centerX - centerWidth;
        int maxX = centerX + centerWidth;
        int position = (Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4) / this.state.getItemHeight() * (this.m_5759_() / this.state.getItemWidth());
        return (T)(mouseX < (double)this.m_5756_() && mouseX >= (double)minX && mouseX <= (double)maxX && position >= 0 && position < this.m_5773_() ? (ListEntry)this.m_6702_().get(position += (int)((mouseX - (double)minX) / (double)this.state.getItemWidth())) : null);
    }

    @Override
    public int m_5775_() {
        return this.state.getItemWidth() <= 0 ? super.m_5775_() : Mth.m_14165_((double)((double)this.m_5773_() / Math.floor((double)this.m_5759_() / (double)this.state.getItemWidth()))) * this.state.getItemHeight();
    }

    @Override
    public boolean m_6348_(double p_93491_, double p_93492_, int p_93493_) {
        if (this.scrolling) {
            this.state.scrollAmount.forceFinish();
        }
        return super.m_6348_(p_93491_, p_93492_, p_93493_);
    }

    public static class ListState<T extends ListEntry<T>> {
        List<T> nodes = new ObjectArrayList();
        String search = "";
        int top = 50;
        int bottom = 36;
        int itemHeight = 24;
        int itemWidth = 0;
        int rowWidth = 220;
        SmoothDouble scrollAmount = new SmoothDouble(0.25);
        boolean frame;
        PregenList<T> owner;

        @SafeVarargs
        public ListState(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public ListState(List<T> nodes) {
            this.nodes.addAll(nodes);
        }

        @SafeVarargs
        public ListState(int height, T ... nodes) {
            this.itemHeight = height;
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public ListState(int height, List<T> nodes) {
            this.nodes.addAll(nodes);
            this.itemHeight = height;
        }

        public ListState<T> add(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
            return this;
        }

        public ListState<T> add(List<T> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public ListState<T> replace(List<T> nodes) {
            this.nodes.clear();
            this.nodes.addAll(nodes);
            return this.search(this.search);
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public void sort(Comparator<T> sorter) {
            this.nodes.sort(sorter);
            if (this.owner != null) {
                this.owner.m_6702_().sort(sorter);
            }
        }

        public ListState<T> setItemHeight(int newHeight) {
            this.itemHeight = newHeight;
            return this;
        }

        public ListState<T> setItemWidth(int newWidth) {
            this.itemWidth = newWidth;
            return this;
        }

        public ListState<T> setRowWidth(int rowWidth) {
            this.rowWidth = rowWidth;
            return this;
        }

        public ListState<T> setFrame(boolean frame) {
            this.frame = frame;
            return this;
        }

        public ListState<T> setTopPadding(int value) {
            this.top = value;
            return this;
        }

        public ListState<T> setBottomPadding(int value) {
            this.bottom = value;
            return this;
        }

        public ListState<T> setScrollAmount(double value) {
            this.scrollAmount.setTarget(value);
            return this;
        }

        public double getScrollAmount() {
            return this.owner != null && this.owner.isScrolling() ? this.scrollAmount.getTarget() : this.scrollAmount.getValue();
        }

        public int getTopPadding() {
            return this.top;
        }

        public int getBottomPadding() {
            return this.bottom;
        }

        public int getRowWidth() {
            return this.rowWidth;
        }

        public int getItemHeight() {
            return this.itemHeight;
        }

        public int getItemWidth() {
            return this.itemWidth;
        }

        public boolean isFramed() {
            return this.frame;
        }

        void setOwner(PregenList<T> owner) {
            this.owner = owner;
        }

        public PregenList<T> getOwner() {
            return this.owner;
        }

        public boolean isSearching() {
            return this.search != null && !this.search.isEmpty();
        }

        public ListState<T> search(String search) {
            this.search = search;
            if (this.owner != null) {
                this.owner.applySearch(search);
            }
            return this;
        }

        public ListState<T> updateSearch() {
            if (this.owner != null) {
                this.owner.applySearch(this.search);
            }
            return this;
        }

        void updateSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }

        public List<T> getNodes() {
            return this.nodes;
        }
    }

    public static abstract class ListEntry<T extends ListEntry<T>>
    extends DynamicPregenList.DynamicEntry<T>
    implements BasePregenScreen.ITooltipProvider {
        List<GuiEventListener> children = new ObjectArrayList();
        protected Font font;

        public ListEntry() {
            this.font = Minecraft.m_91087_().f_91062_;
        }

        protected <E extends GuiEventListener> E addChild(E child) {
            this.children.add(child);
            return child;
        }

        @Override
        public void provideTooltips(Consumer<Component> tooltips) {
            for (GuiEventListener listener : this.children) {
                if (!(listener instanceof BasePregenScreen.ITooltipProvider)) continue;
                ((BasePregenScreen.ITooltipProvider)listener).provideTooltips(tooltips);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ObjectLists.emptyList();
        }

        protected abstract boolean containsSearch(String var1);

        @Override
        public abstract void m_6311_(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);
    }
}

